/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.converters.WebflowConverterUtil;
import com.intellij.spring.webflow.model.converters.WebflowLookupUtil;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentFlowsConverter
extends DelimitedListConverter<Flow> {
    public ParentFlowsConverter() {
        super(",");
    }

    protected Flow convertString(@Nullable String string, ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        return WebflowDomModelManager.findFlowByName(module, string);
    }

    protected String toString(@Nullable Flow flow) {
        return flow == null ? null : WebflowUtil.getFlowName(flow);
    }

    protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<? extends List<Flow>> listGenericDomValue) {
        List flows = (List)listGenericDomValue.getValue();
        if (flows == null) {
            return EMPTY_ARRAY;
        }
        List exceptedFiles = ContainerUtil.mapNotNull((Collection)flows, DomUtil::getFile);
        Module module = context.getModule();
        if (module == null) {
            return EMPTY_ARRAY;
        }
        List<Flow> all = WebflowUtil.getAllFlows(module, ContainerUtil.concat((List)exceptedFiles, Collections.singletonList(context.getFile().getOriginalFile())));
        return WebflowLookupUtil.forFlows(all);
    }

    protected PsiElement resolveReference(@Nullable Flow flow, ConvertContext context) {
        return flow == null ? null : WebflowUtil.resolveFlow(flow);
    }

    protected String getUnresolvedMessage(String value) {
        return WebflowBundle.message("parent.flows.converter.cannot.find.flow", value);
    }

    @NotNull
    protected PsiReference createPsiReference(PsiElement element, int start, int end, ConvertContext context, GenericDomValue<List<Flow>> genericDomValue, boolean delimitersOnly) {
        return new DelimitedListConverter.MyPsiReference(element, new TextRange(start, end), context, genericDomValue, delimitersOnly){

            public boolean isReferenceTo(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.isReferenceTo(element) || WebflowConverterUtil.isCustomFlowIdReference(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/model/converters/ParentFlowsConverter$1", "isReferenceTo"));
            }
        };
    }

    protected PsiElement referenceBindToElement(PsiReference psiReference, PsiElement element, Function<? super PsiElement, ? extends PsiElement> superBindToElementFunction, Function<? super String, ? extends PsiElement> superElementRenameFunction) throws IncorrectOperationException {
        VirtualFile file;
        if (element instanceof XmlFile && (file = ((XmlFile)element).getVirtualFile()) != null) {
            return this.referenceHandleElementRename(psiReference, file.getNameWithoutExtension(), superElementRenameFunction);
        }
        return psiReference.getElement();
    }

    protected PsiElement referenceHandleElementRename(PsiReference psiReference, String newName, Function<? super String, ? extends PsiElement> superHandleElementRename) throws IncorrectOperationException {
        if (psiReference.resolve() instanceof XmlFile) {
            String name = FileUtilRt.getNameWithoutExtension((String)newName);
            return (PsiElement)superHandleElementRename.fun((Object)name);
        }
        return (PsiElement)superHandleElementRename.fun((Object)newName);
    }
}

