/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.impl.WebflowDomModelFactory;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.ViewOwner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowDomModelManager {
    public static boolean isWebflow(@NotNull XmlFile file) {
        if (file == null) {
            WebflowDomModelManager.$$$reportNull$$$0(0);
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement(file, Flow.class) != null;
    }

    @Nullable
    public static WebflowModel getWebflowModel(@NotNull XmlFile file) {
        if (file == null) {
            WebflowDomModelManager.$$$reportNull$$$0(1);
        }
        return WebflowDomModelFactory.getModelByConfigFile(file);
    }

    public static List<WebflowModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            WebflowDomModelManager.$$$reportNull$$$0(2);
        }
        return WebflowDomModelFactory.getAllModels(module);
    }

    public static List<WebflowModel> getModelsForView(@NotNull PsiFile viewFile) {
        Module module;
        if (viewFile == null) {
            WebflowDomModelManager.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)viewFile)) == null) {
            return Collections.emptyList();
        }
        List<WebflowModel> allModels = WebflowDomModelFactory.getAllModels(module);
        return ContainerUtil.filter(allModels, webflowModel -> {
            Flow flow = webflowModel.getFlow();
            List viewOwners = DomUtil.getDefinedChildrenOfType((DomElement)flow, ViewOwner.class, (boolean)true, (boolean)false);
            return ContainerUtil.exists((Iterable)viewOwners, owner -> Comparing.equal((Object)owner.getResolvedView(), (Object)viewFile));
        });
    }

    public static Flow findFlowByName(@NotNull Module module, String name) {
        WebflowModel webflowModel;
        if (module == null) {
            WebflowDomModelManager.$$$reportNull$$$0(4);
        }
        return (webflowModel = (WebflowModel)ContainerUtil.find(WebflowDomModelManager.getAllModels(module), model -> Objects.equals(model.getName(), name))) != null ? webflowModel.getFlow() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/webflow/model/WebflowDomModelManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isWebflow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getWebflowModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllModels";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getModelsForView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findFlowByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

