/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.inspections.WebflowInspectionToolProvider;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.resources.WebflowBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebflowModelInspectionValidator
extends InspectionValidator {
    public WebflowModelInspectionValidator() {
        super("Spring Web Flow", WebflowBundle.message("compiler.validator.flow.name", new Object[0]), WebflowBundle.message("compiler.validator.flow.progress", new Object[0]));
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            WebflowModelInspectionValidator.$$$reportNull$$$0(0);
        }
        return true;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        ArrayList<VirtualFile> toProcess = new ArrayList<VirtualFile>();
        for (Module module : context.getCompileScope().getAffectedModules()) {
            List<WebflowModel> models = WebflowDomModelManager.getAllModels(module);
            for (WebflowModel model : models) {
                XmlFile flowXml = model.getFlowFile();
                toProcess.add(flowXml.getVirtualFile());
            }
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded(toProcess, (CompileContext)context);
        return toProcess;
    }

    public Class<? extends LocalInspectionTool> @NotNull [] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = new WebflowInspectionToolProvider().getInspectionClasses();
        if (classArray == null) {
            WebflowModelInspectionValidator.$$$reportNull$$$0(1);
        }
        return classArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/inspections/WebflowModelInspectionValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/inspections/WebflowModelInspectionValidator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnScope";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

