/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.el.scopes.providers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.el.scopes.WebflowScope;
import com.intellij.util.xml.DomElement;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebflowScopeProvider {
    private final WebflowScope webflowScope;
    @Nls
    private final String typeName;

    protected WebflowScopeProvider(WebflowScope scope, @Nls String typeName) {
        this.webflowScope = scope;
        this.typeName = typeName;
    }

    public final WebflowScope getScope() {
        return this.webflowScope;
    }

    public boolean accept(@Nullable DomElement domElement) {
        return !this.getScopes(domElement).isEmpty();
    }

    @Nullable
    public String getVariableName(String value) {
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return null;
        }
        String s = StringUtil.trimStart((String)value, (String)(this.webflowScope.getName() + "."));
        return s.equals(value) || s.contains(".") ? null : s;
    }

    @NotNull
    public abstract Set<DomElement> getScopes(@Nullable DomElement var1);

    @Nullable
    public abstract PsiElement getOrCreateScopeVariable(XmlFile var1, String var2, PsiElement var3);

    @Nls
    protected String getTypeName() {
        return this.typeName;
    }
}

