/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.el.scopes.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.el.ELVariablesCollectorUtils;
import com.intellij.spring.webflow.el.scopes.WebflowScope;
import com.intellij.spring.webflow.el.scopes.providers.FakeScopePsiVariable;
import com.intellij.spring.webflow.el.scopes.providers.WebflowScopeProvider;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.xml.Evaluate;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFileScopeProvider
extends WebflowScopeProvider {
    private final Key<CachedValue<Map<String, PsiElement>>> key = Key.create((String)this.getClass().getSimpleName());

    protected BaseFileScopeProvider(WebflowScope webflowScope, @Nls String typeName) {
        super(webflowScope, typeName);
    }

    @Override
    @NotNull
    public Set<DomElement> getScopes(@Nullable DomElement domElement) {
        if (domElement == null) {
            Set<DomElement> set = Collections.emptySet();
            if (set == null) {
                BaseFileScopeProvider.$$$reportNull$$$0(0);
            }
            return set;
        }
        Flow flow = (Flow)domElement.getParentOfType(Flow.class, false);
        if (flow == null) {
            Set<DomElement> set = Collections.emptySet();
            if (set == null) {
                BaseFileScopeProvider.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<DomElement> set = Collections.singleton(DomUtil.getOriginalElement((DomElement)flow));
        if (set == null) {
            BaseFileScopeProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public PsiElement getOrCreateScopeVariable(XmlFile psiFile, String varName, PsiElement host) {
        Map map = (Map)CachedValuesManager.getManager((Project)psiFile.getProject()).getCachedValue((UserDataHolder)psiFile, this.key, () -> new CachedValueProvider.Result(this.collectScopeVariables(psiFile), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
        return (PsiElement)map.get(varName);
    }

    private Map<String, PsiElement> collectScopeVariables(XmlFile psiFile) {
        String varName;
        WebflowModel webflowModel = WebflowDomModelManager.getWebflowModel(psiFile);
        if (webflowModel == null) {
            return Collections.emptyMap();
        }
        HashMap<String, PsiElement> map = new HashMap<String, PsiElement>();
        for (Evaluate evaluate : ELVariablesCollectorUtils.collectEvaluates(webflowModel, false)) {
            varName = this.getVariableName(evaluate.getResult().getStringValue());
            if (StringUtil.isEmptyOrSpaces((String)varName)) continue;
            map.put(varName, (PsiElement)new FakeScopePsiVariable(psiFile, (PsiElement)evaluate.getResult().getXmlAttributeValue(), varName, this.getTypeName()));
        }
        for (com.intellij.spring.webflow.model.xml.Set set : ELVariablesCollectorUtils.collectSetters(webflowModel, false)) {
            varName = this.getVariableName(set.getName().getStringValue());
            if (StringUtil.isEmptyOrSpaces((String)varName)) continue;
            map.put(varName, (PsiElement)new FakeScopePsiVariable(psiFile, (PsiElement)set.getName().getXmlAttributeValue(), varName, this.getTypeName()));
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/scopes/providers/BaseFileScopeProvider", "getScopes"));
    }
}

