/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.el.scopes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.spring.webflow.el.scopes.providers.ConversationScopeProvider;
import com.intellij.spring.webflow.el.scopes.providers.FlashScopeProvider;
import com.intellij.spring.webflow.el.scopes.providers.FlowScopeProvider;
import com.intellij.spring.webflow.el.scopes.providers.RequestParametersProvider;
import com.intellij.spring.webflow.el.scopes.providers.RequestScopeProvider;
import com.intellij.spring.webflow.el.scopes.providers.ViewScopeProvider;
import com.intellij.spring.webflow.el.scopes.providers.WebflowScopeProvider;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowScopeProviderManager {
    private final List<WebflowScopeProvider> myProviders = new ArrayList<WebflowScopeProvider>();

    @NotNull
    public static WebflowScopeProviderManager getService() {
        WebflowScopeProviderManager webflowScopeProviderManager = (WebflowScopeProviderManager)ApplicationManager.getApplication().getService(WebflowScopeProviderManager.class);
        if (webflowScopeProviderManager == null) {
            WebflowScopeProviderManager.$$$reportNull$$$0(0);
        }
        return webflowScopeProviderManager;
    }

    public WebflowScopeProviderManager() {
        this.registerScopeProvider(new RequestScopeProvider());
        this.registerScopeProvider(new FlashScopeProvider());
        this.registerScopeProvider(new ViewScopeProvider());
        this.registerScopeProvider(new FlowScopeProvider());
        this.registerScopeProvider(new ConversationScopeProvider());
        this.registerScopeProvider(new RequestParametersProvider());
    }

    public List<WebflowScopeProvider> getAvailableProviders(@Nullable DomElement domElement) {
        return ContainerUtil.mapNotNull(this.myProviders, (Function)((NullableFunction)webflowScopeProvider -> webflowScopeProvider.accept(domElement) ? webflowScopeProvider : null));
    }

    public List<WebflowScopeProvider> getProviders() {
        return this.myProviders;
    }

    @Nullable
    public WebflowScopeProvider getProvider(String scopeName) {
        for (WebflowScopeProvider provider : this.myProviders) {
            if (!provider.getScope().getName().equals(scopeName)) continue;
            return provider;
        }
        return null;
    }

    private void registerScopeProvider(WebflowScopeProvider provider) {
        this.myProviders.add(provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/scopes/WebflowScopeProviderManager", "getService"));
    }
}

