/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.editor;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.model.xml.TransitionOwner;
import com.intellij.spring.webflow.model.xml.WebflowDomElement;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;

public class CreateTransitionDialog
extends DialogWrapper {
    private JComboBox<TransitionOwner> source;
    private JPanel myPanel;
    private JComboBox<Identified> target;
    private JTextField on;
    private static final Comparator<Identified> ID_COMPARATOR = (identified, identified1) -> Comparing.compare((Comparable)((Object)identified.getId().getStringValue()), (Comparable)((Object)identified1.getId().getStringValue()));

    public CreateTransitionDialog(@Nullable Project project, List<? extends TransitionOwner> sources, TransitionOwner sourceElement, List<? extends Identified> targets, Identified to) {
        super(project);
        this.$$$setupUI$$$();
        this.init();
        CreateTransitionDialog.setupComboBox(this.source, sources);
        this.source.setSelectedItem(sourceElement);
        targets.sort(ID_COMPARATOR);
        CreateTransitionDialog.setupComboBox(this.target, targets);
        this.target.setSelectedItem(to);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static <T extends WebflowDomElement> void setupComboBox(JComboBox<T> comboBox, List<? extends T> values) {
        comboBox.setModel((ComboBoxModel<T>)new CollectionComboBoxModel(values));
        SimpleListCellRenderer myRenderer = SimpleListCellRenderer.create((String)"", value -> value.getPresentation().getElementName());
        comboBox.setRenderer((ListCellRenderer<T>)myRenderer);
        comboBox.setMaximumRowCount(20);
        new ComboboxSpeedSearch(comboBox){

            protected String getElementText(Object element) {
                return StringUtil.notNullize((String)((Identified)element).getPresentation().getElementName());
            }
        };
    }

    public JComponent getPreferredFocusedComponent() {
        return this.on;
    }

    public TransitionOwner getSelectedSource() {
        return (TransitionOwner)this.source.getSelectedItem();
    }

    public Identified getSelectedTarget() {
        return (Identified)this.target.getSelectedItem();
    }

    public String getOn() {
        return this.on.getText();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JComboBox jComboBox = new JComboBox();
        this.source = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WebflowBundle", CreateTransitionDialog.class).getString("create.transition.dialog.from"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WebflowBundle", CreateTransitionDialog.class).getString("create.transition.dialog.to"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.target = jComboBox2;
        jPanel.add(jComboBox2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.on = jTextField = new JTextField();
        jTextField.setColumns(20);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/WebflowBundle", CreateTransitionDialog.class).getString("create.transition.dialog.on"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jComboBox);
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

