/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.beans.wrappers;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.webflow.model.WebflowModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebflowElementWrapper<T>
implements UserDataHolder {
    private final UserDataHolderBase userDataHolderBase = new UserDataHolderBase();
    protected static final String DELIMITER = ";";
    protected static final String VALUE_DELIMITER = "=";

    @NotNull
    public abstract T getElement();

    @NotNull
    @NlsSafe
    public abstract String getName();

    @Nullable
    public abstract String getFqn();

    @NotNull
    public abstract List<WebflowModel> getFlowModels();

    @Nullable
    public Icon getIcon() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public <U> U getUserData(@NotNull Key<U> key) {
        if (key == null) {
            WebflowElementWrapper.$$$reportNull$$$0(0);
        }
        return (U)this.userDataHolderBase.getUserData(key);
    }

    public <U> void putUserData(@NotNull Key<U> key, @Nullable U value) {
        if (key == null) {
            WebflowElementWrapper.$$$reportNull$$$0(1);
        }
        this.userDataHolderBase.putUserData(key, value);
    }

    @NotNull
    protected static Map<String, String> split(@NotNull String fqn) {
        if (fqn == null) {
            WebflowElementWrapper.$$$reportNull$$$0(2);
        }
        List strings = StringUtil.split((String)fqn, (String)DELIMITER);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : strings) {
            Pair<String, String> pair = WebflowElementWrapper.getPair(string);
            if (pair == null) continue;
            map.put((String)pair.first, (String)pair.second);
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            WebflowElementWrapper.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @Nullable
    private static Pair<String, String> getPair(@NotNull String str) {
        int i;
        if (str == null) {
            WebflowElementWrapper.$$$reportNull$$$0(4);
        }
        if ((i = str.indexOf(VALUE_DELIMITER)) > 0 && i < str.length() - 1) {
            String key = str.substring(0, i).trim();
            String value = str.substring(i + 1).trim();
            if (!StringUtil.isEmptyOrSpaces((String)key) && !StringUtil.isEmptyOrSpaces((String)value)) {
                return Pair.create((Object)key, (Object)value);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebflowElementWrapper wrapper = (WebflowElementWrapper)o;
        if (!this.isValid() || !wrapper.isValid()) {
            return false;
        }
        return this.getElement().equals(wrapper.getElement());
    }

    public int hashCode() {
        return this.isValid() ? this.getElement().hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowElementWrapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowElementWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPair";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

