/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.actions.patterns;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.actions.patterns.frameworks.AbstractFrameworkIntegrationAction;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import com.intellij.spring.webflow.actions.patterns.WebflowSpringBeanGenerateProvider;
import com.intellij.spring.webflow.resources.WebflowBundle;
import icons.SpringWebflowIcons;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddWebflowAction
extends AbstractFrameworkIntegrationAction {
    @NonNls
    private static final String WEBFLOW_STRING_ID = "webflow";

    @NonNls
    protected String[] getBeansClassNames() {
        return new String[]{"org.springframework.webflow.definition.registry.FlowDefinitionRegistry"};
    }

    public LibrariesInfo getLibrariesInfo(Module module) {
        return new LibrariesInfo(LibraryInfo.EMPTY_ARRAY, module, WEBFLOW_STRING_ID);
    }

    public List<TemplateInfo> getTemplateInfos(Module module) {
        LinkedList<TemplateInfo> infos = new LinkedList<TemplateInfo>();
        TemplateSettings settings = TemplateSettings.getInstance();
        TemplateInfo flowRegistry = new TemplateInfo(module, settings.getTemplateById("flow-registry"), WebflowBundle.message("spring.patterns.webflow.registry", new Object[0]), null);
        TemplateInfo flowExecutor = new TemplateInfo(module, settings.getTemplateById("flow-executor"), WebflowBundle.message("spring.patterns.webflow.executor", new Object[0]), null);
        TemplateInfo flowBuilderServices = new TemplateInfo(module, settings.getTemplateById("flow-builder-services"), WebflowBundle.message("spring.patterns.webflow.builder.services", new Object[0]), null);
        TemplateInfo conversationService = new TemplateInfo(module, settings.getTemplateById("conversation-service"), WebflowBundle.message("spring.patterns.webflow.services.conversion.service", new Object[0]), null, false);
        TemplateInfo expressionParser = new TemplateInfo(module, settings.getTemplateById("expression-parser"), WebflowBundle.message("spring.patterns.webflow.services.expression.parser", new Object[0]), null, false);
        TemplateInfo factoryCreator = new TemplateInfo(module, settings.getTemplateById("factory-creator"), WebflowBundle.message("spring.patterns.webflow.services.view.factory.creator", new Object[0]), null, false);
        TemplateInfo executionListener = new TemplateInfo(module, settings.getTemplateById("flow-execution-listener"), WebflowBundle.message("spring.patterns.webflow.execution.listener", new Object[0]), null, false);
        infos.add(flowBuilderServices);
        infos.add(flowRegistry);
        infos.add(executionListener);
        infos.add(flowExecutor);
        infos.add(conversationService);
        infos.add(expressionParser);
        infos.add(factoryCreator);
        return infos;
    }

    @NotNull
    public Map<String, String> getPredefinedVars(@NotNull Module module, XmlFile xmlFile) {
        if (module == null) {
            AddWebflowAction.$$$reportNull$$$0(0);
        }
        Map map = super.getPredefinedVars(module, xmlFile);
        Map<String, String> map2 = WebflowSpringBeanGenerateProvider.addWebflowNamespacePrefix((PsiFile)xmlFile, map);
        if (map2 == null) {
            AddWebflowAction.$$$reportNull$$$0(1);
        }
        return map2;
    }

    public String getDescription() {
        return WebflowBundle.message("spring.patterns.webflow.group.name", new Object[0]);
    }

    protected boolean accept(@NotNull XmlFile file) {
        if (file == null) {
            AddWebflowAction.$$$reportNull$$$0(2);
        }
        return super.accept(file) && WebflowSpringBeanGenerateProvider.getWebflowNamespacePrefix(file) != null;
    }

    @Nullable
    protected Icon getIcon() {
        return SpringWebflowIcons.SpringWebFlow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/actions/patterns/AddWebflowAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/actions/patterns/AddWebflowAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedVars";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

