/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.actions;

import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.webflow.model.WebflowVersion;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.spring.webflow.util.WebflowVersionDetector;
import icons.SpringWebflowIcons;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateWebflowFileAction
extends CreateFileAction {
    public CreateWebflowFileAction() {
        super(WebflowBundle.messagePointer("flow.new.file", new Object[0]), WebflowBundle.messagePointer("flow.new.file.description", new Object[0]), SpringWebflowIcons.SpringWebFlowFile);
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return SpringCommonUtils.hasSpringFacet((Module)module) && WebflowUtil.isWebFlowAvailable(module);
    }

    protected PsiElement @NotNull [] create(@NotNull String newName, PsiDirectory directory) throws Exception {
        if (newName == null) {
            CreateWebflowFileAction.$$$reportNull$$$0(0);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        assert (module != null) : directory;
        WebflowVersion webflowVersion = WebflowVersionDetector.detect(module);
        String templateName = webflowVersion.isAtLeast(WebflowVersion.Webflow_2_0) ? (webflowVersion.isAtLeast(WebflowVersion.Webflow_2_4) ? "webflow.2_4.xml" : "webflow.2_0.xml") : "webflow.1_0.xml";
        FileTemplate template = FileTemplateManager.getInstance((Project)directory.getProject()).getJ2eeTemplate(templateName);
        @NonNls String fileName = this.getFileName(newName);
        PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, null, (PsiDirectory)directory);
        PsiElement[] psiElementArray = new PsiElement[]{psiElement};
        if (psiElementArray == null) {
            CreateWebflowFileAction.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    protected String getDefaultExtension() {
        return "xml";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/actions/CreateWebflowFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/actions/CreateWebflowFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

