/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace.viz;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("#.###");

    public static String makeHumanReadable(long time, long span, TimeUnit timeUnits) {
        double scale;
        String units;
        if (timeUnits.toSeconds(span) > 0L) {
            units = "s";
            scale = 1.0E-9;
        } else if (timeUnits.toMillis(span) > 0L) {
            units = "ms";
            scale = 1.0E-6;
        } else {
            units = "us";
            scale = 0.001;
        }
        return String.format("%1$s %2$s", TimeUtils.formatTime(timeUnits.toNanos(time), scale), units);
    }

    private static String formatTime(long nsecs, double scale) {
        return TIME_FORMATTER.format((double)nsecs * scale);
    }
}

