/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.runConfiguration;

import com.google.common.base.Strings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersManager;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianJUnitConfigurationPanel;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfiguration;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfigurationCoordinator;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfigurationTypeUtil;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianTestFrameworkRunConfiguration;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianJUnitRunConfiguration
extends JUnitConfiguration
implements ArquillianTestFrameworkRunConfiguration {
    public ArquillianRunConfiguration arquillianRunConfiguration;

    public ArquillianJUnitRunConfiguration(String name, Project project, @Nls String containerStateName, ConfigurationFactory configurationFactory) {
        super(name, project, configurationFactory);
        this.setNameChangedByUser(false);
        this.arquillianRunConfiguration = ArquillianRunConfigurationTypeUtil.getInstance((Project)project).createArquillianRunConfiguration(containerStateName);
    }

    public String suggestedName() {
        String containerName = this.arquillianRunConfiguration.getContainerStateName();
        String suggestedName = super.suggestedName();
        return Strings.isNullOrEmpty((String)containerName) ? suggestedName : containerName + ": " + suggestedName;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String containerStateName = this.arquillianRunConfiguration.getContainerStateName();
        if (Strings.isNullOrEmpty((String)containerStateName)) {
            throw new RuntimeConfigurationError(ArquillianBundle.message((String)"arquillian.container.configuration.not.specified", (Object[])new Object[0]));
        }
        if (ArquillianContainersManager.getInstance((Project)this.getProject()).findStateByName(containerStateName) == null) {
            throw new RuntimeConfigurationError(ArquillianBundle.message((String)"arquillian.container.configuration.not.found", (Object[])new Object[]{containerStateName}));
        }
    }

    public TestObject getTestObject() {
        return this.setupRemoteConnection(super.getTestObject());
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return null;
    }

    public TestObject getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            ArquillianJUnitRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            ArquillianJUnitRunConfiguration.$$$reportNull$$$0(1);
        }
        return this.setupRemoteConnection(super.getState(executor, env));
    }

    private TestObject setupRemoteConnection(TestObject state) {
        ArquillianRunConfigurationCoordinator coordinator = new ArquillianRunConfigurationCoordinator(this.getProject());
        state.setRemoteConnectionCreator(coordinator.getRemoteConnectionCreator(this.arquillianRunConfiguration));
        return state;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ArquillianBundle.message((String)"arquillian.run.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ArquillianJUnitConfigurationPanel(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new JUnitConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            ArquillianJUnitRunConfiguration.$$$reportNull$$$0(2);
        }
        return settingsEditorGroup;
    }

    public ArquillianRunConfiguration getArquillianRunConfiguration() {
        return this.arquillianRunConfiguration;
    }

    public ArquillianRunConfiguration getRunConfiguration() {
        return this.arquillianRunConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianJUnitRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianJUnitRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

