/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleIdeManager;
import org.jetbrains.plugins.gradle.service.execution.GradleDebugSettingsEditor;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunConfiguration
extends ExternalSystemRunConfiguration
implements SMRunnerConsolePropertiesProvider {
    public static final String DEBUG_FLAG_NAME = "GradleScriptDebugEnabled";
    public static final String DEBUG_ALL_NAME = "DebugAllEnabled";
    public static final Key<Boolean> DEBUG_FLAG_KEY = Key.create((String)"DEBUG_GRADLE_SCRIPT");
    public static final Key<Boolean> DEBUG_ALL_KEY = Key.create((String)"DEBUG_ALL_TASKS");
    @ApiStatus.Internal
    public static final Key<String> DEBUGGER_PARAMETERS_KEY = Key.create((String)"DEBUGGER_PARAMETERS");
    private boolean isDebugAllEnabled = false;

    public GradleRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(GradleConstants.SYSTEM_ID, project, factory, name);
        this.setDebugServerProcess(true);
        this.setReattachDebugProcess(true);
    }

    public boolean isScriptDebugEnabled() {
        return this.isDebugServerProcess();
    }

    public void setScriptDebugEnabled(boolean scriptDebugEnabled) {
        this.setDebugServerProcess(scriptDebugEnabled);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            GradleRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            GradleRunConfiguration.$$$reportNull$$$0(1);
        }
        this.putUserData(DEBUG_FLAG_KEY, this.isDebugServerProcess());
        this.putUserData(DEBUG_ALL_KEY, this.isDebugAllEnabled);
        return super.getState(executor, env);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Element debugAll;
        if (element == null) {
            GradleRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        Element child = element.getChild(DEBUG_FLAG_NAME);
        if (child != null) {
            this.setDebugServerProcess(Boolean.valueOf(child.getText()));
        }
        if ((debugAll = element.getChild(DEBUG_ALL_NAME)) != null) {
            this.isDebugAllEnabled = Boolean.valueOf(debugAll.getText());
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GradleRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        Element debugAll = new Element(DEBUG_ALL_NAME);
        debugAll.setText(String.valueOf(this.isDebugAllEnabled));
        element.addContent(debugAll);
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        SettingsEditor editor = super.getConfigurationEditor();
        if (editor instanceof SettingsEditorGroup) {
            SettingsEditorGroup group = (SettingsEditorGroup)editor;
            group.addEditor(GradleBundle.message("gradle.settings.title.debug", new Object[0]), (SettingsEditor)new GradleDebugSettingsEditor());
        }
        SettingsEditor settingsEditor = editor;
        if (settingsEditor == null) {
            GradleRunConfiguration.$$$reportNull$$$0(4);
        }
        return settingsEditor;
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            GradleRunConfiguration.$$$reportNull$$$0(5);
        }
        SMTRunnerConsoleProperties sMTRunnerConsoleProperties = GradleIdeManager.getInstance().createTestConsoleProperties(this.getProject(), executor, (RunConfiguration)this);
        if (sMTRunnerConsoleProperties == null) {
            GradleRunConfiguration.$$$reportNull$$$0(6);
        }
        return sMTRunnerConsoleProperties;
    }

    public boolean isDebugAllEnabled() {
        return this.isDebugAllEnabled;
    }

    public void setDebugAllEnabled(boolean debugAllEnabled) {
        this.isDebugAllEnabled = debugAllEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestConsoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

