/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.osgi.patterns;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.actions.generate.SpringBeanGenerateProvider;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.xml.util.XmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OsgiSpringBeanGenerateProvider
extends SpringBeanGenerateProvider {
    public static final String OSGI_NS_PREFIX = "OSGI_NS_PREFIX";

    public OsgiSpringBeanGenerateProvider(@NlsActions.ActionText String text, @NonNls String template) {
        super(text, template);
    }

    protected Map<String, String> getPredefinedVars(@Nullable DomElement parentDomElement, @Nullable SpringBean springBean, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            OsgiSpringBeanGenerateProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OsgiSpringBeanGenerateProvider.$$$reportNull$$$0(1);
        }
        Map map = super.getPredefinedVars(parentDomElement, (DomElement)springBean, editor, file);
        return OsgiSpringBeanGenerateProvider.addOsgiNamespacePrefix(file, map);
    }

    public static Map<String, String> addOsgiNamespacePrefix(@NotNull PsiFile file, @NotNull Map<String, String> map) {
        String prefix;
        if (file == null) {
            OsgiSpringBeanGenerateProvider.$$$reportNull$$$0(2);
        }
        if (map == null) {
            OsgiSpringBeanGenerateProvider.$$$reportNull$$$0(3);
        }
        if (file instanceof XmlFile && !StringUtil.isEmptyOrSpaces((String)(prefix = OsgiSpringBeanGenerateProvider.getOsgiNamespacePrefix((XmlFile)file)))) {
            map.put(OSGI_NS_PREFIX, prefix + ":");
        }
        return map;
    }

    @Nullable
    public static String getOsgiNamespacePrefix(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            OsgiSpringBeanGenerateProvider.$$$reportNull$$$0(4);
        }
        return XmlUtil.findNamespacePrefixByURI((XmlFile)xmlFile, (String)"http://www.springframework.org/schema/osgi");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/osgi/patterns/OsgiSpringBeanGenerateProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPredefinedVars";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addOsgiNamespacePrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOsgiNamespacePrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

