/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.osgi.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.osgi.model.xml.BaseOsgiReference;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReferenceEffectiveTypeProvider
extends SpringBeanEffectiveTypeProvider {
    @NonNls
    private final String[] UnboxingReferencesClassNames = new String[]{"org.osgi.framework.ServiceReference"};

    public boolean processEffectiveTypes(@NotNull CommonSpringBean bean, @NotNull Processor<PsiType> processor) {
        if (bean == null) {
            ReferenceEffectiveTypeProvider.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            ReferenceEffectiveTypeProvider.$$$reportNull$$$0(1);
        }
        if (!(bean instanceof BaseOsgiReference)) {
            return true;
        }
        Project project = bean.getPsiManager().getProject();
        BaseOsgiReference reference = (BaseOsgiReference)bean;
        PsiClass psiClass = (PsiClass)reference.getInterface().getValue();
        if (psiClass != null && !processor.process((Object)PsiTypesUtil.getClassType((PsiClass)psiClass))) {
            return false;
        }
        for (SpringValue value : reference.getInterfaces().getValues()) {
            if (ReferenceEffectiveTypeProvider.processClass(processor, project, value.getStringValue())) continue;
            return false;
        }
        for (String className : this.UnboxingReferencesClassNames) {
            if (ReferenceEffectiveTypeProvider.processClass(processor, project, className)) continue;
            return false;
        }
        return true;
    }

    private static boolean processClass(@NotNull Processor<PsiType> processor, Project project, String className) {
        PsiClass aClass;
        if (processor == null) {
            ReferenceEffectiveTypeProvider.$$$reportNull$$$0(2);
        }
        return StringUtil.isEmptyOrSpaces((String)className) || (aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project))) == null || processor.process((Object)PsiTypesUtil.getClassType((PsiClass)aClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/osgi/model/ReferenceEffectiveTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processEffectiveTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

