/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.konan.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.konan.KonanLog;
import com.jetbrains.konan.debugger.ComputationState;
import com.jetbrains.konan.debugger.KonanLocalDebugProcess;
import com.jetbrains.konan.debugger.KonanStackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010$\u001a\u00020\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\u0006\u0010\u001f\u001a\u00020 H\u0002J\n\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010+\u001a\u00020\u001cH\u0002R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/konan/debugger/KonanExecutionStack;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "suspensionCause", "Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;", "process", "Lcom/jetbrains/konan/debugger/KonanLocalDebugProcess;", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;Lcom/jetbrains/konan/debugger/KonanLocalDebugProcess;)V", "cachedFirstFrameIndex", "", "Ljava/lang/Integer;", "cachedFrames", "Ljava/util/ArrayList;", "Lcom/jetbrains/konan/debugger/KonanStackFrame;", "currentCount", "currentFrom", "hasMoreFrames", "", "getProcess", "()Lcom/jetbrains/konan/debugger/KonanLocalDebugProcess;", "selectedFrame", "state", "Lcom/jetbrains/konan/debugger/ComputationState;", "topFrame", "collectFramesIteratively", "", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "computeStackFrames", "firstFrameIndex", "doComputeStackFrames", "filterAndDeliver", "frames", "", "getTopFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "newFrame", "nextBatchOfFrames", "updateSelectedFrame", "kotlin-ultimate.common-native"})
public final class KonanExecutionStack
extends XExecutionStack {
    private KonanStackFrame topFrame;
    private KonanStackFrame selectedFrame;
    private ComputationState state;
    private final ArrayList<KonanStackFrame> cachedFrames;
    private Integer cachedFirstFrameIndex;
    private boolean hasMoreFrames;
    private int currentFrom;
    private int currentCount;
    private final LLThread thread;
    private final CidrSuspensionCause suspensionCause;
    @NotNull
    private final KonanLocalDebugProcess process;

    @Nullable
    public XStackFrame getTopFrame() {
        return (XStackFrame)this.topFrame;
    }

    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.process.postCommand((CidrDebugProcess.VoidDebuggerCommand)new CidrDebugProcess.DebuggerUIUpdateCommand(this, firstFrameIndex, container){
            final /* synthetic */ KonanExecutionStack this$0;
            final /* synthetic */ int $firstFrameIndex;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container;

            public void run(@NotNull DebuggerDriver driver) {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                KonanExecutionStack.access$doComputeStackFrames(this.this$0, driver, this.$firstFrameIndex, this.$container);
            }
            {
                this.this$0 = this$0;
                this.$firstFrameIndex = $captured_local_variable$1;
                this.$container = $captured_local_variable$2;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doComputeStackFrames(DebuggerDriver driver, int firstFrameIndex, XExecutionStack.XStackFrameContainer container) {
        KonanExecutionStack konanExecutionStack = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (konanExecutionStack) {
            boolean bl3 = false;
            try {
                Integer n = this.cachedFirstFrameIndex;
                if (n != null && firstFrameIndex == n) {
                    this.filterAndDeliver((List<KonanStackFrame>)this.cachedFrames, container);
                    return;
                }
                this.currentFrom = firstFrameIndex;
                this.collectFramesIteratively(driver, container);
                if (this.state == ComputationState.ALL_DONE) {
                    this.cachedFirstFrameIndex = firstFrameIndex;
                }
            }
            catch (DebuggerCommandException e) {
                String string = e.getMessage();
                Intrinsics.checkNotNull((Object)string);
                container.errorOccurred(string);
            }
            catch (ExecutionException e) {
                container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Exception)((Object)e))));
                throw (Throwable)e;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void filterAndDeliver(List<KonanStackFrame> frames, XExecutionStack.XStackFrameContainer container) {
        List list;
        if (container.isObsolete()) {
            return;
        }
        XDebuggerSettingsManager xDebuggerSettingsManager = XDebuggerSettingsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerSettingsManager, (String)"XDebuggerSettingsManager.getInstance()");
        XDebuggerSettingsManager.DataViewSettings dataViewSettings = xDebuggerSettingsManager.getDataViewSettings();
        Intrinsics.checkNotNullExpressionValue((Object)dataViewSettings, (String)"XDebuggerSettingsManager\u2026stance().dataViewSettings");
        if (dataViewSettings.isShowLibraryStackFrames()) {
            list = frames;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = frames;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KonanStackFrame it = (KonanStackFrame)((Object)element$iv$iv);
                boolean bl = false;
                if (!(!it.isLibraryFile() || Intrinsics.areEqual((Object)((Object)it), (Object)((Object)this.topFrame)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List toDeliver = list;
        if (container instanceof XStackFrameContainerEx) {
            ((XStackFrameContainerEx)container).addStackFrames(toDeliver, (XStackFrame)this.selectedFrame, !this.hasMoreFrames);
        } else {
            KonanLog.INSTANCE.getLOG().error("Expected instanceof XStackFrameContainerEx, got " + container.getClass());
            container.addStackFrames(toDeliver, !this.hasMoreFrames);
        }
    }

    private final void collectFramesIteratively(DebuggerDriver driver, XExecutionStack.XStackFrameContainer container) {
        this.state = this.currentFrom == 0 ? ComputationState.FIRST_BATCH_LOOKUP : ComputationState.REGULAR_BATCH;
        this.currentCount = 100;
        this.selectedFrame = null;
        this.cachedFrames.clear();
        while (this.state != ComputationState.ALL_DONE) {
            if (container.isObsolete()) {
                return;
            }
            ArrayList<KonanStackFrame> batch = this.nextBatchOfFrames(driver);
            this.cachedFrames.addAll((Collection<KonanStackFrame>)batch);
            if (this.state != ComputationState.REGULAR_BATCH) {
                this.updateSelectedFrame();
            }
            if (this.state == ComputationState.FIRST_BATCH_LOOKUP && this.selectedFrame == null && this.hasMoreFrames && this.currentCount > 0) {
                this.state = ComputationState.FIRST_BATCH_FOLLOWUP;
                continue;
            }
            this.filterAndDeliver((List<KonanStackFrame>)(this.state == ComputationState.FIRST_BATCH_FOLLOWUP ? this.cachedFrames : batch), container);
            this.currentCount = 100;
            this.state = this.hasMoreFrames ? ComputationState.REGULAR_BATCH : ComputationState.ALL_DONE;
        }
    }

    private final KonanStackFrame newFrame(LLFrame frame) {
        return new KonanStackFrame(this.thread, frame, this.suspensionCause, this.process);
    }

    private final ArrayList<KonanStackFrame> nextBatchOfFrames(DebuggerDriver driver) {
        DebuggerDriver.ResultList resultList = driver.getFrames(this.thread.getId(), this.currentFrom, this.currentCount, this.state == ComputationState.FIRST_BATCH_LOOKUP);
        Intrinsics.checkNotNullExpressionValue((Object)resultList, (String)"driver.getFrames(thread.\u2026State.FIRST_BATCH_LOOKUP)");
        DebuggerDriver.ResultList llFrames = resultList;
        this.hasMoreFrames = llFrames.hasMore;
        this.currentFrom += llFrames.list.size();
        this.currentCount -= llFrames.list.size();
        ArrayList<KonanStackFrame> result = new ArrayList<KonanStackFrame>(llFrames.list.size());
        List list = llFrames.list;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"llFrames.list");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LLFrame it = (LLFrame)element$iv;
            boolean bl = false;
            LLFrame lLFrame = it;
            Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"it");
            result.add(this.newFrame(lLFrame));
        }
        Collection collection = result;
        boolean bl = false;
        if (!collection.isEmpty() && this.state == ComputationState.FIRST_BATCH_LOOKUP) {
            KonanStackFrame konanStackFrame = this.topFrame;
            if (konanStackFrame == null) {
                konanStackFrame = result.get(0);
            }
            KonanStackFrame konanStackFrame2 = this.topFrame = konanStackFrame;
            Intrinsics.checkNotNull((Object)((Object)konanStackFrame2));
            result.set(0, konanStackFrame2);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void updateSelectedFrame() {
        KonanStackFrame konanStackFrame;
        if (this.selectedFrame != null) {
            return;
        }
        KonanExecutionStack konanExecutionStack = this;
        KonanStackFrame konanStackFrame2 = this.topFrame;
        if (konanStackFrame2 != null && konanStackFrame2.hasSourceFile()) {
            konanStackFrame = this.topFrame;
        } else {
            Object v3;
            KonanExecutionStack konanExecutionStack2;
            block4: {
                void $this$firstOrNull$iv;
                Iterable iterable = this.cachedFrames;
                konanExecutionStack2 = konanExecutionStack;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KonanStackFrame it = (KonanStackFrame)((Object)element$iv);
                    boolean bl = false;
                    if (!it.hasSourceFile()) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            Object var8_8 = v3;
            konanExecutionStack = konanExecutionStack2;
            konanStackFrame = var8_8;
        }
        konanExecutionStack.selectedFrame = konanStackFrame;
    }

    @NotNull
    public final KonanLocalDebugProcess getProcess() {
        return this.process;
    }

    public KonanExecutionStack(@NotNull LLThread thread, @Nullable LLFrame frame, @Nullable CidrSuspensionCause suspensionCause, @NotNull KonanLocalDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)((Object)process), (String)"process");
        super(thread.getDisplayName());
        this.thread = thread;
        this.suspensionCause = suspensionCause;
        this.process = process;
        this.topFrame = frame == null ? null : this.newFrame(frame);
        this.state = ComputationState.FIRST_BATCH_LOOKUP;
        this.cachedFrames = new ArrayList();
        this.hasMoreFrames = true;
    }

    public static final /* synthetic */ void access$doComputeStackFrames(KonanExecutionStack $this, DebuggerDriver driver, int firstFrameIndex, XExecutionStack.XStackFrameContainer container) {
        $this.doComputeStackFrames(driver, firstFrameIndex, container);
    }
}

