/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.oss.glassfish.server.GlassfishDebugConfig;
import com.intellij.javaee.oss.glassfish.server.GlassfishLocalModel;
import com.intellij.javaee.oss.glassfish.server.GlassfishShutdownExecutableWrapper;
import com.intellij.javaee.oss.glassfish.server.GlassfishStartupExecutableWrapper;
import com.intellij.javaee.oss.server.JavaeeParameters;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.server.JavaeeStartupPolicy;
import java.io.File;

class GlassfishStartupPolicy
extends JavaeeStartupPolicy<GlassfishLocalModel> {
    GlassfishStartupPolicy() {
    }

    protected void getStartupParameters(JavaeeParameters params, GlassfishLocalModel model, boolean debug) {
        params.add(model.getScript());
        params.add(new String[]{"start-domain"});
        if (debug) {
            params.add(new String[]{"--debug"});
        }
        GlassfishStartupPolicy.addDomain(params, model);
    }

    protected void getShutdownParameters(JavaeeParameters params, GlassfishLocalModel model, boolean debug) {
        params.add(model.getScript());
        params.add(new String[]{"stop-domain"});
        GlassfishStartupPolicy.addDomain(params, model);
    }

    protected void initSettings(GlassfishLocalModel model, DebuggingRunnerData data) {
        data.setDebugPort(GlassfishDebugConfig.get(model));
    }

    protected void checkSettings(GlassfishLocalModel model, DebuggingRunnerData data) throws RuntimeConfigurationException {
        GlassfishDebugConfig.check(model, data.getDebugPort());
    }

    private static void addDomain(JavaeeParameters params, GlassfishLocalModel model) {
        File file = new File(model.DOMAIN);
        if (file.isAbsolute()) {
            params.add(new String[]{"--domaindir"});
            params.add(new String[]{file.getParent()});
            params.add(new String[]{file.getName()});
        } else {
            params.add(new String[]{model.DOMAIN});
        }
    }

    protected ExecutableObject getDefaultStartupScript(GlassfishLocalModel serverModel, boolean debug) {
        return new GlassfishStartupExecutableWrapper(super.getDefaultStartupScript((JavaeeServerModel)serverModel, debug), serverModel);
    }

    protected ExecutableObject getDefaultShutdownScript(GlassfishLocalModel serverModel, boolean debug) {
        return new GlassfishShutdownExecutableWrapper(super.getDefaultShutdownScript((JavaeeServerModel)serverModel, debug), serverModel);
    }
}

