/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerVersionConfig;
import com.intellij.javaee.oss.server.JavaeeServerVersionDescriptor;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class GlassfishServerVersionConfig
extends JavaeeServerVersionConfig {
    private static final JavaeeServerVersionConfig.Factory<JavaeePersistentData> ourFactory = new JavaeeServerVersionConfig.Factory<JavaeePersistentData>(){

        @NotNull
        public GlassfishServerVersionConfig createConfig(JavaeePersistentData data) {
            return new GlassfishServerVersionConfig();
        }
    };

    private GlassfishServerVersionConfig() {
    }

    protected JavaeeServerVersionDescriptor getVersionDescriptor(String home) throws Exception {
        File modulesDir = new File(home, "glassfish/modules");
        ArrayList<File> files = new ArrayList<File>();
        if (new File(home, "lib").isDirectory()) {
            files.add(new File(home, "lib/appserv-rt.jar"));
        } else if (modulesDir.isDirectory()) {
            File[] moduleFiles = modulesDir.listFiles();
            if (moduleFiles != null) {
                files.addAll(Arrays.asList(moduleFiles));
            }
        } else {
            throw new Exception("Unknown directory structure");
        }
        File versionJar = new File(modulesDir, "common-util.jar");
        String version = JarVersionDetectionUtil.getBundleVersion((File)versionJar);
        if (version != null) {
            return new JavaeeServerVersionDescriptor(version, versionJar);
        }
        for (File nextFile : files) {
            URLClassLoader loader = new URLClassLoader(new URL[]{nextFile.toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());
            Class<?> type = loader.loadClass("com.sun.appserv.server.util.Version");
            try {
                Field field = type.getDeclaredField("full_version");
                field.setAccessible(true);
                version = (String)field.get(null);
                return new JavaeeServerVersionDescriptor(version, nextFile);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        throw new Exception("Can't identify server version");
    }

    public static String get(JavaeePersistentData data) throws Exception {
        return GlassfishServerVersionConfig.get(ourFactory, (JavaeePersistentData)data);
    }
}

