/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.DynamicBundle;
import com.intellij.javaee.appServers.run.configuration.ServerModelBase;
import com.intellij.javaee.appServers.run.configuration.view.JavaeeRunConfigurationEditorUtil;
import com.intellij.javaee.oss.glassfish.GlassfishBundle;
import com.intellij.javaee.oss.glassfish.server.GlassfishIntegration;
import com.intellij.javaee.oss.glassfish.server.GlassfishLocalModel;
import com.intellij.javaee.oss.server.JavaeeRunSettingsEditor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class GlassfishLocalEditor
extends JavaeeRunSettingsEditor<GlassfishLocalModel> {
    private static final Supplier<@Nls String> ALL_VIRTUAL_SERVERS = GlassfishBundle.getTextPointer("GlassfishLocalEditor.all.virtual.servers", new Object[0]);
    private JPanel panel;
    private ComboboxWithBrowseButton domain;
    private JTextField username;
    private JPasswordField password;
    private JLabel passwordLabel;
    private JCheckBox preserve;
    private JComboBox myVirtualServersComboBox;
    private JLabel myVirtualServersLabel;
    private JCheckBox myCompatibilityCheckBox;

    GlassfishLocalEditor() {
        super(GlassfishIntegration.getInstance());
        this.$$$setupUI$$$();
        this.domain.addBrowseFolderListener(GlassfishBundle.getText("GlassfishLocalEditor.select", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        this.domain.getComboBox().setEditable(true);
        Component component = this.domain.getComboBox().getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GlassfishLocalEditor.this.fireLogFilesChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javaee/oss/glassfish/server/GlassfishLocalEditor$1", "textChanged"));
                }
            });
        }
    }

    @NotNull
    protected JComponent getEditor() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            GlassfishLocalEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    protected void resetEditorFrom(GlassfishLocalModel model) {
        this.domain.getComboBox().removeAllItems();
        for (String name : model.getDomains()) {
            this.domain.getComboBox().addItem(name);
        }
        this.domain.getComboBox().setSelectedItem(null);
        this.domain.getComboBox().setSelectedItem(model.DOMAIN);
        this.username.setText(model.USERNAME);
        JavaeeRunConfigurationEditorUtil.resetPasswordFrom((ServerModelBase)model, (JPasswordField)this.password, (JLabel)this.passwordLabel);
        this.preserve.setEnabled(model.isGlassfish3Plus());
        this.preserve.setSelected(model.PRESERVE);
        this.myCompatibilityCheckBox.setEnabled(model.isGlassfish3Plus());
        this.myCompatibilityCheckBox.setSelected(model.COMPATIBILITY);
        this.myVirtualServersComboBox.removeAllItems();
        this.myVirtualServersComboBox.addItem(ALL_VIRTUAL_SERVERS.get());
        for (String virtualServer : model.getVirtualServers()) {
            this.myVirtualServersComboBox.addItem(virtualServer);
        }
        this.myVirtualServersComboBox.setSelectedItem(null);
        String virtualServer = model.VIRTUAL_SERVER;
        this.myVirtualServersComboBox.setSelectedItem(virtualServer == null ? ALL_VIRTUAL_SERVERS.get() : virtualServer);
        boolean showVirtualServer = model.getVirtualServers().size() > 1;
        this.myVirtualServersLabel.setVisible(showVirtualServer);
        this.myVirtualServersComboBox.setVisible(showVirtualServer);
    }

    protected void applyEditorTo(GlassfishLocalModel model) throws ConfigurationException {
        model.DOMAIN = (String)this.domain.getComboBox().getEditor().getItem();
        model.USERNAME = this.username.getText();
        JavaeeRunConfigurationEditorUtil.applyPasswordTo((ServerModelBase)model, (JPasswordField)this.password);
        model.PRESERVE = this.preserve.isSelected();
        model.COMPATIBILITY = this.myCompatibilityCheckBox.isSelected();
        String virtualServer = (String)this.myVirtualServersComboBox.getSelectedItem();
        model.VIRTUAL_SERVER = ALL_VIRTUAL_SERVERS.get().equals(virtualServer) ? null : virtualServer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/server/GlassfishLocalEditor", "getEditor"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JLabel jLabel;
        JPasswordField jPasswordField;
        JLabel jLabel2;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/GlassfishBundle", GlassfishLocalEditor.class).getString("GlassfishLocalEditor.domain"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.preserve = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/GlassfishBundle", GlassfishLocalEditor.class).getString("GlassfishEditor.preserve"));
        ((Component)jCheckBox2).setVisible(true);
        jPanel.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/AppServersCommonBundle", GlassfishLocalEditor.class).getString("RunEditor.username"));
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.username = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        this.domain = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.passwordLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/AppServersCommonBundle", GlassfishLocalEditor.class).getString("RunEditor.password"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.password = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(2, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myVirtualServersLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/GlassfishBundle", GlassfishLocalEditor.class).getString("GlassfishLocalEditor.label.virtual.server"));
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVirtualServersComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(3, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myCompatibilityCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/GlassfishBundle", GlassfishLocalEditor.class).getString("GlassfishEditor.compatibility"));
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        jLabel3.setLabelFor((Component)comboboxWithBrowseButton);
        jLabel4.setLabelFor(jTextField);
        jLabel2.setLabelFor(jPasswordField);
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

