/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.javaee.oss.glassfish.server.GlassfishDomainConfig;
import com.intellij.javaee.oss.util.ConfigBase;
import com.intellij.javaee.util.JavaeeJdomUtil;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;

public abstract class GlassfishDomainConfigProcessor
extends ConfigBase {
    private static final Logger LOG = Logger.getInstance(GlassfishDomainConfigProcessor.class);
    private final File myFile;

    public GlassfishDomainConfigProcessor(GlassfishDomainConfig domainConfig) {
        this.myFile = domainConfig.getFile();
    }

    public void processConfig() {
        if (!this.myFile.exists()) {
            return;
        }
        try {
            Document doc = JavaeeJdomUtil.loadDocument((File)this.myFile);
            Element root = doc.getRootElement();
            @NonNls Element serverConfig = GlassfishDomainConfigProcessor.getChild((Element)root.getChild("configs"), (String)"config", (String)"name", (String)"server-config");
            if (serverConfig == null) {
                return;
            }
            this.doProcessConfig(this.myFile, doc, serverConfig);
        }
        catch (IOException | JDOMException e) {
            LOG.error(e);
        }
    }

    protected abstract void doProcessConfig(File var1, Document var2, Element var3) throws IOException, JDOMException;
}

