/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.Value;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilKt;
import org.jetbrains.kotlin.idea.debugger.BinaryCacheKey;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledDataDescriptor;
import org.jetbrains.kotlin.idea.util.DumbUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004RE\u0010\u0005\u001a9\u00120\u0012.\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t \u000b*\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\r\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f \u000b*\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e0\u000e0\u0006\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\u0010\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0011 \u000b*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R=\u0010\u0012\u001a1\u0012(\u0012&\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0015 \u000b*\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u00130\u00130\u0006\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedClassNames", "Lcom/intellij/psi/util/CachedValue;", "", "Lcom/intellij/psi/PsiElement;", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "cachedCompiledData", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor;", "cachedTypeMappers", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "debugInfoCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/idea/debugger/BinaryCacheKey;", "Lorg/jetbrains/kotlin/codegen/inline/SMAP;", "Companion", "ComputedClassNames", "Parameter", "kotlin.jvm-debugger.util"})
public final class KotlinDebuggerCaches {
    private final CachedValue<MultiMap<String, CompiledDataDescriptor>> cachedCompiledData;
    private final CachedValue<Map<PsiElement, List<String>>> cachedClassNames;
    private final CachedValue<Map<PsiElement, KotlinTypeMapper>> cachedTypeMappers;
    private final CachedValue<ConcurrentMap<BinaryCacheKey, SMAP>> debugInfoCache;
    private static final Logger LOG;
    private static boolean LOG_COMPILATIONS;
    public static final Companion Companion;

    public KotlinDebuggerCaches(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project2).createCachedValue((CachedValueProvider)cachedCompiledData.1.INSTANCE, false);
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue, (String)"CachedValuesManager.getM\u2026 )\n        }, false\n    )");
        this.cachedCompiledData = cachedValue;
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)project2).createCachedValue((CachedValueProvider)cachedClassNames.1.INSTANCE, false);
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"CachedValuesManager.getM\u2026 )\n        }, false\n    )");
        this.cachedClassNames = cachedValue2;
        CachedValue cachedValue3 = CachedValuesManager.getManager((Project)project2).createCachedValue((CachedValueProvider)cachedTypeMappers.1.INSTANCE, false);
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue3, (String)"CachedValuesManager.getM\u2026 )\n        }, false\n    )");
        this.cachedTypeMappers = cachedValue3;
        CachedValue cachedValue4 = CachedValuesManager.getManager((Project)project2).createCachedValue((CachedValueProvider)debugInfoCache.1.INSTANCE, false);
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue4, (String)"CachedValuesManager.getM\u2026 )\n        }, false\n    )");
        this.debugInfoCache = cachedValue4;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getLogger(KotlinDebuggerCaches.class);
        Intrinsics.checkNotNull((Object)logger);
        LOG = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J5\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Parameter;", "", "callText", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "value", "Lorg/jetbrains/eval4j/Value;", "error", "Lcom/intellij/debugger/engine/evaluation/EvaluateException;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/eval4j/Value;Lcom/intellij/debugger/engine/evaluation/EvaluateException;)V", "getCallText", "()Ljava/lang/String;", "getError", "()Lcom/intellij/debugger/engine/evaluation/EvaluateException;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getValue", "()Lorg/jetbrains/eval4j/Value;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.jvm-debugger.util"})
    public static final class Parameter {
        @NotNull
        private final String callText;
        @NotNull
        private final KotlinType type;
        @Nullable
        private final Value value;
        @Nullable
        private final EvaluateException error;

        @NotNull
        public final String getCallText() {
            return this.callText;
        }

        @NotNull
        public final KotlinType getType() {
            return this.type;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        @Nullable
        public final EvaluateException getError() {
            return this.error;
        }

        public Parameter(@NotNull String callText, @NotNull KotlinType type, @Nullable Value value, @Nullable EvaluateException error) {
            Intrinsics.checkNotNullParameter((Object)callText, (String)"callText");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.callText = callText;
            this.type = type;
            this.value = value;
            this.error = error;
        }

        public /* synthetic */ Parameter(String string, KotlinType kotlinType, Value value, EvaluateException evaluateException, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                value = null;
            }
            if ((n & 8) != 0) {
                evaluateException = null;
            }
            this(string, kotlinType, value, evaluateException);
        }

        @NotNull
        public final String component1() {
            return this.callText;
        }

        @NotNull
        public final KotlinType component2() {
            return this.type;
        }

        @Nullable
        public final Value component3() {
            return this.value;
        }

        @Nullable
        public final EvaluateException component4() {
            return this.error;
        }

        @NotNull
        public final Parameter copy(@NotNull String callText, @NotNull KotlinType type, @Nullable Value value, @Nullable EvaluateException error) {
            Intrinsics.checkNotNullParameter((Object)callText, (String)"callText");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Parameter(callText, type, value, error);
        }

        public static /* synthetic */ Parameter copy$default(Parameter parameter, String string, KotlinType kotlinType, Value value, EvaluateException evaluateException, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameter.callText;
            }
            if ((n & 2) != 0) {
                kotlinType = parameter.type;
            }
            if ((n & 4) != 0) {
                value = parameter.value;
            }
            if ((n & 8) != 0) {
                evaluateException = parameter.error;
            }
            return parameter.copy(string, kotlinType, value, evaluateException);
        }

        @NotNull
        public String toString() {
            return "Parameter(callText=" + this.callText + ", type=" + this.type + ", value=" + this.value + ", error=" + (Object)((Object)this.error) + ")";
        }

        public int hashCode() {
            String string = this.callText;
            KotlinType kotlinType = this.type;
            Value value = this.value;
            EvaluateException evaluateException = this.error;
            return (((string != null ? string.hashCode() : 0) * 31 + (kotlinType != null ? kotlinType.hashCode() : 0)) * 31 + (value != null ? value.hashCode() : 0)) * 31 + (evaluateException != null ? ((Object)((Object)evaluateException)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Parameter)) break block3;
                    Parameter parameter = (Parameter)object;
                    if (!Intrinsics.areEqual((Object)this.callText, (Object)parameter.callText) || !Intrinsics.areEqual((Object)this.type, (Object)parameter.type) || !Intrinsics.areEqual((Object)this.value, (Object)parameter.value) || !Intrinsics.areEqual((Object)((Object)this.error), (Object)((Object)parameter.error))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u0006J\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "", "classNames", "", "", "shouldBeCached", "", "(Ljava/util/List;Z)V", "getClassNames", "()Ljava/util/List;", "getShouldBeCached", "()Z", "distinct", "isEmpty", "plus", "other", "Companion", "kotlin.jvm-debugger.util"})
    public static final class ComputedClassNames {
        @NotNull
        private final List<String> classNames;
        private final boolean shouldBeCached;
        @NotNull
        private static final ComputedClassNames EMPTY;
        public static final Companion Companion;

        public final boolean isEmpty() {
            return this.classNames.isEmpty();
        }

        @NotNull
        public final ComputedClassNames distinct() {
            return new ComputedClassNames(CollectionsKt.distinct((Iterable)this.classNames), this.shouldBeCached);
        }

        @NotNull
        public final ComputedClassNames plus(@NotNull ComputedClassNames other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new ComputedClassNames(CollectionsKt.plus((Collection)this.classNames, (Iterable)other.classNames), this.shouldBeCached && other.shouldBeCached);
        }

        @NotNull
        public final List<String> getClassNames() {
            return this.classNames;
        }

        public final boolean getShouldBeCached() {
            return this.shouldBeCached;
        }

        public ComputedClassNames(@NotNull List<String> classNames, boolean shouldBeCached) {
            Intrinsics.checkNotNullParameter(classNames, (String)"classNames");
            this.classNames = classNames;
            this.shouldBeCached = shouldBeCached;
        }

        static {
            Companion = new Companion(null);
            EMPTY = Companion.Cached(CollectionsKt.emptyList());
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0007\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u0014\u0010\f\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "getEMPTY", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "Cached", "className", "", "classNames", "", "NonCached", "kotlin.jvm-debugger.util"})
        public static final class Companion {
            @NotNull
            public final ComputedClassNames getEMPTY() {
                return EMPTY;
            }

            @NotNull
            public final ComputedClassNames Cached(@NotNull List<String> classNames) {
                Intrinsics.checkNotNullParameter(classNames, (String)"classNames");
                return new ComputedClassNames(classNames, true);
            }

            @NotNull
            public final ComputedClassNames Cached(@NotNull String className) {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                List<String> list = Collections.singletonList(className);
                Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.singletonList(className)");
                return new ComputedClassNames(list, true);
            }

            @NotNull
            public final ComputedClassNames NonCached(@NotNull List<String> classNames) {
                Intrinsics.checkNotNullParameter(classNames, (String)"classNames");
                return new ComputedClassNames(classNames, false);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J<\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0006J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\"\u001a\u00020 2\b\u0010\u001f\u001a\u0004\u0018\u00010#H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J9\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)\"\b\b\u0000\u0010+*\u00020#2\b\u0010,\u001a\u0004\u0018\u0001H+2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u00020/0.\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\u00020\u00102\u0006\u0010,\u001a\u00020#J \u00102\u001a\u0004\u0018\u0001032\u0006\u0010&\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u0010\r\u001a\u000206R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Companion;", "", "()V", "LOG", "Lorg/apache/log4j/Logger;", "LOG_COMPILATIONS", "", "getLOG_COMPILATIONS", "()Z", "setLOG_COMPILATIONS", "(Z)V", "addTypeMapper", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "compileCodeFragmentCacheAware", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "compileCode", "Lkotlin/Function0;", "force", "createTypeMapper", "analysisResult", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "createTypeMapperForLibraryFile", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "createTypeMapperForSourceFile", "getElementToCreateTypeMapperForLibraryFile", "Lcom/intellij/psi/PsiElement;", "getInstance", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches;", "project", "Lcom/intellij/openapi/project/Project;", "getOrComputeClassNames", "", "", "T", "psiElement", "create", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "getOrCreateTypeMapper", "getSmapCached", "Lorg/jetbrains/kotlin/codegen/inline/SMAP;", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm-debugger.util"})
    public static final class Companion {
        public final boolean getLOG_COMPILATIONS() {
            return LOG_COMPILATIONS;
        }

        public final void setLOG_COMPILATIONS(boolean bl) {
            LOG_COMPILATIONS = bl;
        }

        @NotNull
        public final KotlinDebuggerCaches getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = ServiceManager.getService((Project)project2, KotlinDebuggerCaches.class);
            Intrinsics.checkNotNull((Object)object);
            return (KotlinDebuggerCaches)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Pair<CompiledDataDescriptor, Boolean> compileCodeFragmentCacheAware(@NotNull KtCodeFragment codeFragment, @Nullable SourcePosition sourcePosition, @NotNull Function0<CompiledDataDescriptor> compileCode, boolean force) {
            Object v2;
            Iterable $this$firstOrNull$iv;
            String text;
            KotlinDebuggerCaches evaluateExpressionCache;
            block15: {
                Collection collection;
                Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
                Intrinsics.checkNotNullParameter(compileCode, (String)"compileCode");
                if (sourcePosition == null) {
                    return new Pair(compileCode.invoke(), (Object)false);
                }
                Project project2 = codeFragment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"codeFragment.project");
                evaluateExpressionCache = this.getInstance(project2);
                text = codeFragment.importsToString() + '\n' + codeFragment.getText();
                CachedValue cachedValue = evaluateExpressionCache.cachedCompiledData;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (cachedValue) {
                    boolean bl3 = false;
                    Collection collection2 = ((MultiMap)evaluateExpressionCache.cachedCompiledData.getValue()).get((Object)text);
                    Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"evaluateExpressionCache.\u2026dCompiledData.value[text]");
                    collection = collection2;
                }
                Collection cachedResults = collection;
                $this$firstOrNull$iv = cachedResults;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CompiledDataDescriptor it = (CompiledDataDescriptor)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getSourcePosition(), (Object)sourcePosition)) continue;
                    v2 = element$iv;
                    break block15;
                }
                v2 = null;
            }
            CompiledDataDescriptor existingResult = v2;
            if (existingResult != null) {
                if (force) {
                    $this$firstOrNull$iv = evaluateExpressionCache.cachedCompiledData;
                    boolean bl = false;
                    boolean bl5 = false;
                    synchronized ($this$firstOrNull$iv) {
                        boolean bl6 = false;
                        bl5 = ((MultiMap)evaluateExpressionCache.cachedCompiledData.getValue()).remove((Object)text, (Object)existingResult);
                    }
                } else {
                    return new Pair((Object)existingResult, (Object)true);
                }
            }
            CompiledDataDescriptor newCompiledData = (CompiledDataDescriptor)compileCode.invoke();
            if (this.getLOG_COMPILATIONS()) {
                LOG.debug((Object)("Compile bytecode for " + codeFragment.getText()));
            }
            CachedValue cachedValue = evaluateExpressionCache.cachedCompiledData;
            boolean bl = false;
            boolean bl7 = false;
            synchronized (cachedValue) {
                boolean bl8 = false;
                ((MultiMap)evaluateExpressionCache.cachedCompiledData.getValue()).putValue((Object)text, (Object)newCompiledData);
                Unit unit = Unit.INSTANCE;
            }
            return new Pair((Object)newCompiledData, (Object)false);
        }

        public static /* synthetic */ Pair compileCodeFragmentCacheAware$default(Companion companion, KtCodeFragment ktCodeFragment, SourcePosition sourcePosition, Function0 function0, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.compileCodeFragmentCacheAware(ktCodeFragment, sourcePosition, (Function0<CompiledDataDescriptor>)function0, bl);
        }

        @NotNull
        public final <T extends PsiElement> List<String> getOrComputeClassNames(@Nullable T psiElement, @NotNull Function1<? super T, ComputedClassNames> create) {
            Intrinsics.checkNotNullParameter(create, (String)"create");
            if (psiElement == null) {
                List<String> list = Collections.emptyList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.emptyList()");
                return list;
            }
            KotlinDebuggerCaches cache2 = this.getInstance((Project)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Project>(psiElement){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final Project invoke() {
                    Project project2 = this.$psiElement.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiElement.project");
                    return project2;
                }
                {
                    this.$psiElement = psiElement;
                    super(0);
                }
            })));
            Map classNamesCache = (Map)cache2.cachedClassNames.getValue();
            List cachedValue = (List)classNamesCache.get(psiElement);
            if (cachedValue != null) {
                return cachedValue;
            }
            ComputedClassNames computedClassNames = (ComputedClassNames)create.invoke(psiElement);
            if (computedClassNames.getShouldBeCached()) {
                Map map = classNamesCache;
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"classNamesCache");
                map.put(psiElement, computedClassNames.getClassNames());
            }
            return computedClassNames.getClassNames();
        }

        @NotNull
        public final KotlinTypeMapper getOrCreateTypeMapper(@NotNull PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Object object = ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Project>(psiElement){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final Project invoke() {
                    return this.$psiElement.getProject();
                }
                {
                    this.$psiElement = psiElement;
                    super(0);
                }
            }));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { psiElement.project }");
            Project project2 = (Project)object;
            KotlinDebuggerCaches cache2 = this.getInstance(project2);
            KtFile file2 = (KtFile)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtFile>(psiElement){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final KtFile invoke() {
                    PsiFile psiFile = this.$psiElement.getContainingFile();
                    if (psiFile == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    return (KtFile)psiFile;
                }
                {
                    this.$psiElement = psiElement;
                    super(0);
                }
            }));
            boolean isInLibrary2 = ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<OrderEntry>(file2){
                final /* synthetic */ KtFile $file;

                @Nullable
                public final OrderEntry invoke() {
                    return LibraryUtil.findLibraryEntry((VirtualFile)this.$file.getVirtualFile(), (Project)this.$file.getProject());
                }
                {
                    this.$file = ktFile;
                    super(0);
                }
            })) != null;
            PsiElement key = !isInLibrary2 ? (PsiElement)file2 : psiElement;
            Map typeMappersCache = (Map)cache2.cachedTypeMappers.getValue();
            KotlinTypeMapper cachedValue = (KotlinTypeMapper)typeMappersCache.get(key);
            if (cachedValue != null) {
                return cachedValue;
            }
            KotlinTypeMapper newValue2 = (KotlinTypeMapper)DumbUtilsKt.runReadActionInSmartMode((Project)project2, (Function0)((Function0)new Function0<KotlinTypeMapper>(isInLibrary2, file2, psiElement){
                final /* synthetic */ boolean $isInLibrary;
                final /* synthetic */ KtFile $file;
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final KotlinTypeMapper invoke() {
                    KotlinTypeMapper kotlinTypeMapper;
                    if (!this.$isInLibrary) {
                        kotlinTypeMapper = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches$Companion.access$createTypeMapperForSourceFile(KotlinDebuggerCaches.Companion, this.$file);
                    } else {
                        KtElement element = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches$Companion.access$getElementToCreateTypeMapperForLibraryFile(KotlinDebuggerCaches.Companion, this.$psiElement);
                        kotlinTypeMapper = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches$Companion.access$createTypeMapperForLibraryFile(KotlinDebuggerCaches.Companion, element, this.$file);
                    }
                    return kotlinTypeMapper;
                }
                {
                    this.$isInLibrary = bl;
                    this.$file = ktFile;
                    this.$psiElement = psiElement;
                    super(0);
                }
            }));
            Map map = typeMappersCache;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"typeMappersCache");
            map.put(key, newValue2);
            return newValue2;
        }

        @Nullable
        public final SMAP getSmapCached(@NotNull Project project2, @NotNull JvmClassName jvmName, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return (SMAP)((ConcurrentMap)this.getInstance(project2).debugInfoCache.getValue()).get(new BinaryCacheKey(project2, jvmName, file2));
        }

        private final KtElement getElementToCreateTypeMapperForLibraryFile(PsiElement element) {
            return (KtElement)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtElement>(element){
                final /* synthetic */ PsiElement $element;

                @NotNull
                public final KtElement invoke() {
                    KtElement ktElement;
                    PsiElement psiElement = this.$element;
                    if (!(psiElement instanceof KtElement)) {
                        psiElement = null;
                    }
                    if ((ktElement = (KtElement)psiElement) == null) {
                        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)this.$element, KtElement.class);
                        Intrinsics.checkNotNull((Object)psiElement2);
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiTreeUtil.getParentOfT\u2026 KtElement::class.java)!!");
                        ktElement = (KtElement)psiElement2;
                    }
                    return ktElement;
                }
                {
                    this.$element = psiElement;
                    super(0);
                }
            }));
        }

        private final KotlinTypeMapper createTypeMapperForLibraryFile(KtElement element, KtFile file2) {
            return (KotlinTypeMapper)ProgressUtilKt.runInReadActionWithWriteActionPriorityWithPCE((Function0)((Function0)new Function0<KotlinTypeMapper>(file2, element){
                final /* synthetic */ KtFile $file;
                final /* synthetic */ KtElement $element;

                @NotNull
                public final KotlinTypeMapper invoke() {
                    return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches$Companion.access$createTypeMapper(KotlinDebuggerCaches.Companion, this.$file, ResolutionUtils.analyzeWithContentAndGetResult((KtElement)this.$element));
                }
                {
                    this.$file = ktFile;
                    this.$element = ktElement;
                    super(0);
                }
            }));
        }

        private final KotlinTypeMapper createTypeMapperForSourceFile(KtFile file2) {
            return (KotlinTypeMapper)ProgressUtilKt.runInReadActionWithWriteActionPriorityWithPCE((Function0)((Function0)new Function0<KotlinTypeMapper>(file2){
                final /* synthetic */ KtFile $file;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final KotlinTypeMapper invoke() {
                    void p1;
                    AnalysisResult analysisResult = ResolutionUtils.analyzeWithAllCompilerChecks((KtFile)this.$file, (KtFile[])new KtFile[0]);
                    boolean bl = false;
                    boolean bl2 = false;
                    AnalysisResult analysisResult2 = analysisResult;
                    KtFile ktFile = this.$file;
                    Companion companion = KotlinDebuggerCaches.Companion;
                    boolean bl3 = false;
                    p1.throwIfError();
                    Unit unit = Unit.INSTANCE;
                    return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches$Companion.access$createTypeMapper(companion, ktFile, analysisResult);
                }
                {
                    this.$file = ktFile;
                    super(0);
                }
            }));
        }

        private final KotlinTypeMapper createTypeMapper(KtFile file2, AnalysisResult analysisResult) {
            Project project2 = file2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
            ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.THROW_EXCEPTION;
            Intrinsics.checkNotNullExpressionValue((Object)classBuilderFactory, (String)"ClassBuilderFactories.THROW_EXCEPTION");
            ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
            BindingContext bindingContext = analysisResult.getBindingContext();
            List list = CollectionsKt.listOf((Object)file2);
            CompilerConfiguration compilerConfiguration = CompilerConfiguration.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration, (String)"CompilerConfiguration.EMPTY");
            GenerationState state = new GenerationState.Builder(project2, classBuilderFactory, moduleDescriptor, bindingContext, list, compilerConfiguration).build();
            state.beforeCompile();
            return state.getTypeMapper();
        }

        public final void addTypeMapper(@NotNull KtFile file2, @NotNull KotlinTypeMapper typeMapper) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)typeMapper, (String)"typeMapper");
            Project project2 = file2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
            Object object = this.getInstance(project2).cachedTypeMappers.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(file.project).cachedTypeMappers.value");
            ((Map)object).put(file2, typeMapper);
        }

        private Companion() {
        }

        public static final /* synthetic */ KotlinTypeMapper access$createTypeMapperForSourceFile(Companion $this, KtFile file2) {
            return $this.createTypeMapperForSourceFile(file2);
        }

        public static final /* synthetic */ KtElement access$getElementToCreateTypeMapperForLibraryFile(Companion $this, PsiElement element) {
            return $this.getElementToCreateTypeMapperForLibraryFile(element);
        }

        public static final /* synthetic */ KotlinTypeMapper access$createTypeMapperForLibraryFile(Companion $this, KtElement element, KtFile file2) {
            return $this.createTypeMapperForLibraryFile(element, file2);
        }

        public static final /* synthetic */ KotlinTypeMapper access$createTypeMapper(Companion $this, KtFile file2, AnalysisResult analysisResult) {
            return $this.createTypeMapper(file2, analysisResult);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

