/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.ReflectionStartupUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SqlTokenRegistry {
    private static final THashMap<String, SqlTokenType> ourTokensMap = SqlTokenRegistry.newTokenMap();
    private static final THashMap<Class, Map<String, SqlKeywordTokenType>> ourClassTokensMap = new THashMap();
    private static final THashMap<String, IElementType> ourCompositeMap = new THashMap();
    private static Consumer<String> ourTestInterceptor;

    private SqlTokenRegistry() {
    }

    @NotNull
    public static SqlTokenType getType(@NotNull String text) {
        if (text == null) {
            SqlTokenRegistry.$$$reportNull$$$0(0);
        }
        return SqlTokenRegistry.getImpl(ourTokensMap, text, o -> Character.isLetter(o.charAt(0)) ? new SqlKeywordTokenType((String)o) : new SqlTokenType((String)o));
    }

    @NotNull
    public static SqlTokenType getType(@NotNull String text, @NotNull Function<String, ? extends SqlTokenType> factory) {
        if (text == null) {
            SqlTokenRegistry.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            SqlTokenRegistry.$$$reportNull$$$0(2);
        }
        return SqlTokenRegistry.getImpl(ourTokensMap, text, factory);
    }

    @NotNull
    public static SqlCompositeElementType getCompositeType(@NotNull String debugName) {
        if (debugName == null) {
            SqlTokenRegistry.$$$reportNull$$$0(3);
        }
        return (SqlCompositeElementType)SqlTokenRegistry.getImpl(ourCompositeMap, debugName, o -> new SqlCompositeElementType((String)o));
    }

    @NotNull
    public static <T extends IElementType> T getCompositeType(@NotNull String debugName, @NotNull Function<String, T> factory) {
        if (debugName == null) {
            SqlTokenRegistry.$$$reportNull$$$0(4);
        }
        if (factory == null) {
            SqlTokenRegistry.$$$reportNull$$$0(5);
        }
        return (T)SqlTokenRegistry.getImpl(ourCompositeMap, debugName, factory);
    }

    @TestOnly
    public static void setTestInterceptor(@NotNull Consumer<String> testInterceptor) {
        if (testInterceptor == null) {
            SqlTokenRegistry.$$$reportNull$$$0(6);
        }
        ourTestInterceptor = testInterceptor;
    }

    @NotNull
    private static synchronized <T extends IElementType> T getImpl(@NotNull Map<String, ? super T> map, @NotNull String debugName, @NotNull Function<String, T> factory) {
        IElementType type;
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(7);
        }
        if (debugName == null) {
            SqlTokenRegistry.$$$reportNull$$$0(8);
        }
        if (factory == null) {
            SqlTokenRegistry.$$$reportNull$$$0(9);
        }
        if ((type = (IElementType)map.get(debugName)) == null) {
            type = Objects.requireNonNull((IElementType)factory.fun((Object)debugName));
            map.put(debugName, type);
            if (ourTestInterceptor != null) {
                ourTestInterceptor.consume((Object)debugName);
            }
        }
        IElementType iElementType = type;
        if (iElementType == null) {
            SqlTokenRegistry.$$$reportNull$$$0(10);
        }
        return (T)iElementType;
    }

    @Nullable
    public static synchronized SqlTokenType findTokenType(@NotNull String text) {
        if (text == null) {
            SqlTokenRegistry.$$$reportNull$$$0(11);
        }
        return (SqlTokenType)((Object)ourTokensMap.get((Object)text));
    }

    @Nullable
    public static synchronized IElementType findCompositeType(@NotNull String text) {
        if (text == null) {
            SqlTokenRegistry.$$$reportNull$$$0(12);
        }
        return (IElementType)ourCompositeMap.get((Object)text);
    }

    @Nullable
    public static synchronized IElementType findType(@NotNull String text) {
        SqlTokenType token;
        if (text == null) {
            SqlTokenRegistry.$$$reportNull$$$0(13);
        }
        if ((token = (SqlTokenType)((Object)ourTokensMap.get((Object)text))) != null) {
            return token;
        }
        return (IElementType)ourCompositeMap.get((Object)text);
    }

    @NotNull
    public static synchronized Iterable<IElementType> getAllCompositeTypes() {
        Collection collection = ourCompositeMap.values();
        if (collection == null) {
            SqlTokenRegistry.$$$reportNull$$$0(14);
        }
        return collection;
    }

    public static void initTypeMap(@NotNull Class clazz, @Nullable Set<String> exclude) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(15);
        }
        Map<String, SqlKeywordTokenType> map = SqlTokenRegistry.buildTokenMap(clazz, SqlTokenRegistry.newTokenMap());
        if (exclude != null) {
            map.keySet().removeAll(exclude);
        }
        SqlTokenRegistry.setTypeMap(clazz, map, false);
    }

    public static synchronized void addTokensToClassMap(@NotNull Class clazz, @NotNull Set<String> keywordSet) {
        Map existing;
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(16);
        }
        if (keywordSet == null) {
            SqlTokenRegistry.$$$reportNull$$$0(17);
        }
        Object map = (existing = (Map)ourClassTokensMap.get((Object)clazz)) == null ? SqlTokenRegistry.newTokenMap() : existing;
        for (String s : keywordSet) {
            if (map.containsKey(s)) continue;
            String upperCase = StringUtil.toUpperCase((String)s);
            map.put(upperCase, (SqlKeywordTokenType)SqlTokenRegistry.getType(upperCase));
        }
        SqlTokenRegistry.setTypeMap(clazz, map, true);
    }

    private static synchronized void setTypeMap(@NotNull Class clazz, @NotNull Map<String, SqlKeywordTokenType> map, boolean force) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(18);
        }
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(19);
        }
        if (!force && ourClassTokensMap.containsKey((Object)clazz)) {
            return;
        }
        ourClassTokensMap.put((Object)clazz, map);
    }

    @NotNull
    public static NullableFunction<String, IElementType> getTokenProvider(@NotNull Class clazz) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(20);
        }
        NullableFunction nullableFunction = SqlTokenRegistry.getSafeMap(clazz)::get;
        if (nullableFunction == null) {
            SqlTokenRegistry.$$$reportNull$$$0(21);
        }
        return nullableFunction;
    }

    public static Set<String> getTokens(Class clazz) {
        return Collections.unmodifiableSet(SqlTokenRegistry.getSafeMap(clazz).keySet());
    }

    @NotNull
    private static synchronized Map<String, SqlKeywordTokenType> getSafeMap(@NotNull Class clazz) {
        Map result;
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(22);
        }
        if ((result = (Map)ourClassTokensMap.get((Object)clazz)) == null) {
            throw new AssertionError((Object)(clazz + " token map not initialized"));
        }
        Map map = result;
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(23);
        }
        return map;
    }

    private static <T extends IElementType> THashMap<String, T> newTokenMap() {
        return new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    private static Map<String, SqlKeywordTokenType> buildTokenMap(@NotNull Class clazz, @NotNull Map<String, SqlKeywordTokenType> map) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(24);
        }
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(25);
        }
        SqlTokenRegistry.consumeStaticFieldsInOrder(clazz, (PairConsumer<Field, Object>)((PairConsumer)(field, value) -> {
            if (value instanceof SqlKeywordTokenType) {
                SqlKeywordTokenType tokenType = (SqlKeywordTokenType)((Object)((Object)value));
                map.put(tokenType.toString(), tokenType);
            }
        }));
        return map;
    }

    public static void consumeStaticFieldsInOrder(@NotNull Class clazz, @NotNull PairConsumer<Field, Object> processor) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            SqlTokenRegistry.$$$reportNull$$$0(27);
        }
        JBIterable fields = ReflectionStartupUtil.classTraverser((Class)clazz).postOrderDfsTraversal().flatMap(o -> JBIterable.of((Object[])o.getDeclaredFields())).filter(o -> Modifier.isStatic(o.getModifiers()));
        for (Field field : fields) {
            try {
                processor.consume((Object)field, field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static void ensureInterfacesAreInitializedInOrder(@NotNull Class<?> factoryClass) {
        if (factoryClass == null) {
            SqlTokenRegistry.$$$reportNull$$$0(28);
        }
        JBIterable interfaces = ReflectionStartupUtil.classTraverser(factoryClass).postOrderDfsTraversal().filter(o -> o.isInterface());
        for (Class aClass : interfaces) {
            Field[] fields = aClass.getDeclaredFields();
            if (fields.length == 0) continue;
            try {
                fields[0].get(null);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testInterceptor";
                break;
            }
            case 7: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 10: 
            case 14: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/util/SqlTokenRegistry";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordSet";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/util/SqlTokenRegistry";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCompositeTypes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenProvider";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSafeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTestInterceptor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getImpl";
                break;
            }
            case 10: 
            case 14: 
            case 21: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTokenType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCompositeType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initTypeMap";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addTokensToClassMap";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setTypeMap";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTokenProvider";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSafeMap";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildTokenMap";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "consumeStaticFieldsInOrder";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureInterfacesAreInitializedInOrder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

