/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageDialect
extends Language {
    public static final DbmsExtension<SqlLanguageDialect> EP = new DbmsExtension("com.intellij.sql.dialect");
    public static final String ISO_SQL_ID = "SQL92";
    public static final String GENERIC_SQL_ID = "GenericSQL";

    public SqlLanguageDialect(@NonNls @NotNull String id) {
        if (id == null) {
            SqlLanguageDialect.$$$reportNull$$$0(0);
        }
        super((Language)SqlLanguage.INSTANCE, id, new String[0]);
    }

    protected SqlLanguageDialect(@NotNull SqlLanguageDialect base, @NonNls @NotNull String id) {
        if (base == null) {
            SqlLanguageDialect.$$$reportNull$$$0(1);
        }
        if (id == null) {
            SqlLanguageDialect.$$$reportNull$$$0(2);
        }
        super((Language)base, id, new String[0]);
    }

    @NotNull
    public abstract DatabaseDialect getDatabaseDialect();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract Dbms getDbms();

    public abstract boolean isReservedKeyword(IElementType var1);

    public boolean isReservedKeywordPL(IElementType tokenType) {
        return this.isReservedKeyword(tokenType);
    }

    public abstract boolean isOperatorSupported(IElementType var1);

    @NotNull
    public abstract Set<String> getKeywords();

    @NotNull
    public abstract Set<String> getReservedKeywords();

    @NotNull
    public abstract Set<String> getSystemVariables();

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            SqlLanguageDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            SqlLanguageDialect.$$$reportNull$$$0(4);
        }
        return false;
    }

    public boolean isResolveTargetNotAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            SqlLanguageDialect.$$$reportNull$$$0(5);
        }
        return false;
    }

    public boolean shouldHide(@Nullable DasSymbol symbol, @Nullable PsiElement place) {
        return false;
    }

    public abstract TokenSet getStatementSeparators();

    public abstract Collection<ObjectKind> getMajorChildKinds();

    public final boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialect.$$$reportNull$$$0(6);
        }
        return this.getMajorChildKinds().contains(kind);
    }

    public abstract boolean shouldSkipFromQualification(@NotNull ObjectKind var1);

    public abstract <T extends Collection<ObjectKind>> T getParentDbTypes(T var1, ObjectKind var2);

    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            SqlLanguageDialect.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            SqlLanguageDialect.$$$reportNull$$$0(8);
        }
        return true;
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        if (processor == null) {
            SqlLanguageDialect.$$$reportNull$$$0(9);
        }
        if (state == null) {
            SqlLanguageDialect.$$$reportNull$$$0(10);
        }
        if (ref == null) {
            SqlLanguageDialect.$$$reportNull$$$0(11);
        }
        return true;
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull SqlReference ref, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            SqlLanguageDialect.$$$reportNull$$$0(12);
        }
        if (state == null) {
            SqlLanguageDialect.$$$reportNull$$$0(13);
        }
        if (ref == null) {
            SqlLanguageDialect.$$$reportNull$$$0(14);
        }
        if (qualifier == null) {
            SqlLanguageDialect.$$$reportNull$$$0(15);
        }
        return true;
    }

    public boolean processImplicitlyQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull SqlReference ref) {
        if (processor == null) {
            SqlLanguageDialect.$$$reportNull$$$0(16);
        }
        if (state == null) {
            SqlLanguageDialect.$$$reportNull$$$0(17);
        }
        if (ref == null) {
            SqlLanguageDialect.$$$reportNull$$$0(18);
        }
        return true;
    }

    @NotNull
    public static SqlLanguageDialect getGenericDialect() {
        List<SqlLanguageDialect> dialects = EP.allForDbms(Dbms.UNKNOWN);
        assert (!dialects.isEmpty()) : "Generic dialect must exist (but found no dialects related to 'UNKNOWN' dbms)";
        SqlLanguageDialect dialect = (SqlLanguageDialect)((Object)ContainerUtil.find(dialects, d -> d.getID().equals(GENERIC_SQL_ID)));
        assert (dialect != null) : "No Generic dialect found but found " + dialects.size() + " other ones";
        SqlLanguageDialect sqlLanguageDialect = dialect;
        if (sqlLanguageDialect == null) {
            SqlLanguageDialect.$$$reportNull$$$0(19);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getIsoDialect() {
        List<SqlLanguageDialect> dialects = EP.allForDbms(Dbms.UNKNOWN);
        assert (!dialects.isEmpty()) : "Iso dialect must exist (but found no dialects related to 'UNKNOWN' dbms)";
        SqlLanguageDialect dialect = (SqlLanguageDialect)((Object)ContainerUtil.find(dialects, d -> d.getID().equals(ISO_SQL_ID)));
        assert (dialect != null) : "No Iso dialect found but found " + dialects.size() + " other ones";
        SqlLanguageDialect sqlLanguageDialect = dialect;
        if (sqlLanguageDialect == null) {
            SqlLanguageDialect.$$$reportNull$$$0(20);
        }
        return sqlLanguageDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlLanguageDialect";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericDialect";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsoDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 19: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitlyQualifiedResolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

