/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.script.ScriptModel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqlNotebookManager {
    @NotNull
    public Collection<Cell> getCells(@NotNull PsiFile var1, @NotNull ScriptModel<PsiElement> var2, @NotNull Condition<? super TextRange> var3, int var4, int var5);

    @Nullable
    public <E> E getPrecedingComment(@Nullable E var1, @NotNull SyntaxTraverser.Api<E> var2);

    public static final class Cell {
        public static final int UNDEFINED = -1;
        public final TextRange range;
        public final List<TextRange> ranges;
        public final int lastStatementEnd;

        public Cell(TextRange range, List<TextRange> ranges, int end) {
            this.range = range;
            this.ranges = ranges;
            this.lastStatementEnd = end == -1 ? range.getEndOffset() : end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cell cell = (Cell)o;
            return this.lastStatementEnd == cell.lastStatementEnd && this.range.equals((Object)cell.range) && this.ranges.equals(cell.ranges);
        }

        public int hashCode() {
            return Objects.hash(this.range, this.ranges, this.lastStatementEnd);
        }
    }
}

