/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.Casing;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectPath {
    private static final Interner<ObjectPath> ourInterner = new WeakInterner((TObjectHashingStrategy)new TObjectHashingStrategy<ObjectPath>(){

        public int computeHashCode(ObjectPath object) {
            int result = System.identityHashCode(object.parent);
            result = 31 * result + object.kind.hashCode();
            result = 31 * result + object.name.hashCode();
            result = 31 * result + Boolean.hashCode(object.isQuoted());
            result = 31 * result + Comparing.hashcode((Object)object.getIdentity());
            return result;
        }

        public boolean equals(ObjectPath o1, ObjectPath o2) {
            if (o1 == o2 || o1 == null || o2 == null) {
                return o1 == o2;
            }
            return o1.parent == o2.parent && o1.matches(o2);
        }
    });
    public final ObjectPath parent;
    public final ObjectKind kind;
    public final String name;
    private static final List<String> TO_ESCAPE = Arrays.asList("/", "&", "\"", ":");
    private static final List<String> TO_UNESCAPE = Arrays.asList("&eslash;", "&amp;", "&quot;", "&colon;");

    private ObjectPath(@NotNull String name, @NotNull ObjectKind kind, @Nullable ObjectPath parent) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(1);
        }
        this.name = name;
        this.kind = kind;
        this.parent = parent;
    }

    public boolean isQuoted() {
        return true;
    }

    @Nullable
    public String getIdentity() {
        return null;
    }

    @NotNull
    public ObjectPath append(@NotNull String name, @NotNull ObjectKind kind) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(3);
        }
        ObjectPath objectPath = ObjectPath.create(name, kind, true, null, this);
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(4);
        }
        return objectPath;
    }

    public ObjectPath append(@NotNull String name, @NotNull ObjectKind kind, boolean quoted, String identity) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(5);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(6);
        }
        return ObjectPath.create(name, kind, quoted, identity, this);
    }

    public int getSize() {
        int result = 0;
        ObjectPath p = this;
        while (p != null) {
            ++result;
            p = p.parent;
        }
        return result;
    }

    @Nullable
    public ObjectPath getParent(int steps) {
        ObjectPath result = this;
        for (int i = steps; i > 0 && result != null; --i) {
            result = result.parent;
        }
        return result;
    }

    @Nullable
    public ObjectPath findParent(ObjectKind kind, boolean strict) {
        ObjectPath p;
        ObjectPath objectPath = p = strict ? this.parent : this;
        while (p != null) {
            if (p.kind == kind) {
                return p;
            }
            p = p.parent;
        }
        return null;
    }

    public boolean isAncestorOf(@Nullable ObjectPath child, boolean strict) {
        if (strict && this == child) {
            return false;
        }
        while (child != null && child != this) {
            child = child.parent;
        }
        return this == child;
    }

    @NlsSafe
    @NotNull
    public String getDisplayName() {
        String string = this.reduce(new StringBuilder(), (sb, p) -> (sb.length() > 0 && p.name.length() > 0 ? sb.append(".") : sb).append(p.name)).toString();
        if (string == null) {
            ObjectPath.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            ObjectPath.$$$reportNull$$$0(8);
        }
        return string;
    }

    public <T> T reduce(T t, @NotNull PairFunction<T, ObjectPath, T> reducer) {
        if (reducer == null) {
            ObjectPath.$$$reportNull$$$0(9);
        }
        T result = t;
        if (this.parent != null) {
            result = this.parent.reduce(t, reducer);
        }
        return (T)reducer.fun(result, (Object)this);
    }

    @NotNull
    public static ObjectPath create(@NotNull String name, @NotNull ObjectKind kind) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(10);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(11);
        }
        ObjectPath objectPath = ObjectPath.create(name, kind, true, null, null);
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(12);
        }
        return objectPath;
    }

    public static ObjectPath create(@NotNull String name, @NotNull ObjectKind kind, boolean quoted, @Nullable String identity, @Nullable ObjectPath parent) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(13);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(14);
        }
        return (ObjectPath)ourInterner.intern((Object)ObjectPath.createInner(name, kind, quoted, identity, parent));
    }

    public static ObjectPath copyUnder(@NotNull ObjectPath child, @Nullable ObjectPath parent) {
        if (child == null) {
            ObjectPath.$$$reportNull$$$0(15);
        }
        return ObjectPath.create(child.name, child.kind, child.isQuoted(), child.getIdentity(), parent);
    }

    @NotNull
    private static ObjectPath createInner(@NotNull String name, @NotNull ObjectKind kind, final boolean quoted, final @Nullable String identity, @Nullable ObjectPath parent) {
        if (name == null) {
            ObjectPath.$$$reportNull$$$0(16);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(17);
        }
        if (quoted && identity == null) {
            return new ObjectPath(name, kind, parent);
        }
        if (identity == null) {
            return new ObjectPath(name, kind, parent){

                @Override
                public boolean isQuoted() {
                    return false;
                }
            };
        }
        if (quoted) {
            new ObjectPath(name, kind, parent){

                @Override
                public String getIdentity() {
                    return identity;
                }
            };
        }
        return new ObjectPath(name, kind, parent){

            @Override
            public boolean isQuoted() {
                return quoted;
            }

            @Override
            public String getIdentity() {
                return identity;
            }
        };
    }

    @NotNull
    public static ObjectPath create(@NotNull ObjectKind kind, @NotNull Iterable<String> names) {
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(18);
        }
        if (names == null) {
            ObjectPath.$$$reportNull$$$0(19);
        }
        ObjectPath result = null;
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            result = ObjectPath.create(it.next(), !it.hasNext() ? kind : ObjectKind.NONE, true, null, result);
        }
        ObjectPath objectPath = Objects.requireNonNull(result);
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(20);
        }
        return objectPath;
    }

    public <T extends Throwable> void forEach(@NotNull ThrowableConsumer<ObjectPath, T> r) throws T {
        if (r == null) {
            ObjectPath.$$$reportNull$$$0(21);
        }
        ObjectPath.forEachInner(this, r);
    }

    private static <T extends Throwable> void forEachInner(@NotNull ObjectPath p, @NotNull ThrowableConsumer<ObjectPath, T> r) throws T {
        if (p == null) {
            ObjectPath.$$$reportNull$$$0(22);
        }
        if (r == null) {
            ObjectPath.$$$reportNull$$$0(23);
        }
        if (p.parent != null) {
            ObjectPath.forEachInner(p.parent, r);
        }
        r.consume((Object)p);
    }

    public String toString() {
        String id = this.getIdentity();
        return (String)(this.parent != null ? this.parent + "/" : "") + (String)(this.kind == ObjectKind.NONE ? "" : this.kind.name() + ":") + this.name + (String)(id == null ? "" : "@" + id);
    }

    public boolean matches(@NotNull ObjectPath o) {
        if (o == null) {
            ObjectPath.$$$reportNull$$$0(24);
        }
        if (this == o) {
            return true;
        }
        if (!this.kind.equals(o.kind)) {
            return false;
        }
        if (!this.name.equals(o.name)) {
            return false;
        }
        if (!Comparing.equal((Object)this.isQuoted(), (Object)o.isQuoted())) {
            return false;
        }
        return Objects.equals(this.getIdentity(), o.getIdentity());
    }

    @NotNull
    public String serialize() {
        String string = this.reduce(new StringBuilder(), (b, p) -> {
            if (b.length() != 0) {
                b.append("/");
            }
            b.append(ObjectPath.escape(p.kind.code())).append("/");
            if (p.isQuoted()) {
                b.append('\"');
            }
            b.append(ObjectPath.escape(p.name));
            if (p.isQuoted()) {
                b.append('\"');
            }
            if (p.getIdentity() != null) {
                b.append(ObjectPath.escape(p.getIdentity()));
            }
            return b;
        }).toString();
        if (string == null) {
            ObjectPath.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    public static ObjectPath deserialize(@NotNull String s) {
        if (s == null) {
            ObjectPath.$$$reportNull$$$0(26);
        }
        ObjectPath result = null;
        ObjectKind kind = null;
        for (String chunk : StringUtil.split((String)s, (String)"/", (boolean)true, (boolean)false)) {
            boolean quoted;
            String id;
            if (kind == null) {
                kind = ObjectKind.ourKinds.get(ObjectPath.unescape(chunk));
                if (kind != null) continue;
                kind = ObjectKind.NONE;
                continue;
            }
            int idIdx = chunk.indexOf(":");
            String string = id = idIdx == -1 ? null : ObjectPath.unescape(chunk.substring(idIdx + 1));
            if (idIdx != -1) {
                chunk = chunk.substring(0, idIdx);
            }
            boolean bl = quoted = chunk.startsWith("\"") && chunk.endsWith("\"");
            if (quoted) {
                chunk = chunk.substring(1, chunk.length() - 1);
            }
            String name = ObjectPath.unescape(chunk);
            result = ObjectPath.create(name, kind, true, null, result);
            kind = null;
        }
        if (kind != null) {
            result = ObjectPath.create("", kind, true, null, result);
        }
        return result;
    }

    private static String escape(String s) {
        return StringUtil.replace((String)s, TO_ESCAPE, TO_UNESCAPE);
    }

    private static String unescape(String s) {
        return StringUtil.replace((String)s, TO_UNESCAPE, TO_ESCAPE);
    }

    public static boolean namesEqual(@Nullable ObjectPath p1, @Nullable ObjectPath p2, @NotNull CasingProvider casingProvider) {
        if (casingProvider == null) {
            ObjectPath.$$$reportNull$$$0(27);
        }
        return p1 == null || p2 == null ? p1 == p2 : ObjectName.namesEqual(p1.name, casingProvider.getCasing(p1.kind, null).choose(!p1.isQuoted()), p2.name, casingProvider.getCasing(p2.kind, null).choose(!p2.isQuoted()));
    }

    public static boolean namesEqual(@Nullable ObjectPath p1, @Nullable ObjectPath p2, @NotNull Casing casing) {
        if (casing == null) {
            ObjectPath.$$$reportNull$$$0(28);
        }
        return p1 == null || p2 == null ? p1 == p2 : ObjectName.namesEqual(p1.name, casing.choose(!p1.isQuoted()), p2.name, casing.choose(!p2.isQuoted()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 20: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 20: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ObjectPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reducer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ObjectPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 20: 
            case 25: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyUnder";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createInner";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "forEachInner";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "namesEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 20: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

