/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ObjectKind
implements Comparable<ObjectKind> {
    private static final AtomicInteger ourOrderNumCounter = new AtomicInteger(0);
    public static final Map<String, ObjectKind> ourKinds = new ConcurrentHashMap<String, ObjectKind>();
    public static final ObjectKind NONE = new ObjectKind("NONE", DatabaseBundle.messagePointer("ObjectKind.none", new Object[0]));
    public static final ObjectKind ROOT = new ObjectKind("ROOT", DatabaseBundle.messagePointer("ObjectKind.root", new Object[0]));
    public static final ObjectKind DATABASE = new ObjectKind("DATABASE", DatabaseBundle.messagePointer("ObjectKind.database", new Object[0]));
    public static final ObjectKind SCHEMA = new ObjectKind("SCHEMA", DatabaseBundle.messagePointer("ObjectKind.schema", new Object[0]));
    public static final ObjectKind SEQUENCE = new ObjectKind("SEQUENCE", DatabaseBundle.messagePointer("ObjectKind.sequence", new Object[0]));
    public static final ObjectKind CLUSTER = new ObjectKind("CLUSTER", DatabaseBundle.messagePointer("ObjectKind.cluster", new Object[0]));
    public static final ObjectKind OBJECT_TYPE = new ObjectKind("OBJECT TYPE", DatabaseBundle.messagePointer("ObjectKind.object.type", new Object[0]));
    public static final ObjectKind COLLECTION_TYPE = new ObjectKind("COLLECTION TYPE", DatabaseBundle.messagePointer("ObjectKind.collection.type", new Object[0]));
    public static final ObjectKind TABLE_TYPE = new ObjectKind("TABLE TYPE", DatabaseBundle.messagePointer("ObjectKind.table.type", new Object[0]));
    public static final ObjectKind ALIAS_TYPE = new ObjectKind("ALIAS TYPE", DatabaseBundle.messagePointer("ObjectKind.alias.type", new Object[0]));
    public static final ObjectKind TABLE = new ObjectKind("TABLE", DatabaseBundle.messagePointer("ObjectKind.table", new Object[0]));
    public static final ObjectKind MAT_LOG = new ObjectKind("MATERIALIZED LOG", DatabaseBundle.messagePointer("ObjectKind.materialized.log", new Object[0]));
    public static final ObjectKind MAT_VIEW = new ObjectKind("MATERIALIZED VIEW", DatabaseBundle.messagePointer("ObjectKind.materialized.view", new Object[0]));
    public static final ObjectKind VIEW = new ObjectKind("VIEW", DatabaseBundle.messagePointer("ObjectKind.view", new Object[0]));
    public static final ObjectKind PACKAGE = new ObjectKind("PACKAGE", DatabaseBundle.messagePointer("ObjectKind.package", new Object[0]));
    public static final ObjectKind BODY = new ObjectKind("BODY", DatabaseBundle.messagePointer("ObjectKind.body", new Object[0]));
    public static final ObjectKind ROUTINE = new ObjectKind("ROUTINE", DatabaseBundle.messagePointer("ObjectKind.routine", new Object[0]));
    public static final ObjectKind METHOD = new ObjectKind("METHOD", DatabaseBundle.messagePointer("ObjectKind.method", new Object[0]));
    public static final ObjectKind OPERATOR = new ObjectKind("OPERATOR", DatabaseBundle.messagePointer("ObjectKind.operator", new Object[0]));
    public static final ObjectKind OBJECT_ATTRIBUTE = new ObjectKind("OBJECT ATTRIBUTE", DatabaseBundle.messagePointer("ObjectKind.object.attribute", new Object[0]));
    public static final ObjectKind COLUMN = new ObjectKind("COLUMN", DatabaseBundle.messagePointer("ObjectKind.column", new Object[0]));
    public static final ObjectKind INDEX = new ObjectKind("INDEX", DatabaseBundle.messagePointer("ObjectKind.index", new Object[0]));
    public static final ObjectKind KEY = new ObjectKind("KEY", DatabaseBundle.messagePointer("ObjectKind.key", new Object[0]));
    public static final ObjectKind FOREIGN_KEY = new ObjectKind("FOREIGN KEY", DatabaseBundle.messagePointer("ObjectKind.foreign.key", new Object[0]));
    public static final ObjectKind CHECK = new ObjectKind("CHECK", DatabaseBundle.messagePointer("ObjectKind.check", new Object[0]));
    public static final ObjectKind DEFAULT = new ObjectKind("DEFAULT", DatabaseBundle.messagePointer("ObjectKind.default", new Object[0]));
    public static final ObjectKind RULE = new ObjectKind("RULE", DatabaseBundle.messagePointer("ObjectKind.rule", new Object[0]));
    public static final ObjectKind TRIGGER = new ObjectKind("TRIGGER", DatabaseBundle.messagePointer("ObjectKind.trigger", new Object[0]));
    public static final ObjectKind ARGUMENT = new ObjectKind("ARGUMENT", DatabaseBundle.messagePointer("ObjectKind.argument", new Object[0]));
    public static final ObjectKind VARIABLE = new ObjectKind("VARIABLE", DatabaseBundle.messagePointer("ObjectKind.variable", new Object[0]));
    public static final ObjectKind SYNONYM = new ObjectKind("SYNONYM", DatabaseBundle.messagePointer("ObjectKind.synonym", new Object[0]));
    public static final ObjectKind DB_LINK = new ObjectKind("DBLINK", DatabaseBundle.messagePointer("ObjectKind.dblink", new Object[0]));
    public static final ObjectKind VIRTUAL_TABLE = new ObjectKind("VIRTUAL TABLE", DatabaseBundle.messagePointer("ObjectKind.virtual.table", new Object[0]));
    public static final ObjectKind COLLATION = new ObjectKind("COLLATION", DatabaseBundle.messagePointer("ObjectKind.collation", new Object[0]));
    public static final ObjectKind SCRIPT = new ObjectKind("SCRIPT", DatabaseBundle.messagePointer("ObjectKind.script", new Object[0]));
    public static final ObjectKind TABLESPACE = new ObjectKind("TABLESPACE", DatabaseBundle.messagePointer("ObjectKind.tablespace", new Object[0]));
    public static final ObjectKind DATA_FILE = new ObjectKind("DATA FILE", DatabaseBundle.messagePointer("ObjectKind.data.file", new Object[0]));
    public static final ObjectKind ROLE = new ObjectKind("ROLE", DatabaseBundle.messagePointer("ObjectKind.role", new Object[0]));
    public static final ObjectKind USER = new ObjectKind("USER", DatabaseBundle.messagePointer("ObjectKind.user", new Object[0]));
    public static final ObjectKind CONNECTION = new ObjectKind("CONNECTION", DatabaseBundle.messagePointer("ObjectKind.connection", new Object[0]));
    public static final ObjectKind FOREIGN_DATA_WRAPPER = new ObjectKind("FOREIGN DATA WRAPPER", DatabaseBundle.messagePointer("ObjectKind.foreign.data.wrapper", new Object[0]));
    public static final ObjectKind SERVER = new ObjectKind("SERVER", DatabaseBundle.messagePointer("ObjectKind.server", new Object[0]));
    public static final ObjectKind USER_MAPPING = new ObjectKind("USER MAPPING", DatabaseBundle.messagePointer("ObjectKind.user.mapping", new Object[0]));
    public static final ObjectKind FOREIGN_TABLE = new ObjectKind("FOREIGN TABLE", DatabaseBundle.messagePointer("ObjectKind.foreign.table", new Object[0]));
    public static final ObjectKind EXTERNAL_SCHEMA = new ObjectKind("EXTERNAL SCHEMA", DatabaseBundle.messagePointer("ObjectKind.external.schema", new Object[0]));
    public static final ObjectKind SCHEDULED_EVENT = new ObjectKind("SCHEDULED EVENT", DatabaseBundle.messagePointer("ObjectKind.scheduled.event", new Object[0]));
    public static final ObjectKind ACCESS_METHOD = new ObjectKind("ACCESS METHOD", DatabaseBundle.messagePointer("ObjectKind.access.method", new Object[0]));
    public static final ObjectKind AGGREGATE = new ObjectKind("AGGREGATE", DatabaseBundle.messagePointer("ObjectKind.aggregate", new Object[0]));
    public static final ObjectKind EXCEPTION = new ObjectKind("EXCEPTION", DatabaseBundle.messagePointer("ObjectKind.exception", new Object[0]));
    public static final ObjectKind EXTENSION = new ObjectKind("EXTENSION", DatabaseBundle.messagePointer("ObjectKind.extension", new Object[0]));
    public static final ObjectKind PROJECTION = new ObjectKind("PROJECTION", DatabaseBundle.messagePointer("ObjectKind.projection", new Object[0]));
    public static final ObjectKind MACRO = new ObjectKind("MACRO", DatabaseBundle.messagePointer("ObjectKind.macro", new Object[0]));
    public static final ObjectKind PARTITION = new ObjectKind("PARTITION", DatabaseBundle.messagePointer("ObjectKind.partition", new Object[0]));
    public static final ObjectKind WAREHOUSE = new ObjectKind("WAREHOUSE", DatabaseBundle.messagePointer("ObjectKind.warehouse", new Object[0]));
    public static final ObjectKind FORMAT = new ObjectKind("FORMAT", DatabaseBundle.messagePointer("ObjectKind.format", new Object[0]));
    public static final ObjectKind INDEX_EXTENSION = new ObjectKind("INDEX EXTENSION", DatabaseBundle.messagePointer("ObjectKind.index.extension", new Object[0]));
    public static final ObjectKind INDEX_SEARCH_METHOD = new ObjectKind("SEARCH METHOD", DatabaseBundle.messagePointer("ObjectKind.search.method", new Object[0]));
    public static final ObjectKind CONSTANT = new ObjectKind("CONSTANT", DatabaseBundle.messagePointer("ObjectKind.constant", new Object[0]));
    public static final ObjectKind PERIOD = new ObjectKind("PERIOD", DatabaseBundle.messagePointer("ObjectKind.period", new Object[0]));
    public static final ObjectKind LANGUAGE = new ObjectKind("LANGUAGE", DatabaseBundle.messagePointer("ObjectKind.language", new Object[0]));
    public static final ObjectKind LOGIN = new ObjectKind("LOGIN", DatabaseBundle.messagePointer("ObjectKind.login", new Object[0]));
    public static final ObjectKind OPERATOR_CLASS = new ObjectKind("OPERATOR CLASS", DatabaseBundle.messagePointer("ObjectKind.operator.class", new Object[0]));
    public static final ObjectKind OPERATOR_FAMILY = new ObjectKind("OPERATOR FAMILY", DatabaseBundle.messagePointer("ObjectKind.operator.family", new Object[0]));
    public static final ObjectKind UNKNOWN_OBJECT = new ObjectKind("UNKNOWN OBJECT", DatabaseBundle.messagePointer("ObjectKind.unknown.object", new Object[0]), Integer.MAX_VALUE);
    private static final int ourLastDatabaseKind = ourOrderNumCounter.get();
    private final String myName;
    private final Supplier<@Nls String> myPresentableName;
    private final int myOrderNum;
    private final String myCode;

    public ObjectKind(@NotNull String name, Supplier<@Nls String> presentableName) {
        if (name == null) {
            ObjectKind.$$$reportNull$$$0(0);
        }
        this(name, presentableName, ourOrderNumCounter.getAndIncrement());
    }

    private ObjectKind(@NotNull String name, Supplier<@Nls String> presentableName, int orderNum) {
        if (name == null) {
            ObjectKind.$$$reportNull$$$0(1);
        }
        this.myPresentableName = presentableName;
        assert (name.length() > 0);
        assert (orderNum >= 0);
        this.myName = name;
        this.myCode = StringUtil.toLowerCase((String)this.myName).replace(' ', '-');
        this.myOrderNum = orderNum;
        ourKinds.putIfAbsent(this.myCode, this);
    }

    public String name() {
        return this.myName;
    }

    public String code() {
        return this.myCode;
    }

    @Nls
    public String getPresentableName() {
        return this.myPresentableName.get();
    }

    public int getOrder() {
        return this.myOrderNum;
    }

    public String toString() {
        return this.code();
    }

    @Override
    public int compareTo(@NotNull ObjectKind that) {
        if (that == null) {
            ObjectKind.$$$reportNull$$$0(2);
        }
        if (this == that) {
            return 0;
        }
        if (this.myOrderNum < that.myOrderNum) {
            return -1;
        }
        if (this.myOrderNum > that.myOrderNum) {
            return 1;
        }
        throw new IllegalStateException(String.format("Uncomparable object kinds: %s and %s", this.code(), that.code()));
    }

    @NotNull
    public static JBIterable<ObjectKind> getDatabaseKinds() {
        JBIterable jBIterable = JBIterable.from(ourKinds.values()).filter(ObjectKind::isDatabaseKind);
        if (jBIterable == null) {
            ObjectKind.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public static boolean isDatabaseKind(@NotNull ObjectKind k) {
        if (k == null) {
            ObjectKind.$$$reportNull$$$0(4);
        }
        return k.myOrderNum < ourLastDatabaseKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ObjectKind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ObjectKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseKinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDatabaseKind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

