/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.jdk;

import java.text.MessageFormat;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.messages.internal.Messages;

public final class JdkAggregators {
    public static final IAggregator<String, ?> JVM_NAME = Aggregators.distinctAsString((String)"jdk.JVMInformation", JdkAttributes.JVM_NAME);
    public static final IAggregator<IQuantity, ?> JVM_PID = Aggregators.min((String)JdkAttributes.JVM_PID.getName(), null, (String)"jdk.JVMInformation", JdkAttributes.JVM_PID);
    public static final IAggregator<IQuantity, ?> JVM_START_TIME = Aggregators.min((String)JdkAttributes.JVM_START_TIME.getName(), null, (String)"jdk.JVMInformation", JdkAttributes.JVM_START_TIME);
    public static final IAggregator<String, ?> JVM_VERSION = Aggregators.distinctAsString((String)"jdk.JVMInformation", JdkAttributes.JVM_VERSION);
    public static final IAggregator<String, ?> JAVA_ARGUMENTS = Aggregators.distinctAsString((String)"jdk.JVMInformation", JdkAttributes.JAVA_ARGUMENTS);
    public static final IAggregator<String, ?> JVM_ARGUMENTS = Aggregators.distinctAsString((String)"jdk.JVMInformation", JdkAttributes.JVM_ARGUMENTS);
    public static final IAggregator<IQuantity, ?> JVM_SHUTDOWN_TIME = Aggregators.min((String)Messages.getString("ATTR_SHUTDOWN_TIME"), null, (String)"jdk.Shutdown", JfrAttributes.START_TIME);
    public static final IAggregator<String, ?> JVM_SHUTDOWN_REASON = Aggregators.distinctAsString((String)"jdk.Shutdown", JdkAttributes.SHUTDOWN_REASON);
    public static final IAggregator<IQuantity, ?> MIN_HW_THREADS = Aggregators.min((String)JdkAttributes.HW_THREADS.getName(), null, (String)"jdk.CPUInformation", JdkAttributes.HW_THREADS);
    public static final IAggregator<IQuantity, ?> MIN_NUMBER_OF_CORES = Aggregators.min((String)JdkAttributes.NUMBER_OF_CORES.getName(), null, (String)"jdk.CPUInformation", JdkAttributes.NUMBER_OF_CORES);
    public static final IAggregator<IQuantity, ?> MIN_NUMBER_OF_SOCKETS = Aggregators.min((String)JdkAttributes.NUMBER_OF_SOCKETS.getName(), null, (String)"jdk.CPUInformation", JdkAttributes.NUMBER_OF_SOCKETS);
    public static final IAggregator<String, ?> CPU_DESCRIPTION = Aggregators.distinctAsString((String)"jdk.CPUInformation", JdkAttributes.CPU_DESCRIPTION);
    public static final IAggregator<String, ?> CPU_TYPE = Aggregators.distinctAsString((String)"jdk.CPUInformation", JdkAttributes.CPU_TYPE);
    public static final IAggregator<String, ?> OS_VERSION = Aggregators.distinctAsString((String)"jdk.OSInformation", JdkAttributes.OS_VERSION);
    public static final IAggregator<IQuantity, ?> MAX_USED_MEMORY = Aggregators.max((String)Messages.getString("AGGR_MAX_USED_MEMORY"), null, (String)"jdk.PhysicalMemory", JdkAttributes.OS_MEMORY_USED);
    public static final IAggregator<IQuantity, ?> MIN_TOTAL_MEMORY = Aggregators.min((String)Messages.getString("AGGR_MIN_TOTAL_MEMORY"), null, (String)"jdk.PhysicalMemory", JdkAttributes.OS_MEMORY_TOTAL);
    public static final IAggregator<IQuantity, ?> HEAP_CONF_MAX_SIZE = Aggregators.max((String)JdkAttributes.HEAP_MAX_SIZE.getName(), null, (String)"jdk.GCHeapConfiguration", JdkAttributes.HEAP_MAX_SIZE);
    public static final IAggregator<IQuantity, ?> HEAP_CONF_MIN_SIZE = Aggregators.min((String)JdkAttributes.HEAP_MIN_SIZE.getName(), null, (String)"jdk.GCHeapConfiguration", JdkAttributes.HEAP_MIN_SIZE);
    public static final IAggregator<IQuantity, ?> HEAP_CONF_INITIAL_SIZE_MIN = Aggregators.min((String)JdkAttributes.HEAP_INITIAL_SIZE.getName(), null, (String)"jdk.GCHeapConfiguration", JdkAttributes.HEAP_INITIAL_SIZE);
    public static final IAggregator<IQuantity, ?> HEAP_OBJECT_ALIGNMENT_MIN = Aggregators.min((String)JdkAttributes.HEAP_OBJECT_ALIGNMENT.getName(), null, (String)"jdk.GCHeapConfiguration", JdkAttributes.HEAP_OBJECT_ALIGNMENT);
    public static final IAggregator<IQuantity, ?> HEAP_ADDRESS_SIZE_MIN = Aggregators.min((String)JdkAttributes.HEAP_ADDRESS_SIZE.getName(), null, (String)"jdk.GCHeapConfiguration", JdkAttributes.HEAP_ADDRESS_SIZE);
    public static final IAggregator<Boolean, ?> USE_COMPRESSED_OOPS = Aggregators.or((String)"jdk.GCHeapConfiguration", JdkAttributes.HEAP_USE_COMPRESSED_OOPS);
    public static final IAggregator<String, ?> COMPRESSED_OOPS_MODE = Aggregators.distinctAsString((String)"jdk.GCHeapConfiguration", JdkAttributes.HEAP_COMPRESSED_OOPS_MODE);
    public static final IAggregator<String, ?> OLD_COLLECTOR = Aggregators.distinctAsString((String)"jdk.GCConfiguration", JdkAttributes.OLD_COLLECTOR);
    public static final IAggregator<String, ?> YOUNG_COLLECTOR = Aggregators.distinctAsString((String)"jdk.GCConfiguration", JdkAttributes.YOUNG_COLLECTOR);
    public static final IAggregator<IQuantity, ?> PARALLEL_GC_THREAD_COUNT_MAX = Aggregators.max((String)"jdk.GCConfiguration", JdkAttributes.PARALLEL_GC_THREADS);
    public static final IAggregator<IQuantity, ?> PARALLEL_GC_THREAD_COUNT_MIN = Aggregators.min((String)JdkAttributes.PARALLEL_GC_THREADS.getName(), null, (String)"jdk.GCConfiguration", JdkAttributes.PARALLEL_GC_THREADS);
    public static final IAggregator<IQuantity, ?> CONCURRENT_GC_THREAD_COUNT_MIN = Aggregators.min((String)JdkAttributes.CONCURRENT_GC_THREADS.getName(), null, (String)"jdk.GCConfiguration", JdkAttributes.CONCURRENT_GC_THREADS);
    public static final IAggregator<Boolean, ?> EXPLICIT_GC_CONCURRENT = Aggregators.or((String)"jdk.GCConfiguration", JdkAttributes.EXPLICIT_GC_CONCURRENT);
    public static final IAggregator<Boolean, ?> EXPLICIT_GC_DISABLED = Aggregators.or((String)"jdk.GCConfiguration", JdkAttributes.EXPLICIT_GC_DISABLED);
    public static final IAggregator<Boolean, ?> USE_DYNAMIC_GC_THREADS = Aggregators.or((String)"jdk.GCConfiguration", JdkAttributes.USE_DYNAMIC_GC_THREADS);
    public static final IAggregator<IQuantity, ?> GC_TIME_RATIO_MIN = Aggregators.min((String)JdkAttributes.GC_TIME_RATIO.getName(), null, (String)"jdk.GCConfiguration", JdkAttributes.GC_TIME_RATIO);
    public static final IAggregator<IQuantity, ?> YOUNG_GENERATION_MIN_SIZE = Aggregators.max((String)JdkAttributes.YOUNG_GENERATION_MIN_SIZE.getName(), null, (String)"jdk.YoungGenerationConfiguration", JdkAttributes.YOUNG_GENERATION_MIN_SIZE);
    public static final IAggregator<IQuantity, ?> YOUNG_GENERATION_MAX_SIZE = Aggregators.min((String)JdkAttributes.YOUNG_GENERATION_MAX_SIZE.getName(), null, (String)"jdk.YoungGenerationConfiguration", JdkAttributes.YOUNG_GENERATION_MIN_SIZE);
    public static final IAggregator<IQuantity, ?> NEW_RATIO_MIN = Aggregators.min((String)JdkAttributes.NEW_RATIO.getName(), null, (String)"jdk.YoungGenerationConfiguration", JdkAttributes.NEW_RATIO);
    public static final IAggregator<IQuantity, ?> TENURING_THRESHOLD_INITIAL_MIN = Aggregators.min((String)JdkAttributes.TENURING_THRESHOLD_INITIAL.getName(), null, (String)"jdk.GCSurvivorConfiguration", JdkAttributes.TENURING_THRESHOLD_INITIAL);
    public static final IAggregator<IQuantity, ?> TENURING_THRESHOLD_MAX = Aggregators.max((String)JdkAttributes.TENURING_THRESHOLD_MAXIMUM.getName(), null, (String)"jdk.GCSurvivorConfiguration", JdkAttributes.TENURING_THRESHOLD_MAXIMUM);
    public static final IAggregator<Boolean, ?> USES_TLABS = Aggregators.or((String)"jdk.GCTLABConfiguration", JdkAttributes.USES_TLABS);
    public static final IAggregator<IQuantity, ?> TLAB_MIN_SIZE = Aggregators.min((String)JdkAttributes.TLAB_MIN_SIZE.getName(), null, (String)"jdk.GCTLABConfiguration", JdkAttributes.TLAB_MIN_SIZE);
    public static final IAggregator<IQuantity, ?> TLAB_REFILL_WASTE_LIMIT_MIN = Aggregators.min((String)JdkAttributes.TLAB_REFILL_WASTE_LIMIT.getName(), null, (String)"jdk.GCTLABConfiguration", JdkAttributes.TLAB_REFILL_WASTE_LIMIT);
    public static final IAggregator<IQuantity, ?> AVG_HEAP_USED_BEFORE_GC = Aggregators.filter((String)Messages.getString("AGGR_AVG_HEAP_USED_BEFORE_GC"), null, (IAggregator)Aggregators.avg((String)"jdk.GCHeapSummary", JdkAttributes.HEAP_USED), (IItemFilter)JdkFilters.BEFORE_GC);
    public static final IAggregator<IQuantity, ?> AVG_HEAP_USED_AFTER_GC = Aggregators.filter((String)Messages.getString("AGGR_AVG_HEAP_USED_AFTER_GC"), null, (IAggregator)Aggregators.avg((String)"jdk.GCHeapSummary", JdkAttributes.HEAP_USED), (IItemFilter)JdkFilters.AFTER_GC);
    public static final IAggregator<IQuantity, ?> SUM_HEAP_USED_BEFORE_GC = Aggregators.filter((String)"SUM_HEAP_USED_BEFORE_GC", null, (IAggregator)Aggregators.sum((String)"jdk.GCHeapSummary", JdkAttributes.HEAP_USED), (IItemFilter)JdkFilters.BEFORE_GC);
    public static final IAggregator<IQuantity, ?> SUM_HEAP_USED_AFTER_GC = Aggregators.filter((String)"SUM_HEAP_USED_AFTER_GC", null, (IAggregator)Aggregators.sum((String)"jdk.GCHeapSummary", JdkAttributes.HEAP_USED), (IItemFilter)JdkFilters.AFTER_GC);
    public static final IAggregator<IQuantity, ?> OBJECT_COUNT_MAX_SIZE = Aggregators.max((String)Messages.getString("AGGR_OBJECT_COUNT_MAX_SIZE"), (String)Messages.getString("AGGR_OBJECT_COUNT_MAX_SIZE_DESC"), (String)"jdk.ObjectCount", JdkAttributes.HEAP_TOTAL);
    public static final IAggregator<IQuantity, ?> OBJECT_COUNT_MAX_INSTANCES = Aggregators.max((String)Messages.getString("AGGR_OBJECT_COUNT_MAX_INSTANCES"), (String)Messages.getString("AGGR_OBJECT_COUNT_MAX_INSTANCES_DESC"), (String)"jdk.ObjectCount", JdkAttributes.COUNT);
    public static final IAggregator<Boolean, ?> UNLOCK_EXPERIMENTAL_VM_OPTIONS = Aggregators.filter((String)Messages.getString("AGGR_UNLOCK_EXPERIMENTAL_VM_OPTIONS"), null, (IAggregator)Aggregators.or((String)"jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), (IItemFilter)ItemFilters.equals(JdkAttributes.FLAG_NAME, (Object)"UnlockExperimentalVMOptions"));
    public static final IAggregator<Boolean, ?> IGNORE_UNRECOGNIZED_VM_OPTIONS = Aggregators.filter((String)Messages.getString("AGGR_IGNORE_UNRECOGNIZED_VM_OPTIONS"), null, (IAggregator)Aggregators.or((String)"jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), (IItemFilter)ItemFilters.equals(JdkAttributes.FLAG_NAME, (Object)"IgnoreUnrecognizedVMOptions"));
    public static final IAggregator<Boolean, ?> USE_STRING_DEDUPLICATION = Aggregators.filter((String)"UseStringDeduplication", null, (IAggregator)Aggregators.or((String)"jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), (IItemFilter)ItemFilters.equals(JdkAttributes.FLAG_NAME, (Object)"UseStringDeduplication"));
    public static final IAggregator<Boolean, ?> USE_G1_GC = Aggregators.filter((String)"UseG1GC", null, (IAggregator)Aggregators.or((String)"jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), (IItemFilter)ItemFilters.equals(JdkAttributes.FLAG_NAME, (Object)"UseG1GC"));
    public static final IAggregator<Boolean, ?> USE_SHENANDOAH_GC = Aggregators.filter((String)"UseShenandoahGC", null, (IAggregator)Aggregators.or((String)"jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), (IItemFilter)ItemFilters.equals(JdkAttributes.FLAG_NAME, (Object)"UseShenandoahGC"));
    public static final IAggregator<Boolean, ?> COMPACT_STRINGS = Aggregators.filter((String)"CompactStrings", null, (IAggregator)Aggregators.or((String)"jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), (IItemFilter)ItemFilters.equals(JdkAttributes.FLAG_NAME, (Object)"CompactStrings"));
    public static final IAggregator<IQuantity, ?> LARGEST_MAX_HEAP_SIZE_FROM_FLAG = Aggregators.filter((String)Messages.getString("AGGR_LARGEST_MAX_HEAP_SIZE_FROM_FLAG"), null, (IAggregator)Aggregators.max((String)"jdk.UnsignedLongFlag", JdkAttributes.FLAG_VALUE_NUMBER), (IItemFilter)ItemFilters.equals(JdkAttributes.FLAG_NAME, (Object)"MaxHeapSize"));
    public static final IAggregator<IQuantity, ?> OUTSIDE_TLAB_COUNT = Aggregators.count((String)Messages.getString("AGGR_OUTSIDE_TLAB_COUNT"), (String)Messages.getString("AGGR_OUTSIDE_TLAB_COUNT_DESC"), (IItemFilter)JdkFilters.ALLOC_OUTSIDE_TLAB);
    public static final IAggregator<IQuantity, ?> INSIDE_TLAB_COUNT = Aggregators.count((String)Messages.getString("AGGR_INSIDE_TLAB_COUNT"), (String)Messages.getString("AGGR_INSIDE_TLAB_COUNT_DESC"), (IItemFilter)JdkFilters.ALLOC_INSIDE_TLAB);
    public static final IAggregator<IQuantity, ?> FILE_WRITE_LONGEST = Aggregators.max((String)"jdk.FileWrite", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> FILE_WRITE_LARGEST = Aggregators.max((String)"jdk.FileWrite", JdkAttributes.IO_FILE_BYTES_WRITTEN);
    public static final IAggregator<IQuantity, ?> FILE_READ_LONGEST = Aggregators.max((String)"jdk.FileRead", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> FILE_READ_LARGEST = Aggregators.max((String)"jdk.FileRead", JdkAttributes.IO_FILE_BYTES_READ);
    public static final IAggregator<IQuantity, ?> FILE_WRITE_SIZE = Aggregators.sum((String)Messages.getString("AGGR_FILE_WRITE_SIZE"), (String)Messages.getString("AGGR_FILE_WRITE_SIZE_DESC"), (String)"jdk.FileWrite", JdkAttributes.IO_FILE_BYTES_WRITTEN);
    public static final IAggregator<IQuantity, ?> FILE_READ_SIZE = Aggregators.sum((String)Messages.getString("AGGR_FILE_READ_SIZE"), (String)Messages.getString("AGGR_FILE_READ_SIZE_DESC"), (String)"jdk.FileRead", JdkAttributes.IO_FILE_BYTES_READ);
    public static final IAggregator<IQuantity, ?> FILE_WRITE_COUNT = Aggregators.count((String)Messages.getString("AGGR_FILE_WRITE_COUNT"), (String)Messages.getString("AGGR_FILE_WRITE_COUNT_DESC"), (IItemFilter)JdkFilters.FILE_WRITE);
    public static final IAggregator<IQuantity, ?> FILE_READ_COUNT = Aggregators.count((String)Messages.getString("AGGR_FILE_READ_COUNT"), (String)Messages.getString("AGGR_FILE_READ_COUNT_DESC"), (IItemFilter)JdkFilters.FILE_READ);
    public static final IAggregator<IQuantity, ?> ERROR_COUNT = Aggregators.count((String)Messages.getString("AGGR_ERROR_COUNT"), (String)Messages.getString("AGGR_ERROR_COUNT_DESC"), (IItemFilter)JdkFilters.ERRORS);
    public static final IAggregator<IQuantity, ?> EXCEPTIONS_COUNT = Aggregators.count((String)Messages.getString("AGGR_EXCEPTIONS_COUNT"), (String)Messages.getString("AGGR_EXCEPTIONS_COUNT_DESC"), (IItemFilter)JdkFilters.EXCEPTIONS);
    public static final IAggregator<IQuantity, ?> THROWABLES_COUNT = Aggregators.count((String)Messages.getString("AGGR_THROWABLES_COUNT"), (String)Messages.getString("AGGR_THROWABLES_COUNT_DESC"), (IItemFilter)JdkFilters.THROWABLES);
    public static final IAggregator<IQuantity, ?> CODE_CACHE_FULL_COUNT = Aggregators.count((String)Messages.getString("AGGR_CODE_CACHE_FULL_COUNT"), (String)Messages.getString("AGGR_CODE_CACHE_FULL_COUNT_DESC"), (IItemFilter)JdkFilters.CODE_CACHE_FULL);
    public static final IAggregator<IQuantity, ?> SOCKET_WRITE_LONGEST = Aggregators.max((String)"jdk.SocketWrite", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> SOCKET_WRITE_LARGEST = Aggregators.max((String)"jdk.SocketWrite", JdkAttributes.IO_SOCKET_BYTES_WRITTEN);
    public static final IAggregator<IQuantity, ?> SOCKET_READ_LONGEST = Aggregators.max((String)"jdk.SocketRead", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> SOCKET_READ_LARGEST = Aggregators.max((String)"jdk.SocketRead", JdkAttributes.IO_SOCKET_BYTES_READ);
    public static final IAggregator<IQuantity, ?> SOCKET_WRITE_SIZE = Aggregators.sum((String)Messages.getString("AGGR_SOCKET_WRITE_SIZE"), (String)Messages.getString("AGGR_SOCKET_WRITE_SIZE_DESC"), (String)"jdk.SocketWrite", JdkAttributes.IO_SOCKET_BYTES_WRITTEN);
    public static final IAggregator<IQuantity, ?> SOCKET_READ_SIZE = Aggregators.sum((String)Messages.getString("AGGR_SOCKET_READ_SIZE"), (String)Messages.getString("AGGR_SOCKET_READ_SIZE_DESC"), (String)"jdk.SocketRead", JdkAttributes.IO_SOCKET_BYTES_READ);
    public static final IAggregator<IQuantity, ?> SOCKET_WRITE_COUNT = Aggregators.count((String)Messages.getString("AGGR_SOCKET_WRITE_COUNT"), (String)Messages.getString("AGGR_SOCKET_WRITE_COUNT_DESC"), (IItemFilter)JdkFilters.SOCKET_WRITE);
    public static final IAggregator<IQuantity, ?> SOCKET_READ_COUNT = Aggregators.count((String)Messages.getString("AGGR_SOCKET_READ_COUNT"), (String)Messages.getString("AGGR_SOCKET_READ_COUNT_DESC"), (IItemFilter)JdkFilters.SOCKET_READ);
    public static final IAggregator<IQuantity, ?> NUMBER_OF_DISTINCT_PORTS = Aggregators.filter((IAggregator)Aggregators.countDistinct((String)Messages.getString("AGGR_NUMBER_OF_DISTINCT_PORTS"), (String)Messages.getString("AGGR_NUMBER_OF_DISTINCT_PORTS_DESC"), JdkAttributes.IO_PORT), (IItemFilter)JdkFilters.SOCKET_READ_OR_WRITE);
    public static final IAggregator<IQuantity, ?> NUMBER_OF_DISTINCT_HOSTS = Aggregators.filter((IAggregator)Aggregators.countDistinct((String)Messages.getString("AGGR_NUMBER_OF_DISTINCT_HOSTS"), (String)Messages.getString("AGGR_NUMBER_OF_DISTINCT_HOSTS_DESC"), JdkAttributes.IO_ADDRESS), (IItemFilter)JdkFilters.SOCKET_READ_OR_WRITE);
    public static final IAggregator<String, ?> HOST_NAMES_DISTINCT = Aggregators.filter((IAggregator)Aggregators.distinctAsString(JdkAttributes.IO_HOST, (String)","), (IItemFilter)JdkFilters.SOCKET_READ_OR_WRITE);
    public static final IAggregator<IQuantity, ?> LONGEST_GC_PAUSE = Aggregators.max((String)Messages.getString("AGGR_LONGEST_GC_PAUSE"), (String)Messages.getString("AGGR_LONGEST_GC_PAUSE_DESC"), (String)"jdk.GCPhasePause", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> TOTAL_GC_PAUSE = Aggregators.sum((String)Messages.getString("AGGR_TOTAL_GC_PAUSE"), (String)Messages.getString("AGGR_TOTAL_GC_PAUSE_DESC"), (String)"jdk.GCPhasePause", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> JFR_DATA_LOST_COUNT = Aggregators.count((String)Messages.getString("AGGR_JFR_DATA_LOST_COUNT"), (String)Messages.getString("AGGR_JFR_DATA_LOST_COUNT_DESC"), (IItemFilter)JdkFilters.JFR_DATA_LOST);
    public static final IAggregator<IQuantity, ?> FLR_DATA_LOST_SIZE = Aggregators.sum((String)Messages.getString("AGGR_FLR_DATA_LOST_SIZE"), (String)Messages.getString("AGGR_FLR_DATA_LOST_SIZE_DESC"), (String)"jdk.DataLoss", JfrAttributes.FLR_DATA_LOST);
    public static final IAggregator<IQuantity, ?> AVG_JVM_USER_CPU = Aggregators.avg((String)"jdk.CPULoad", JdkAttributes.JVM_USER);
    public static final IAggregator<IQuantity, ?> AVG_JVM_TOTAL_CPU = Aggregators.avg((String)"jdk.CPULoad", JdkAttributes.JVM_TOTAL);
    public static final IAggregator<IQuantity, ?> EXECUTION_SAMPLE_COUNT = Aggregators.count((String)Messages.getString("AGGR_EXECUTION_SAMPLE_COUNT"), (String)Messages.getString("AGGR_EXECUTION_SAMPLE_COUNT_DESC"), (IItemFilter)JdkFilters.EXECUTION_SAMPLE);
    public static final IAggregator<IQuantity, ?> METASPACE_OOM_COUNT = Aggregators.count((String)Messages.getString("AGGR_METASPACE_OOM_COUNT"), (String)Messages.getString("AGGR_METASPACE_OOM_COUNT_DESC"), (IItemFilter)JdkFilters.METASPACE_OOM);
    public static final IAggregator<IQuantity, ?> TOTAL_BLOCKED_TIME = Aggregators.sum((String)Messages.getString("AGGR_TOTAL_BLOCKED_TIME"), (String)Messages.getString("AGGR_TOTAL_BLOCKED_TIME_DESC"), (String)"jdk.JavaMonitorEnter", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> TOTAL_BLOCKED_COUNT = Aggregators.count((String)Messages.getString("AGGR_TOTAL_BLOCKED_COUNT"), (String)Messages.getString("AGGR_TOTAL_BLOCKED_COUNT_DESC"), (IItemFilter)JdkFilters.MONITOR_ENTER);
    public static final IAggregator<IQuantity, ?> MAX_BLOCKED_TIME = Aggregators.max((String)Messages.getString("AGGR_MAX_BLOCKED_TIME"), (String)Messages.getString("AGGR_MAX_BLOCKED_TIME_DESC"), (String)"jdk.JavaMonitorEnter", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> AVG_BLOCKED_TIME = Aggregators.avg((String)Messages.getString("AGGR_AVG_BLOCKED_TIME"), (String)Messages.getString("AGGR_AVG_BLOCKED_TIME_DESC"), (String)"jdk.JavaMonitorEnter", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> STDDEV_BLOCKED_TIME = Aggregators.stddevp((String)Messages.getString("AGGR_STDDEV_BLOCKED_TIME"), (String)Messages.getString("AGGR_STDDEV_BLOCKED_TIME_DESC"), JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> ALLOC_INSIDE_TLAB_AVG = Aggregators.avg((String)Messages.getString("AGGR_ALLOC_INSIDE_TLAB_AVG"), (String)Messages.getString("AGGR_ALLOC_INSIDE_TLAB_AVG_DESC"), (String)"jdk.ObjectAllocationInNewTLAB", JdkAttributes.ALLOCATION_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_OUTSIDE_TLAB_AVG = Aggregators.avg((String)Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_AVG"), (String)Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_AVG_DESC"), (String)"jdk.ObjectAllocationOutsideTLAB", JdkAttributes.ALLOCATION_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_INSIDE_TLAB_SUM = Aggregators.sum((String)Messages.getString("AGGR_ALLOC_INSIDE_TLAB_SUM"), (String)Messages.getString("AGGR_ALLOC_INSIDE_TLAB_SUM_DESC"), (String)"jdk.ObjectAllocationInNewTLAB", JdkAttributes.TLAB_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_OUTSIDE_TLAB_SUM = Aggregators.sum((String)Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_SUM"), (String)Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_SUM_DESC"), (String)"jdk.ObjectAllocationOutsideTLAB", JdkAttributes.ALLOCATION_SIZE);
    public static final IAggregator<IQuantity, ?> SWEEP_METHOD_SUM = Aggregators.sum((String)Messages.getString("AGGR_SWEEP_METHOD_SUM"), (String)Messages.getString("AGGR_SWEEP_METHOD_SUM_DESC"), (String)"jdk.SweepCodeCache", JdkAttributes.SWEEP_METHOD_SWEPT);
    public static final IAggregator<IQuantity, ?> SWEEP_FLUSHED_SUM = Aggregators.sum((String)Messages.getString("AGGR_SWEEP_FLUSHED_SUM"), (String)Messages.getString("AGGR_SWEEP_FLUSHED_SUM_DESC"), (String)"jdk.SweepCodeCache", JdkAttributes.SWEEP_METHOD_FLUSHED);
    public static final IAggregator<IQuantity, ?> SWEEP_ZOMBIFIED_SUM = Aggregators.sum((String)Messages.getString("AGGR_SWEEP_ZOMBIFIED_SUM"), (String)Messages.getString("AGGR_SWEEP_ZOMBIFIED_SUM_DESC"), (String)"jdk.SweepCodeCache", JdkAttributes.SWEEP_METHOD_ZOMBIFIED);
    public static final IAggregator<IQuantity, ?> SWEEP_RECLAIMED_SUM = Aggregators.sum((String)Messages.getString("AGGR_SWEEP_RECLAIMED_SUM"), (String)Messages.getString("AGGR_SWEEP_RECLAIMED_SUM_DESC"), (String)"jdk.SweepCodeCache", JdkAttributes.SWEEP_METHOD_RECLAIMED);
    public static final IAggregator<IQuantity, ?> LONGEST_EVENT = Aggregators.max(JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> ITEM_COUNT = Aggregators.count((String)Messages.getString("AGGR_ITEM_COUNT"), (String)Messages.getString("AGGR_ITEM_COUNT_DESC"));
    public static final IAggregator<IQuantity, ?> ALLOCATION_TOTAL = Aggregators.sum((String)Messages.getString("AGGR_ALLOCATION_TOTAL"), (String)Messages.getString("AGGR_ALLOCATION_TOTAL_DESC"), (LinearKindOfQuantity)UnitLookup.MEMORY, JdkAttributes.TOTAL_ALLOCATION_SIZE);
    public static final IAggregator<IQuantity, ?> TOTAL_IO_TIME = Aggregators.filter((IAggregator)Aggregators.sum((String)Messages.getString("AGGR_TOTAL_IO_TIME"), (String)Messages.getString("AGGR_TOTAL_IO_TIME_DESC"), JfrAttributes.DURATION), (IItemFilter)JdkFilters.FILE_OR_SOCKET_IO);
    public static final IAggregator<IQuantity, ?> MAX_IO_TIME = Aggregators.filter((IAggregator)Aggregators.max((String)Messages.getString("AGGR_MAX_IO_TIME"), (String)Messages.getString("AGGR_MAX_IO_TIME_DESC"), JfrAttributes.DURATION), (IItemFilter)JdkFilters.FILE_OR_SOCKET_IO);
    public static final IAggregator<IQuantity, ?> AVG_IO_TIME = Aggregators.filter((IAggregator)Aggregators.avg((String)Messages.getString("AGGR_AVG_IO_TIME"), (String)Messages.getString("AGGR_AVG_IO_TIME_DESC"), JfrAttributes.DURATION), (IItemFilter)JdkFilters.FILE_OR_SOCKET_IO);
    public static final IAggregator<IQuantity, ?> STDDEV_IO_TIME = Aggregators.filter((IAggregator)Aggregators.stddevp((String)Messages.getString("AGGR_STDDEV_IO_TIME"), (String)Messages.getString("AGGR_STDDEV_IO_TIME_DESC"), JfrAttributes.DURATION), (IItemFilter)JdkFilters.FILE_OR_SOCKET_IO);
    public static final IAggregator<IQuantity, ?> TOTAL_IO_COUNT = Aggregators.count((String)Messages.getString("AGGR_TOTAL_IO_COUNT"), (String)Messages.getString("AGGR_TOTAL_IO_COUNT_DESC"), (IItemFilter)JdkFilters.FILE_OR_SOCKET_IO);
    public static final IAggregator<IQuantity, ?> CLASS_LOADING_COUNT = Aggregators.count((String)Messages.getString("AGGR_CLASS_LOADING_COUNT"), (String)Messages.getString("AGGR_CLASS_LOADING_COUNT_DESC"), (IItemFilter)JdkFilters.CLASS_LOAD);
    public static final IAggregator<IQuantity, ?> CLASS_LOADING_TIME_SUM = Aggregators.sum((String)Messages.getString("AGGR_CLASS_LOADING_TIME_SUM"), (String)Messages.getString("AGGR_CLASS_LOADING_TIME_SUM_DESC"), (String)"jdk.ClassLoad", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> VM_OPERATION_COUNT = Aggregators.count((String)Messages.getString("AGGR_VM_OPERATION_COUNT"), (String)Messages.getString("AGGR_VM_OPERATION_COUNT_DESC"), (IItemFilter)JdkFilters.VM_OPERATIONS);
    public static final IAggregator<IQuantity, ?> VM_OPERATION_DURATION = Aggregators.sum((String)Messages.getString("AGGR_VM_OPERATION_DURATION"), (String)Messages.getString("AGGR_VM_OPERATION_DURATION_DESC"), JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> COMPILATIONS_COUNT = Aggregators.count((String)Messages.getString("AGGR_COMPILATIONS_COUNT"), (String)Messages.getString("AGGR_COMPILATIONS_COUNT_DESC"), (IItemFilter)JdkFilters.COMPILATION);
    public static final IAggregator<IQuantity, ?> LONGEST_COMPILATION = Aggregators.filter((IAggregator)Aggregators.max(JfrAttributes.DURATION), (IItemFilter)JdkFilters.COMPILATION);
    public static final IAggregator<String, ?> DUMP_REASON = Aggregators.distinctAsString((String)"jdk.DumpReason", JdkAttributes.DUMP_REASON);
    public static final IAggregator<IQuantity, ?> ADDRESSES_COUNT = Aggregators.countDistinct((String)Messages.getString("AGGR_ADDRESSES_COUNT"), (String)Messages.getString("AGGR_ADDRESSES_COUNT_DESC"), JdkAttributes.MONITOR_ADDRESS);
    public static final IAggregator<IQuantity, ?> OLD_OBJECT_ADDRESSES_COUNT = Aggregators.countDistinct((String)Messages.getString("AGGR_ADDRESSES_COUNT"), (String)Messages.getString("AGGR_ADDRESSES_COUNT_DESC"), JdkAttributes.OLD_OBJECT_ADDRESS);
    public static final IAggregator<?, ?> BASE_ADDRESS = Aggregators.min((String)"jdk.NativeLibrary", JdkAttributes.BASE_ADDRESS);
    public static final IAggregator<?, ?> TOP_ADDRESS = Aggregators.min((String)"jdk.NativeLibrary", JdkAttributes.TOP_ADDRESS);

    public static <V> IAggregator<V, ?> first(IAttribute<V> attribute) {
        return new Aggregators.AdvancedMinAggregator(MessageFormat.format(Messages.getString("AGGR_FIRST_ATTRIBUTE"), attribute.getName()), MessageFormat.format(Messages.getString("AGGR_FIRST_ATTRIBUTE_DESC"), attribute.getName()), attribute, JfrAttributes.START_TIME);
    }

    public static <V> IAggregator<V, ?> last(IAttribute<V> attribute) {
        return new Aggregators.AdvancedMaxAggregator(MessageFormat.format(Messages.getString("AGGR_LAST_ATTRIBUTE"), attribute.getName()), MessageFormat.format(Messages.getString("AGGR_LAST_ATTRIBUTE_DESC"), attribute.getName()), attribute, JfrAttributes.END_TIME);
    }
}

