/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.update;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Set;

public interface TriggerFilePolicy {
    public static final String TRIGGER_FILE_NAME = ".restartTriggerFile";
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.boot.run.update.TriggerFilePolicy");

    public static void updateTriggerFile(Set<? extends Module> modules) {
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> application.runWriteAction(() -> {
            for (Module module : modules) {
                if (module.isDisposed()) continue;
                VirtualFile[] roots = OrderEnumerator.orderEntries((Module)module).runtimeOnly().productionOnly().withoutLibraries().withoutSdk().getClassesRoots();
                if (roots.length == 0) {
                    LOG.debug("Failed to update trigger file: class roots not found");
                    continue;
                }
                try {
                    VirtualFile triggerFile = roots[0].findOrCreateChildData(TriggerFilePolicy.class, TRIGGER_FILE_NAME);
                    LocalFileSystem.getInstance().setTimeStamp(triggerFile, System.currentTimeMillis());
                }
                catch (IOException e) {
                    LOG.debug("Failed to update trigger file:", (Throwable)e);
                }
            }
        }));
    }
}

