/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveResourceImpl;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.xml.util.PsiElementPointer;
import icons.SpringApiIcons;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LiveBeanImpl
implements LiveBean {
    private static final String BEAN_RESOURCE_PREFIX = "/WEB-INF/classes/";
    private static final String CONFIGURATION_PROPERTIES_BEAN = "CONFIGURATION_PROPERTIES";
    private static final Pattern CLASS_NAME_START_PATTERN = Pattern.compile("\\.[A-Z]");
    @NotNull
    private final String myId;
    @Nullable
    private final String myScope;
    @Nullable
    private final String myType;
    @Nullable
    private final LiveResource myResource;
    private final Set<LiveBean> myDependencies;
    private final Set<LiveBean> myInjectedInto;
    private final boolean myInnerBean;
    private volatile String myName;
    private volatile String myClassName;
    private volatile WeakReference<PsiClass> myClassRef;
    private volatile WeakReference<SpringBeanPointer> myBeanPointerRef;

    static LiveBeanImpl createLiveBean(@NotNull String id, @Nullable String scope, @Nullable String type, @NotNull LiveResource resource) {
        if (id == null) {
            LiveBeanImpl.$$$reportNull$$$0(0);
        }
        if (resource == null) {
            LiveBeanImpl.$$$reportNull$$$0(1);
        }
        return new LiveBeanImpl(id, scope, type, resource, false);
    }

    static LiveBeanImpl createInnerBean(@NotNull String id) {
        if (id == null) {
            LiveBeanImpl.$$$reportNull$$$0(2);
        }
        return new LiveBeanImpl(id, null, null, null, true);
    }

    private LiveBeanImpl(@NotNull String id, @Nullable String scope, @Nullable String type, @Nullable LiveResource resource, boolean innerBean) {
        if (id == null) {
            LiveBeanImpl.$$$reportNull$$$0(3);
        }
        this.myDependencies = new HashSet<LiveBean>();
        this.myInjectedInto = new HashSet<LiveBean>();
        this.myId = id;
        this.myScope = scope;
        this.myType = type;
        this.myResource = resource;
        this.myInnerBean = innerBean;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            LiveBeanImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public String getScope() {
        return this.myScope;
    }

    @Override
    @Nullable
    public String getType() {
        return this.myType;
    }

    @Override
    @Nullable
    public LiveResource getResource() {
        return this.myResource;
    }

    @Override
    @NotNull
    public Set<LiveBean> getDependencies() {
        Set<LiveBean> set = Collections.unmodifiableSet(this.myDependencies);
        if (set == null) {
            LiveBeanImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<LiveBean> getInjectedInto() {
        Set<LiveBean> set = Collections.unmodifiableSet(this.myInjectedInto);
        if (set == null) {
            LiveBeanImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Override
    public boolean isInnerBean() {
        return this.myInnerBean;
    }

    @Override
    @NotNull
    public String getName() {
        String name = this.myName;
        if (name != null) {
            String string = name;
            if (string == null) {
                LiveBeanImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (this.myId.endsWith(CONFIGURATION_PROPERTIES_BEAN) || this.myId.contains("-")) {
            String string = this.myName = this.myId;
            if (string == null) {
                LiveBeanImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        name = this.dropPackagePrefix(this.myId);
        int index = (name = name.replaceAll("\\$", ".")).indexOf(64);
        if (index > 0) {
            name = name.substring(0, index);
        }
        String string = this.myName = StringUtil.decapitalize((String)name);
        if (string == null) {
            LiveBeanImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    private String dropPackagePrefix(String name) {
        Matcher matcher = CLASS_NAME_START_PATTERN.matcher(name);
        if (!matcher.find()) {
            return name;
        }
        int nameIndex = matcher.start();
        if (nameIndex < 0 || nameIndex >= name.length() - 1) {
            return name;
        }
        String className = name.substring(nameIndex + 1);
        int subClassNameCandidateIndex = StringUtil.indexOfAny((String)className, (String)".$@");
        String subClassNameCandidate = subClassNameCandidateIndex >= 0 ? className.substring(0, subClassNameCandidateIndex) : className;
        String beanClassName = this.getClassName();
        if (!beanClassName.contains("$" + subClassNameCandidate)) {
            return className;
        }
        if ((nameIndex = StringUtil.lastIndexOf((CharSequence)name, (char)'.', (int)0, (int)nameIndex)) >= 0 && nameIndex < name.length() - 1) {
            name = name.substring(nameIndex + 1);
        }
        return name;
    }

    @Override
    @NotNull
    public String getClassName() {
        String className = this.myClassName;
        if (className != null) {
            String string = className;
            if (string == null) {
                LiveBeanImpl.$$$reportNull$$$0(10);
            }
            return string;
        }
        className = this.myType;
        if (className != null && className.trim().length() > 0) {
            String resourcePath;
            if (className.startsWith("com.sun.proxy") && this.myResource != null && this.myResource.hasDescription() && LiveResourceImpl.isClassResource(resourcePath = this.myResource.getResourcePath())) {
                className = LiveBeanImpl.extractClassName(resourcePath);
            }
        } else {
            className = this.myId;
        }
        String string = this.myClassName = LiveBeanImpl.cleanClassName(className);
        if (string == null) {
            LiveBeanImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public PsiClass findBeanClass(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            LiveBeanImpl.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            LiveBeanImpl.$$$reportNull$$$0(13);
        }
        String className = this.getClassName();
        PsiClass psiClass = (PsiClass)SoftReference.dereference(this.myClassRef);
        if (psiClass != null && psiClass.isValid() && this.matches(psiClass)) {
            return psiClass;
        }
        psiClass = LiveResourceImpl.findClass(className, project, searchScope);
        this.myClassRef = new WeakReference<PsiClass>(psiClass);
        return psiClass;
    }

    @Override
    public boolean matches(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LiveBeanImpl.$$$reportNull$$$0(14);
        }
        String className = this.getClassName();
        className = StringUtil.replace((String)className, (String)"$", (String)".");
        return className.equals(psiClass.getQualifiedName());
    }

    @Override
    @NotNull
    public PsiElementPointer findBeanPointer(@Nullable PsiClass beanClass, @Nullable PsiElement resourceElement, @Nullable CommonSpringModel springModel) {
        SpringModel localModel;
        SpringBeanPointer pointer = (SpringBeanPointer)SoftReference.dereference(this.myBeanPointerRef);
        if (pointer != null && pointer.isValid() && this.getName().equals(pointer.getSpringBean().getBeanName())) {
            SpringBeanPointer springBeanPointer = pointer;
            if (springBeanPointer == null) {
                LiveBeanImpl.$$$reportNull$$$0(15);
            }
            return springBeanPointer;
        }
        pointer = null;
        final PsiFile beanFile = resourceElement == null ? null : resourceElement.getContainingFile();
        final PsiClass beanContainingClass = LiveBeanImpl.getBeanContainingClass(resourceElement);
        CommonProcessors.FindProcessor<SpringBeanPointer> findProcessor = new CommonProcessors.FindProcessor<SpringBeanPointer>(){

            protected boolean accept(SpringBeanPointer pointer) {
                if (beanFile == null) {
                    return true;
                }
                boolean accept = beanFile.getManager().areElementsEquivalent((PsiElement)beanFile, (PsiElement)pointer.getContainingFile());
                if (!accept) {
                    accept = InheritanceUtil.isInheritorOrSelf((PsiClass)beanContainingClass, (PsiClass)LiveBeanImpl.getBeanContainingClass(pointer.getPsiElement()), (boolean)true);
                }
                return accept;
            }
        };
        PsiFile localModelConfigFile = beanFile;
        if (!(localModelConfigFile != null || this.myResource != null && this.myResource.hasDescription() || beanClass == null)) {
            localModelConfigFile = beanClass.getContainingFile();
        }
        if (localModelConfigFile != null && (localModel = SpringManager.getInstance((Project)localModelConfigFile.getProject()).getSpringModelByFile(localModelConfigFile)) != null) {
            localModel.processByName(SpringModelSearchParameters.byName((String)this.getName()), (Processor)findProcessor);
            pointer = (SpringBeanPointer)findProcessor.getFoundValue();
        }
        if (pointer == null && springModel != null) {
            springModel.processByName(SpringModelSearchParameters.byName((String)this.getName()), (Processor)findProcessor);
            pointer = (SpringBeanPointer)findProcessor.getFoundValue();
        }
        this.myBeanPointerRef = new WeakReference<SpringBeanPointer>(pointer);
        if (pointer != null) {
            SpringBeanPointer springBeanPointer = pointer;
            if (springBeanPointer == null) {
                LiveBeanImpl.$$$reportNull$$$0(16);
            }
            return springBeanPointer;
        }
        if (this.myResource == null || !this.myResource.hasDescription()) {
            PsiElementPointer psiElementPointer = () -> beanClass;
            if (psiElementPointer == null) {
                LiveBeanImpl.$$$reportNull$$$0(17);
            }
            return psiElementPointer;
        }
        return LiveBeanImpl.getLiveResourcePointer((PsiElement)(beanContainingClass != null ? beanContainingClass : beanFile));
    }

    @Override
    @NotNull
    public Icon getIcon() {
        if (this.myResource == null || !this.myResource.hasDescription() || LiveResourceImpl.isClassNameResource(this.myResource.getDescription()) || !LiveResourceImpl.isXmlResource(this.myResource.getResourcePath())) {
            Icon icon = SpringApiIcons.SpringJavaBean;
            if (icon == null) {
                LiveBeanImpl.$$$reportNull$$$0(18);
            }
            return icon;
        }
        Icon icon = SpringApiIcons.SpringBean;
        if (icon == null) {
            LiveBeanImpl.$$$reportNull$$$0(19);
        }
        return icon;
    }

    public void addDependency(@NotNull LiveBeanImpl dependency) {
        if (dependency == null) {
            LiveBeanImpl.$$$reportNull$$$0(20);
        }
        this.myDependencies.add(dependency);
        dependency.myInjectedInto.add(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveBeanImpl) {
            LiveBeanImpl liveBean = (LiveBeanImpl)obj;
            return this.myId.equals(liveBean.myId) && Comparing.equal((Object)this.myResource, (Object)liveBean.myResource);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myId.hashCode();
        result = 31 * result + (this.myResource != null ? this.myResource.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myId;
    }

    private static String cleanClassName(String className) {
        int index = className.indexOf("$$");
        if (index > 0) {
            className = className.substring(0, index);
        }
        if ((index = className.indexOf(35)) > 0) {
            className = className.substring(0, index);
        }
        if ((index = className.indexOf(64)) > 0) {
            className = className.substring(0, index);
        }
        return className;
    }

    private static String extractClassName(@NotNull String resourcePath) {
        int index;
        if (resourcePath == null) {
            LiveBeanImpl.$$$reportNull$$$0(21);
        }
        if ((index = resourcePath.lastIndexOf(BEAN_RESOURCE_PREFIX)) >= 0) {
            resourcePath = resourcePath.substring(index + BEAN_RESOURCE_PREFIX.length());
        }
        resourcePath = StringUtil.trimEnd((String)resourcePath, (String)".class", (boolean)true);
        resourcePath = resourcePath.replaceAll("[\\\\/]", ".");
        return resourcePath;
    }

    @Nullable
    private static PsiClass getBeanContainingClass(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiClass) {
            return (PsiClass)element;
        }
        if (element instanceof PsiClassOwner) {
            PsiClass[] classes = ((PsiClassOwner)element).getClasses();
            return classes.length > 0 ? classes[0] : null;
        }
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    @NotNull
    private static LiveBean.LiveResourcePointer getLiveResourcePointer(final @Nullable PsiElement element) {
        return new LiveBean.LiveResourcePointer(){

            @Nullable
            public PsiElement getPsiElement() {
                return element;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveBeanImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveBeanImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedInto";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findBeanPointer";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLiveBean";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInnerBean";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findBeanClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractClassName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

