/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.beans.BeansEndpoint;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBeansModel;
import com.intellij.spring.boot.run.statistics.SpringBootRunUsageTriggerCollector;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.PsiElementPointer;
import icons.SpringBootRunIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LiveBeansNavigationHandler
implements GutterIconNavigationHandler<PsiElement> {
    private static final NotNullFunction<BeanNavigationItem, Collection<? extends GotoRelatedItem>> GOTO_RELATED_ITEMS_PROVIDER = item -> {
        SmartList gotoItems = new SmartList();
        String injectedIntoGroupId = SpringBootRunBundle.message("spring.boot.application.endpoints.bean.item.group.dependent", new Object[0]);
        for (LiveBean liveBean : item.bean.getInjectedInto()) {
            PsiElement psiElement = LiveBeansNavigationHandler.findBeanPointer(item, liveBean).getPsiElement();
            if (psiElement == null) continue;
            gotoItems.add(new GotoRelatedItem(psiElement, injectedIntoGroupId));
        }
        String dependenciesGroupId = SpringBootRunBundle.message("spring.boot.application.endpoints.bean.item.group.injected", new Object[0]);
        for (LiveBean liveBean : item.bean.getDependencies()) {
            PsiElement psiElement = LiveBeansNavigationHandler.findBeanPointer(item, liveBean).getPsiElement();
            if (psiElement == null) continue;
            gotoItems.add(new GotoRelatedItem(psiElement, dependenciesGroupId));
        }
        return gotoItems;
    };
    private final List<? extends BeanNavigationItem> myItems;

    private LiveBeansNavigationHandler(List<? extends BeanNavigationItem> items) {
        this.myItems = items;
    }

    private String getLiveMarkerInfoTooltipText() {
        if (this.myItems.size() == 1) {
            return this.myItems.get(0).getDisplayText();
        }
        return SpringBootRunBundle.message("spring.boot.application.endpoints.bean.popup.title", new Object[0]);
    }

    public void navigate(MouseEvent e, PsiElement element) {
        if (this.myItems.isEmpty()) {
            return;
        }
        if (this.myItems.size() == 1) {
            BeanNavigationItem item = this.myItems.get(0);
            if (item.bean.getInjectedInto().size() + item.bean.getDependencies().size() == 0) {
                JComponent label = HintUtil.createInformationLabel((String)SpringBootRunBundle.message("spring.boot.application.endpoints.bean.not.injected", new Object[0]));
                label.setBorder((Border)JBUI.Borders.empty((int)2, (int)7));
                JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getInformationColor()).createBalloon().show(new RelativePoint(e), Balloon.Position.above);
            } else {
                LiveBeansNavigationHandler.showPopup(e, (ListPopup)LiveBeansNavigationHandler.createDependenciesPopup(item.project, null, item), item.project);
            }
        } else {
            Project project = this.myItems.get((int)0).project;
            LiveBeansNavigationHandler.showPopup(e, LiveBeansNavigationHandler.createBeansPopup(project, this.myItems), project);
        }
    }

    private static void showPopup(MouseEvent e, ListPopup popup, Project project) {
        NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)project);
        popup.show(new RelativePoint(e));
    }

    @NotNull
    private static ListPopup createBeansPopup(Project project, List<? extends BeanNavigationItem> items) {
        return new ListPopupImpl(project, (ListPopupStep)new BeansPopupStep(items)){

            protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
                if (!(step instanceof ListPopupStep)) {
                    throw new IllegalArgumentException("Step: " + step.getClass().toString());
                }
                if (!(parentValue instanceof BeanNavigationItem)) {
                    throw new IllegalArgumentException("Parent value: " + step.getClass().toString());
                }
                return LiveBeansNavigationHandler.createDependenciesPopup(this.getProject(), parent, (BeanNavigationItem)parentValue);
            }
        };
    }

    @NotNull
    private static ListPopupImpl createDependenciesPopup(Project project, WizardPopup parent, BeanNavigationItem item) {
        Trinity<List<DependencyNavigationItem>, DependencyNavigationItem, DependencyNavigationItem> relatedItems = LiveBeansNavigationHandler.getRelatedBeansWithSeparators(item);
        final DependenciesPopupStep step = new DependenciesPopupStep(item, (List)relatedItems.first, (DependencyNavigationItem)relatedItems.second, (DependencyNavigationItem)relatedItems.third);
        return new ListPopupImpl(project, parent, (ListPopupStep)step, item){

            protected ListCellRenderer getListElementRenderer() {
                return new DependencyPopupRenderer((ListPopupStep<DependencyNavigationItem>)step);
            }
        };
    }

    private static Trinity<List<DependencyNavigationItem>, DependencyNavigationItem, DependencyNavigationItem> getRelatedBeansWithSeparators(BeanNavigationItem item) {
        List injected = ContainerUtil.map(item.bean.getInjectedInto(), dependency -> new DependencyNavigationItem(item, (LiveBean)dependency));
        List dependencies = ContainerUtil.map(item.bean.getDependencies(), dependency -> new DependencyNavigationItem(item, (LiveBean)dependency));
        return Trinity.create((Object)ContainerUtil.concat((List)injected, (List)dependencies), (Object)((DependencyNavigationItem)ContainerUtil.getFirstItem((List)injected)), (Object)((DependencyNavigationItem)ContainerUtil.getFirstItem((List)dependencies)));
    }

    private static void navigateToBean(BeanNavigationItem item, LiveBean liveBean) {
        PsiElementPointer pointer = LiveBeansNavigationHandler.findBeanPointer(item, liveBean);
        if (pointer.getPsiElement() instanceof NavigatablePsiElement) {
            ((NavigatablePsiElement)pointer.getPsiElement()).navigate(true);
            SpringBootRunUsageTriggerCollector.trigger(item.project, "LiveBeansNavigationHandler", "ICON_NAVIGATION");
        }
    }

    @NotNull
    private static PsiElementPointer findBeanPointer(BeanNavigationItem item, LiveBean liveBean) {
        if (!(item.info.getRunProfile() instanceof SpringBootApplicationRunConfigurationBase)) {
            PsiElementPointer psiElementPointer = () -> null;
            if (psiElementPointer == null) {
                LiveBeansNavigationHandler.$$$reportNull$$$0(0);
            }
            return psiElementPointer;
        }
        SpringBootApplicationRunConfigurationBase runConfiguration = (SpringBootApplicationRunConfigurationBase)item.info.getRunProfile();
        SpringModel model = SpringManager.getInstance((Project)item.project).getCombinedModel(runConfiguration.getModule());
        GlobalSearchScope searchScope = runConfiguration.getSearchScope();
        PsiElement resourceElement = liveBean.getResource() == null ? null : liveBean.getResource().findResourceElement(item.project, runConfiguration.getModule(), (PsiElement)runConfiguration.getMainClass(), searchScope);
        PsiClass beanClass = liveBean.findBeanClass(item.project, searchScope);
        PsiElementPointer psiElementPointer = liveBean.findBeanPointer(beanClass, resourceElement, (CommonSpringModel)model);
        if (psiElementPointer == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(1);
        }
        return psiElementPointer;
    }

    static boolean hasLiveBeansModels(@NotNull Project project) {
        if (project == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(2);
        }
        if (!SpringCommonUtils.hasSpringFacets((Project)project) && !SpringGeneralSettings.getInstance((Project)project).isAllowAutoConfigurationMode() || !SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            return false;
        }
        List infos = SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfos();
        return infos.stream().anyMatch(info -> info.getEndpointData(BeansEndpoint.getInstance()).getValue() != null);
    }

    static void addLiveBeansGutterIcon(@NotNull String beanName, @NotNull Predicate<? super LiveBean> beanMatcher, @NotNull Project project, @NotNull PsiElement nameIdentifier, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (beanName == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(3);
        }
        if (beanMatcher == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(4);
        }
        if (project == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(5);
        }
        if (nameIdentifier == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(6);
        }
        if (result == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(7);
        }
        SmartList items = new SmartList();
        List infos = SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfos();
        for (SpringBootApplicationInfo info : infos) {
            LiveBeansModel beansModel = (LiveBeansModel)info.getEndpointData(BeansEndpoint.getInstance()).getValue();
            if (beansModel == null) continue;
            beansModel.getBeansByName(beanName).stream().filter(beanMatcher).forEach(arg_0 -> LiveBeansNavigationHandler.lambda$addLiveBeansGutterIcon$5((List)items, project, info, arg_0));
        }
        if (items.isEmpty()) {
            return;
        }
        LiveBeansNavigationHandler navigationHandler = new LiveBeansNavigationHandler((List<? extends BeanNavigationItem>)items);
        SpringGutterIconBuilder.CustomNavigationHandlerBuilder builder = SpringGutterIconBuilder.CustomNavigationHandlerBuilder.createBuilder((Icon)SpringBootRunIcons.Gutter.LiveBean, (String)navigationHandler.getLiveMarkerInfoTooltipText(), (GutterIconNavigationHandler)navigationHandler, GOTO_RELATED_ITEMS_PROVIDER);
        builder.setTargets(NotNullLazyValue.createConstantValue((Object)items));
        result.add(builder.createSpringRelatedMergeableLineMarkerInfo(nameIdentifier));
    }

    private static /* synthetic */ void lambda$addLiveBeansGutterIcon$5(List items, Project project, SpringBootApplicationInfo info, LiveBean liveBean) {
        items.add(new BeanNavigationItem(project, info, liveBean));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansNavigationHandler";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanMatcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findBeanPointer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansNavigationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasLiveBeansModels";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLiveBeansGutterIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BeanNavigationItem {
        final Project project;
        final SpringBootApplicationInfo info;
        final LiveBean bean;

        BeanNavigationItem(Project project, SpringBootApplicationInfo info, LiveBean bean) {
            this.project = project;
            this.info = info;
            this.bean = bean;
        }

        @Nls
        String getDisplayText() {
            return this.bean.getName() + " [" + this.info.getRunProfile().getName() + "]";
        }
    }

    private static class DependencyNavigationItem {
        final LiveBean bean;
        final NotNullLazyValue<PsiElementPointer> pointer;

        DependencyNavigationItem(final BeanNavigationItem item, final LiveBean bean) {
            this.bean = bean;
            this.pointer = new NotNullLazyValue<PsiElementPointer>(){

                @NotNull
                protected PsiElementPointer compute() {
                    PsiElementPointer psiElementPointer = LiveBeansNavigationHandler.findBeanPointer(item, bean);
                    if (psiElementPointer == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiElementPointer;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansNavigationHandler$DependencyNavigationItem$1", "compute"));
                }
            };
        }
    }

    private static class BeanPointerCellRenderer
    extends DefaultPsiElementCellRenderer {
        LiveBean myBean;

        private BeanPointerCellRenderer() {
        }

        void setBean(LiveBean bean) {
            this.myBean = bean;
        }

        public String getElementText(PsiElement element) {
            if (this.myBean != null) {
                return this.myBean.getName();
            }
            return super.getElementText(element);
        }

        protected Icon getIcon(PsiElement element) {
            if (this.myBean != null) {
                return this.myBean.getIcon();
            }
            return super.getIcon(element);
        }
    }

    private static class DependencyPopupRenderer
    implements ListCellRenderer<DependencyNavigationItem> {
        private final ListPopupStep<DependencyNavigationItem> myPopupStep;
        private final JPanel myRendererPanel;
        private final SeparatorWithText mySeparatorComponent;
        private final SimpleListCellRenderer<DependencyNavigationItem> myNotFoundBeanRenderer;
        private final BeanPointerCellRenderer myElementCellRenderer;

        DependencyPopupRenderer(ListPopupStep<DependencyNavigationItem> popupStep) {
            this.myPopupStep = popupStep;
            this.myNotFoundBeanRenderer = SimpleListCellRenderer.create((label, value, index) -> {
                label.setIcon(value.bean.getIcon());
                label.setText(value.bean.getName());
                label.setEnabled(false);
            });
            this.myElementCellRenderer = new BeanPointerCellRenderer();
            OpaquePanel beanPanel = new OpaquePanel((LayoutManager)new BorderLayout(), UIUtil.getListBackground());
            beanPanel.add((Component)this.myNotFoundBeanRenderer, "North");
            beanPanel.add((Component)((Object)this.myElementCellRenderer), "Center");
            this.mySeparatorComponent = new SeparatorWithText();
            this.myRendererPanel = new OpaquePanel((LayoutManager)new BorderLayout(), UIUtil.getListBackground());
            this.myRendererPanel.add((Component)this.mySeparatorComponent, "North");
            this.myRendererPanel.add((Component)beanPanel, "Center");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends DependencyNavigationItem> list, DependencyNavigationItem value, int index, boolean isSelected, boolean cellHasFocus) {
            PsiElementPointer beanPointer;
            ListSeparator separator = this.myPopupStep.getSeparatorAbove((Object)value);
            this.mySeparatorComponent.setVisible(separator != null);
            if (separator != null) {
                this.mySeparatorComponent.setCaption(separator.getText());
            }
            boolean found = (beanPointer = (PsiElementPointer)value.pointer.getValue()).getPsiElement() != null;
            this.myElementCellRenderer.setVisible(found);
            this.myNotFoundBeanRenderer.setVisible(!found);
            if (found) {
                this.myElementCellRenderer.setBean(value.bean);
                this.myElementCellRenderer.getListCellRendererComponent(list, beanPointer.getPsiElement(), index, isSelected, cellHasFocus);
            } else {
                this.myNotFoundBeanRenderer.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
            }
            return this.myRendererPanel;
        }
    }

    private static class DependenciesPopupStep
    extends BaseListPopupStep<DependencyNavigationItem>
    implements ListPopupStepEx<DependencyNavigationItem> {
        private final BeanNavigationItem myItem;
        private final DependencyNavigationItem myInjectedSeparator;
        private final DependencyNavigationItem myDependencySeparator;

        DependenciesPopupStep(BeanNavigationItem item, List<DependencyNavigationItem> items, DependencyNavigationItem injectedSeparator, DependencyNavigationItem dependencySeparator) {
            super(item.getDisplayText(), items);
            this.myItem = item;
            this.myInjectedSeparator = injectedSeparator;
            this.myDependencySeparator = dependencySeparator;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public PopupStep onChosen(DependencyNavigationItem item, boolean finalChoice) {
            LiveBeansNavigationHandler.navigateToBean(this.myItem, item.bean);
            return PopupStep.FINAL_CHOICE;
        }

        public PopupStep onChosen(DependencyNavigationItem item, boolean finalChoice, int eventModifiers) {
            return this.onChosen(item, finalChoice);
        }

        @Nullable
        public String getTooltipTextFor(DependencyNavigationItem item) {
            return null;
        }

        public void setEmptyText(@NotNull StatusText emptyText) {
            if (emptyText == null) {
                DependenciesPopupStep.$$$reportNull$$$0(0);
            }
            emptyText.setText(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.not.injected", new Object[0]));
        }

        @Nullable
        public ListSeparator getSeparatorAbove(DependencyNavigationItem value) {
            if (this.myInjectedSeparator != null && value.bean.equals(this.myInjectedSeparator.bean)) {
                return new ListSeparator(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.injected.into", new Object[0]));
            }
            if (this.myDependencySeparator != null && value.bean.equals(this.myDependencySeparator.bean)) {
                return new ListSeparator(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.depends.on", new Object[0]));
            }
            return super.getSeparatorAbove((Object)value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansNavigationHandler$DependenciesPopupStep", "setEmptyText"));
        }
    }

    private static class BeansPopupStep
    extends BaseListPopupStep<BeanNavigationItem> {
        BeansPopupStep(List<? extends BeanNavigationItem> items) {
            super(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.popup.title", new Object[0]), items);
        }

        @NotNull
        public String getTextFor(BeanNavigationItem item) {
            String string = item.getDisplayText();
            if (string == null) {
                BeansPopupStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean hasSubstep(BeanNavigationItem item) {
            return true;
        }

        public Icon getIconFor(BeanNavigationItem item) {
            return item.bean.getIcon();
        }

        public PopupStep onChosen(BeanNavigationItem item, boolean finalChoice) {
            Trinity<List<DependencyNavigationItem>, DependencyNavigationItem, DependencyNavigationItem> relatedItems = LiveBeansNavigationHandler.getRelatedBeansWithSeparators(item);
            return new DependenciesPopupStep(item, (List)relatedItems.first, (DependencyNavigationItem)relatedItems.second, (DependencyNavigationItem)relatedItems.third);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansNavigationHandler$BeansPopupStep", "getTextFor"));
        }
    }
}

