/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.diagram;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.beans.diagram.LiveBeanDiagramCategoryManager;
import com.intellij.spring.boot.run.lifecycle.beans.diagram.LiveBeanWrapper;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.spring.perspectives.diagrams.SpringDependencyType;
import com.intellij.spring.perspectives.diagrams.SpringDiagramEdge;
import com.intellij.spring.perspectives.diagrams.SpringDiagramNode;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseLiveBeanDiagramDataModel
extends DiagramDataModel<SpringElementWrapper> {
    private final Map<LiveBean, DiagramNode<SpringElementWrapper>> myNodes = new LinkedHashMap<LiveBean, DiagramNode<SpringElementWrapper>>();
    private final Set<DiagramEdge<SpringElementWrapper>> myEdges = new LinkedHashSet<DiagramEdge<SpringElementWrapper>>();

    protected BaseLiveBeanDiagramDataModel(Project project, DiagramProvider<SpringElementWrapper> diagramProvider) {
        super(project, diagramProvider);
    }

    @NotNull
    public Collection<DiagramNode<SpringElementWrapper>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper>> collection = this.myNodes.values();
        if (collection == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<SpringElementWrapper>> getEdges() {
        Set<DiagramEdge<SpringElementWrapper>> set = this.myEdges;
        if (set == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public String getNodeName(DiagramNode<SpringElementWrapper> n) {
        String string = ((SpringElementWrapper)n.getIdentifyingElement()).getName();
        if (string == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private DiagramNode<SpringElementWrapper> getOrCreateElement(LiveBean liveBean, SpringBootApplicationRunConfigurationBase runConfiguration) {
        SpringDiagramNode node = this.myNodes.get(liveBean);
        if (node == null) {
            node = new SpringDiagramNode((SpringElementWrapper)new LiveBeanWrapper(liveBean, runConfiguration), this.getProvider());
            this.myNodes.put(liveBean, (DiagramNode<SpringElementWrapper>)node);
        }
        SpringDiagramNode springDiagramNode = node;
        if (springDiagramNode == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(3);
        }
        return springDiagramNode;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> addElement(SpringElementWrapper wrapper) {
        if (!(wrapper.getWrapped() instanceof LiveBean)) {
            return null;
        }
        LiveBean liveBean = (LiveBean)wrapper.getWrapped();
        SpringDiagramNode node = this.myNodes.get(liveBean);
        if (node == null) {
            node = new SpringDiagramNode(wrapper, this.getProvider());
            this.myNodes.put(liveBean, (DiagramNode<SpringElementWrapper>)node);
        }
        return node;
    }

    public void refreshDataModel() {
        if (DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        this.clearAll();
        this.updateDataModel();
    }

    private void updateDataModel() {
        SpringBootApplicationRunConfigurationBase runConfiguration = this.getRunConfiguration();
        Module module = runConfiguration.getModule();
        PsiClass mainClass = runConfiguration.getMainClass();
        GlobalSearchScope searchScope = runConfiguration.getSearchScope();
        boolean showLibraryBeans = this.showLibraryBeans();
        HashMap<LiveResource, Boolean> resources = new HashMap<LiveResource, Boolean>();
        HashMap<PsiClass, Boolean> autoConfigurations = new HashMap<PsiClass, Boolean>();
        for (LiveBean liveBean : this.getBeans()) {
            if (!showLibraryBeans && this.isInLibrary(liveBean, resources, autoConfigurations, module, mainClass, searchScope)) continue;
            DiagramNode<SpringElementWrapper> node = this.getOrCreateElement(liveBean, runConfiguration);
            for (LiveBean dependency : liveBean.getDependencies()) {
                if (!showLibraryBeans && this.isInLibrary(dependency, resources, autoConfigurations, module, mainClass, searchScope)) continue;
                DiagramNode<SpringElementWrapper> targetNode = this.getOrCreateElement(dependency, runConfiguration);
                this.addEdge(node, targetNode);
            }
            for (LiveBean injectedInto : liveBean.getInjectedInto()) {
                if (!showLibraryBeans && this.isInLibrary(injectedInto, resources, autoConfigurations, module, mainClass, searchScope)) continue;
                DiagramNode<SpringElementWrapper> sourceNode = this.getOrCreateElement(injectedInto, runConfiguration);
                this.addEdge(sourceNode, node);
            }
        }
    }

    private void addEdge(@NotNull DiagramNode<SpringElementWrapper> source, @NotNull DiagramNode<SpringElementWrapper> target) {
        if (source == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(4);
        }
        if (target == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(5);
        }
        this.myEdges.add((DiagramEdge<SpringElementWrapper>)new SpringDiagramEdge(source, target, SpringDependencyType.UNKNOWN));
    }

    private boolean isInLibrary(LiveBean liveBean, Map<LiveResource, Boolean> resources, Map<PsiClass, Boolean> autoConfigurations, Module module, PsiClass mainClass, GlobalSearchScope searchScope) {
        LiveResource liveResource = liveBean.getResource();
        if (liveResource == null) {
            return false;
        }
        if (liveResource.hasDescription()) {
            Boolean isInLibrary = resources.get(liveResource);
            if (isInLibrary == null) {
                isInLibrary = this.isInLibrary(liveResource.findResourceElement(this.getProject(), module, (PsiElement)mainClass, searchScope));
                resources.put(liveResource, isInLibrary);
            }
            return isInLibrary;
        }
        PsiClass beanClass = liveBean.findBeanClass(this.getProject(), searchScope);
        if (beanClass == null) {
            return false;
        }
        Boolean isInLibrary = autoConfigurations.get(beanClass);
        if (isInLibrary == null) {
            isInLibrary = this.isInLibrary((PsiElement)beanClass);
            autoConfigurations.put(beanClass, isInLibrary);
        }
        return isInLibrary;
    }

    private boolean isInLibrary(PsiElement psiElement) {
        ProjectFileIndex fileIndex;
        VirtualFile virtualFile;
        return psiElement != null && psiElement.isValid() && psiElement.getContainingFile() != null && (virtualFile = psiElement.getContainingFile().getVirtualFile()) != null && (fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex()).isInLibrary(virtualFile);
    }

    private boolean showLibraryBeans() {
        return this.getBuilder().getPresentation().isCategoryEnabled(LiveBeanDiagramCategoryManager.SHOW_LIBRARY_BEANS);
    }

    public long getModificationCount() {
        return super.getModificationCount() + PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getModificationCount();
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        BaseLiveBeanDiagramDataModel baseLiveBeanDiagramDataModel = this;
        if (baseLiveBeanDiagramDataModel == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(6);
        }
        return baseLiveBeanDiagramDataModel;
    }

    public void dispose() {
    }

    protected abstract List<LiveBean> getBeans();

    protected abstract SpringBootApplicationRunConfigurationBase getRunConfiguration();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/diagram/BaseLiveBeanDiagramDataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/diagram/BaseLiveBeanDiagramDataModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

