/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.module.Module;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.run.lifecycle.Endpoint;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringBootModuleDescriptor {
    private static final String JMX_NAME_PROPERTY_KEY = "spring.application.admin.jmx-name";
    private static final String SPRING_BOOT_APPLICATION_OBJECT_NAME = "org.springframework.boot:type=Admin,name=SpringApplication";
    static final SpringBootModuleDescriptor DEFAULT_DESCRIPTOR = SpringBootModuleDescriptor.getDescriptor(null, true, "org.springframework.boot:type=Admin,name=SpringApplication");
    private final SpringBootLibraryUtil.SpringBootVersion myVersion;
    private final boolean myActuatorsEnabled;
    private final String myApplicationAdminJmxName;
    private final Map<String, Boolean> myEndpointsAvailable;

    @NotNull
    static SpringBootModuleDescriptor getDescriptor(@Nullable Module module, String activeProfiles) {
        return SpringBootModuleDescriptor.getDescriptor(module != null ? SpringBootLibraryUtil.getSpringBootVersion((Module)module) : null, SpringBootLibraryUtil.hasActuators((Module)module), SpringBootModuleDescriptor.getApplicationAdminJmxName(module, activeProfiles));
    }

    @NotNull
    static SpringBootModuleDescriptor getDescriptor(@Nullable SpringBootLibraryUtil.SpringBootVersion version, boolean actuatorsEnabled, @NotNull String applicationAdminJmxName) {
        if (applicationAdminJmxName == null) {
            SpringBootModuleDescriptor.$$$reportNull$$$0(0);
        }
        return new SpringBootModuleDescriptor(version, actuatorsEnabled, applicationAdminJmxName);
    }

    @NotNull
    private static String getApplicationAdminJmxName(@Nullable Module module, String activeProfiles) {
        if (module == null) {
            return SPRING_BOOT_APPLICATION_OBJECT_NAME;
        }
        Set<String> profilesSet = SpringBootModuleDescriptor.getProfilesSet(activeProfiles);
        SpringBootConfigValueSearcher searcher = SpringBootConfigValueSearcher.productionForProfiles((Module)module, (String)JMX_NAME_PROPERTY_KEY, profilesSet);
        String string = (String)ObjectUtils.chooseNotNull((Object)searcher.findValueText(), (Object)SPRING_BOOT_APPLICATION_OBJECT_NAME);
        if (string == null) {
            SpringBootModuleDescriptor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static Set<String> getProfilesSet(String activeProfiles) {
        String[] profiles = activeProfiles != null ? activeProfiles.split(",") : null;
        HashSet<String> profilesSet = new HashSet<String>();
        if (profiles != null) {
            for (String profile : profiles) {
                if ((profile = profile.trim()).isEmpty()) continue;
                profilesSet.add(profile);
            }
        }
        return profilesSet.isEmpty() ? null : profilesSet;
    }

    private SpringBootModuleDescriptor(@Nullable SpringBootLibraryUtil.SpringBootVersion version, boolean actuatorsEnabled, @NotNull String applicationAdminJmxName) {
        if (applicationAdminJmxName == null) {
            SpringBootModuleDescriptor.$$$reportNull$$$0(2);
        }
        this.myEndpointsAvailable = new HashMap<String, Boolean>();
        this.myVersion = version;
        this.myActuatorsEnabled = actuatorsEnabled;
        this.myApplicationAdminJmxName = applicationAdminJmxName;
    }

    boolean isSB2() {
        return this.myVersion != null && this.myVersion.isAtLeast(SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0);
    }

    @Nullable
    SpringBootLibraryUtil.SpringBootVersion getVersion() {
        return this.myVersion;
    }

    boolean isActuatorsEnabled() {
        return this.myActuatorsEnabled;
    }

    boolean isEndpointAvailable(@NotNull Endpoint endpoint) {
        if (endpoint == null) {
            SpringBootModuleDescriptor.$$$reportNull$$$0(3);
        }
        return this.myEndpointsAvailable.getOrDefault(endpoint.getId(), Boolean.TRUE);
    }

    void setEndpointAvailable(@NotNull Endpoint endpoint, boolean available) {
        if (endpoint == null) {
            SpringBootModuleDescriptor.$$$reportNull$$$0(4);
        }
        this.myEndpointsAvailable.put(endpoint.getId(), available);
    }

    @NotNull
    String getApplicationAdminJmxName() {
        String string = this.myApplicationAdminJmxName;
        if (string == null) {
            SpringBootModuleDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringBootModuleDescriptor)) {
            return false;
        }
        SpringBootModuleDescriptor descriptor = (SpringBootModuleDescriptor)o;
        return this.myVersion == descriptor.myVersion && this.myActuatorsEnabled == descriptor.myActuatorsEnabled && this.myApplicationAdminJmxName.equals(descriptor.myApplicationAdminJmxName) && this.myEndpointsAvailable.equals(descriptor.myEndpointsAvailable);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myActuatorsEnabled ? 1 : 0);
        result = 31 * result + this.myApplicationAdminJmxName.hashCode();
        result = 31 * result + this.myEndpointsAvailable.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationAdminJmxName";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/SpringBootModuleDescriptor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootModuleDescriptor";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationAdminJmxName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEndpointAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setEndpointAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

