/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.ApplicationUrlLiveProperty;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.Endpoint;
import com.intellij.spring.boot.run.lifecycle.EndpointLiveProperty;
import com.intellij.spring.boot.run.lifecycle.JmxServiceUrlLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.MappedPortProperty;
import com.intellij.spring.boot.run.lifecycle.ReadyStateLiveProperty;
import com.intellij.spring.boot.run.lifecycle.ServerConfigurationLiveProperty;
import com.intellij.spring.boot.run.lifecycle.ServerPortLiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootLiveBeansConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootModuleDescriptor;
import com.intellij.spring.boot.run.lifecycle.beans.BeansEndpoint;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveBeansSnapshotParser;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringBootApplicationInfoImpl
implements SpringBootApplicationInfo {
    private static final String NOTIFICATION_DISPLAY_ID = "Spring Boot Application Endpoints";
    private final RunConfiguration myConfiguration;
    private final LiveProperty<SpringBootModuleDescriptor> myModuleDescriptor;
    private final LiveProperty<Boolean> myReadyState;
    private final LiveProperty<Integer> myServerPort;
    private final LiveProperty<SpringBootApplicationServerConfiguration> myServerConfiguration;
    private final Map<String, LiveProperty<?>> myEndpoints;
    private final LiveProperty<String> myApplicationUrl;
    private volatile boolean myDisposed;

    static SpringBootApplicationInfo createInfo(@NotNull Project project, @NotNull Module module, @NotNull ExecutionEnvironment environment, @NotNull RunConfiguration configuration, @Nullable String activeProfiles, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(4);
        }
        SpringBootApplicationInfoImpl info = new SpringBootApplicationInfoImpl(project, module, environment, configuration, activeProfiles, processHandler);
        for (Endpoint endpoint : (Endpoint[])Endpoint.EP_NAME.getExtensions()) {
            endpoint.infoCreated(project, processHandler, (SpringBootApplicationInfo)info);
        }
        info.myModuleDescriptor.compute();
        return info;
    }

    private SpringBootApplicationInfoImpl(final @NotNull Project project, final @NotNull Module module, @NotNull ExecutionEnvironment environment, @NotNull RunConfiguration configuration, final @Nullable String activeProfiles, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(5);
        }
        if (module == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(6);
        }
        if (environment == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(8);
        }
        if (processHandler == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(9);
        }
        this.myEndpoints = new HashMap();
        this.myConfiguration = configuration;
        LifecycleErrorHandler errorHandler = message -> {
            if (this.myDisposed) {
                return;
            }
            String toolWindowId = RunContentManager.getInstance((Project)project).getToolWindowIdByEnvironment(environment);
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
            if (toolWindowManager.canShowNotification(toolWindowId)) {
                new NotificationGroup(NOTIFICATION_DISPLAY_ID, NotificationDisplayType.NONE, true, toolWindowId).createNotification(configuration.getName(), message, NotificationType.ERROR, null).notify(project);
            }
        };
        this.myModuleDescriptor = new AsyncLiveProperty<SpringBootModuleDescriptor>(errorHandler, (Disposable)this, SpringBootModuleDescriptor.DEFAULT_DESCRIPTOR){

            @Override
            protected SpringBootModuleDescriptor doCompute() {
                return (SpringBootModuleDescriptor)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    SpringBootModuleDescriptor moduleDescriptor = SpringBootModuleDescriptor.getDescriptor(module, activeProfiles);
                    for (Endpoint endpoint : (Endpoint[])Endpoint.EP_NAME.getExtensions()) {
                        moduleDescriptor.setEndpointAvailable(endpoint, endpoint.isAvailable(module));
                    }
                    return moduleDescriptor;
                });
            }
        };
        final JmxServiceUrlLiveProperty serviceUrl = new JmxServiceUrlLiveProperty(errorHandler, (Disposable)this, processHandler);
        this.myReadyState = new ReadyStateLiveProperty(this.myModuleDescriptor, serviceUrl, (Disposable)this);
        this.myServerPort = MappedPortProperty.withMappedPorts(new ServerPortLiveProperty(this.myModuleDescriptor, serviceUrl, errorHandler, (Disposable)this), processHandler);
        this.myServerConfiguration = new ServerConfigurationLiveProperty(this.myModuleDescriptor, serviceUrl, errorHandler, (Disposable)this);
        Endpoint<LiveBeansModel> beansEndpoint = BeansEndpoint.getInstance();
        final AsyncLiveProperty<LiveBeansModel> liveBeansModel = new AsyncLiveProperty<LiveBeansModel>(errorHandler, (Disposable)this){

            @Override
            protected LiveBeansModel doCompute() throws LifecycleException {
                SpringBootLiveBeansConnector connector = new SpringBootLiveBeansConnector((String)serviceUrl.getValue());
                try {
                    String snapshot = connector.getSnapshot();
                    LiveBeansSnapshotParser parser = new LiveBeansSnapshotParser();
                    LiveBeansModel liveBeansModel = parser.parse(snapshot);
                    return liveBeansModel;
                }
                catch (Exception e) {
                    throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.application.beans.snapshot", e.getLocalizedMessage()), e);
                }
                finally {
                    try {
                        connector.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        };
        this.myEndpoints.put(beansEndpoint.getId(), liveBeansModel);
        for (Endpoint endpoint : (Endpoint[])Endpoint.EP_NAME.getExtensions()) {
            if (endpoint == beansEndpoint) continue;
            EndpointLiveProperty endpointData = new EndpointLiveProperty(endpoint, this.myModuleDescriptor, serviceUrl, errorHandler, (Disposable)this, (LiveProperty<? extends LiveBeansModel>)liveBeansModel);
            this.myEndpoints.put(endpoint.getId(), endpointData);
        }
        this.myApplicationUrl = new ApplicationUrlLiveProperty(errorHandler, (Disposable)this).withServerPort(this.myServerPort).withServerConfiguration(this.myServerConfiguration);
        this.myModuleDescriptor.addPropertyListener(new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
            }

            public void computationFinished() {
                SpringBootApplicationInfoImpl.this.myReadyState.compute();
            }
        });
        this.myReadyState.addPropertyListener(new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
                ((RunDashboardListener)project.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).configurationChanged(SpringBootApplicationInfoImpl.this.myConfiguration, false);
                SpringBootApplicationInfoImpl.this.myServerPort.compute();
                liveBeansModel.compute();
            }

            public void computationFailed(@NotNull Exception e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                ((RunDashboardListener)project.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).configurationChanged(SpringBootApplicationInfoImpl.this.myConfiguration, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl$4", "computationFailed"));
            }
        });
        liveBeansModel.addPropertyListener(new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
            }

            public void computationFinished() {
                for (LiveProperty<?> endpointData : SpringBootApplicationInfoImpl.this.myEndpoints.values()) {
                    if (endpointData == liveBeansModel) continue;
                    endpointData.compute();
                }
            }
        });
        this.myServerPort.addPropertyListener(() -> {
            ((RunDashboardListener)project.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).configurationChanged(this.myConfiguration, false);
            this.myServerConfiguration.compute();
        });
    }

    @NotNull
    public RunProfile getRunProfile() {
        RunConfiguration runConfiguration = this.myConfiguration;
        if (runConfiguration == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(10);
        }
        return runConfiguration;
    }

    @NotNull
    public LiveProperty<Boolean> getReadyState() {
        LiveProperty<Boolean> liveProperty = this.myReadyState;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(11);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<Integer> getServerPort() {
        LiveProperty<Integer> liveProperty = this.myServerPort;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(12);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<SpringBootApplicationServerConfiguration> getServerConfiguration() {
        LiveProperty<SpringBootApplicationServerConfiguration> liveProperty = this.myServerConfiguration;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(13);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<String> getApplicationUrl() {
        LiveProperty<String> liveProperty = this.myApplicationUrl;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(14);
        }
        return liveProperty;
    }

    public <T> LiveProperty<T> getEndpointData(Endpoint<T> endpoint) {
        return this.myEndpoints.get(endpoint.getId());
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunProfile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadyState";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerPort";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerConfiguration";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

