/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.util.Pair;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.lifecycle.RelaxedNamesByParts;
import com.intellij.spring.boot.run.lifecycle.SpringBootJmxConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootModuleDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import org.jetbrains.annotations.NotNull;

class SpringBootApplicationConnector
extends SpringBootJmxConnector {
    static final ApplicationProperty ENDPOINTS_JMX_DOMAIN_PROPERTY = new ApplicationProperty(Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0, (Object)"endpoints.jmx.domain"), Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0, (Object)"management.endpoints.jmx.domain"));
    static final String SPRING_JMX_DEFAULT_DOMAIN_PROPERTY = "spring.jmx.default-domain";
    static final String ENDPOINTS_JMX_ENABLED_PROPERTY_1X = "endpoints.jmx.enabled";
    static final String ENDPOINTS_JMX_EXPOSURE_INCLUDE_PROPERTY_2X = "management.endpoints.jmx.exposure.include";
    static final String ENDPOINTS_JMX_EXPOSURE_EXCLUDE_PROPERTY_2X = "management.endpoints.jmx.exposure.exclude";
    static final ApplicationProperty ENDPOINTS_ENABLED_PROPERTY = new ApplicationProperty(Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0, (Object)"endpoints.enabled"), Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0, (Object)"management.endpoints.enabled-by-default"));
    static final ApplicationProperty ENDPOINTS_ID_ENABLED_PROPERTY = new ApplicationProperty(Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0, (Object)"endpoints.%s.enabled"), Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0, (Object)"management.endpoint.%s.enabled"));
    static final String SERVER_SSL_ENABLED_PROPERTY = "server.ssl.enabled";
    static final String SERVER_SSL_KEY_STORE_PROPERTY = "server.ssl.key-store";
    static final ApplicationProperty SERVER_CONTEXT_PATH_PROPERTY = new ApplicationProperty(Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0, (Object)"server.context-path"), Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0, (Object)"server.servlet.context-path"));
    static final ApplicationProperty SERVER_SERVLET_PATH_PROPERTY = new ApplicationProperty(Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0, (Object)"server.servlet-path"), Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0, (Object)"server.servlet.path"), Pair.create((Object)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_1_0, (Object)"spring.mvc.servlet.path"));
    static final String SERVER_ADDRESS_PROPERTY = "server.address";
    private static final String READY_ATTR = "Ready";
    private static final String GET_PROPERTY_OPERATION = "getProperty";
    private static final String LOCAL_SERVER_PORT_PROPERTY = "local.server.port";
    private final SpringBootModuleDescriptor myModuleDescriptor;

    SpringBootApplicationConnector(String serviceUrl, SpringBootModuleDescriptor moduleDescriptor) {
        super(serviceUrl, moduleDescriptor.getApplicationAdminJmxName());
        this.myModuleDescriptor = moduleDescriptor;
    }

    Object getProperty(@NotNull ApplicationProperty property) throws Exception {
        if (property == null) {
            SpringBootApplicationConnector.$$$reportNull$$$0(0);
        }
        return this.getProperty(property.getKey(this.myModuleDescriptor.getVersion()));
    }

    Object getProperty(@NotNull String propertyName) throws Exception {
        Object value;
        if (propertyName == null) {
            SpringBootApplicationConnector.$$$reportNull$$$0(1);
        }
        if ((value = this.doGetProperty(propertyName)) != null || this.myModuleDescriptor.isSB2()) {
            return value;
        }
        Set<String> names = RelaxedNamesByParts.generateRelaxedNamesByParts(propertyName);
        names.remove(propertyName);
        for (String name : names) {
            value = this.doGetProperty(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    boolean getBooleanProperty(@NotNull String propertyName, boolean defaultValue) throws Exception {
        Object value;
        if (propertyName == null) {
            SpringBootApplicationConnector.$$$reportNull$$$0(2);
        }
        if ((value = this.getProperty(propertyName)) instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    int getServerPort() throws Exception {
        Object value = this.getProperty(LOCAL_SERVER_PORT_PROPERTY);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    boolean isReady() throws Exception {
        try {
            Object value = this.getJmxConnection().getAttribute(this.getObjectName(), READY_ATTR);
            return value instanceof Boolean ? (Boolean)value : false;
        }
        catch (InstanceNotFoundException ex) {
            return false;
        }
    }

    private Object doGetProperty(String propertyName) throws Exception {
        return this.getJmxConnection().invoke(this.getObjectName(), GET_PROPERTY_OPERATION, new String[]{propertyName}, new String[]{String.class.getName()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationConnector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = GET_PROPERTY_OPERATION;
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBooleanProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ApplicationProperty {
        private final List<Pair<SpringBootLibraryUtil.SpringBootVersion, String>> myKeys;

        ApplicationProperty(Pair<SpringBootLibraryUtil.SpringBootVersion, String> ... keys) {
            assert (keys.length > 0);
            this.myKeys = Arrays.asList(keys);
            this.myKeys.sort(Comparator.comparing(key -> (SpringBootLibraryUtil.SpringBootVersion)key.first));
            Collections.reverse(this.myKeys);
        }

        @NotNull
        String getKey(SpringBootLibraryUtil.SpringBootVersion version) {
            if (version != null) {
                for (Pair<SpringBootLibraryUtil.SpringBootVersion, String> pair : this.myKeys) {
                    if (!version.isAtLeast((SpringBootLibraryUtil.SpringBootVersion)pair.first)) continue;
                    String string = (String)pair.second;
                    if (string == null) {
                        ApplicationProperty.$$$reportNull$$$0(0);
                    }
                    return string;
                }
            }
            String string = (String)this.myKeys.get((int)0).second;
            if (string == null) {
                ApplicationProperty.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationConnector$ApplicationProperty", "getKey"));
        }
    }
}

