/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationDescriptor;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdateContext;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdateContextImpl;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class SpringBootApplicationCompileManager
implements Disposable {
    private final FrameStateListener myCompileRunnable;

    SpringBootApplicationCompileManager(final @NotNull Project project) {
        if (project == null) {
            SpringBootApplicationCompileManager.$$$reportNull$$$0(0);
        }
        this.myCompileRunnable = new FrameStateListener(){

            public void onFrameDeactivated() {
                if (!(project.isDisposed() || !project.isInitialized() || CompilerManager.getInstance((Project)project).isCompilationActive() || LaterInvocator.isInModalContext() || ProgressManager.getInstance().hasModalProgressIndicator())) {
                    ExecutorRegistry executorRegistry = ExecutorRegistry.getInstance();
                    HashMap<SpringBootApplicationUpdatePolicy, List> appsToUpdate = new HashMap<SpringBootApplicationUpdatePolicy, List>();
                    SpringBootApplicationLifecycleManager.getInstance((Project)project).getRunningSpringBootApplications().forEach(descriptor -> {
                        ProcessHandler handler = descriptor.getProcessHandler();
                        if (handler.isProcessTerminated() || handler.isProcessTerminating() || !handler.isStartNotified()) {
                            return;
                        }
                        Executor executor = executorRegistry.getExecutorById(descriptor.getExecutorId());
                        if (executor == null) {
                            return;
                        }
                        if (!(descriptor.getRunProfile() instanceof SpringBootApplicationRunConfiguration)) {
                            return;
                        }
                        SpringBootApplicationRunConfiguration configuration = (SpringBootApplicationRunConfiguration)descriptor.getRunProfile();
                        SpringBootApplicationUpdatePolicy policy = configuration.getFrameDeactivationUpdatePolicy();
                        if (policy == null) {
                            return;
                        }
                        if (policy.isAvailableForConfiguration((SpringBootApplicationRunConfigurationBase)configuration) && policy.isAvailableForExecutor(executor) && policy.isAvailableOnFrameDeactivation()) {
                            appsToUpdate.computeIfAbsent(policy, key -> new SmartList()).add(descriptor);
                        }
                    });
                    appsToUpdate.forEach((policy, descriptors) -> policy.runUpdate((SpringBootApplicationUpdateContext)new SpringBootApplicationUpdateContextImpl(project, (List<SpringBootApplicationDescriptor>)descriptors, true)));
                }
            }
        };
        FrameStateManager frameStateManager = FrameStateManager.getInstance();
        if (frameStateManager != null) {
            frameStateManager.addListener(this.myCompileRunnable);
        }
    }

    public void dispose() {
        FrameStateManager frameStateManager = FrameStateManager.getInstance();
        if (frameStateManager != null) {
            frameStateManager.removeListener(this.myCompileRunnable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationCompileManager", "<init>"));
    }
}

