/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.debugger.impl.attach.JavaDebuggerAttachUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteProcess;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.util.net.NetUtils;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

class JmxServiceUrlLiveProperty
extends AsyncLiveProperty<String> {
    private static final String JMX_CONNECTION_ADDRESS_PROPERTY = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String LOCAL_JMX_CONNECTOR_URL = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private final ProcessHandler myProcessHandler;

    JmxServiceUrlLiveProperty(LifecycleErrorHandler errorHandler, Disposable parent, ProcessHandler processHandler) {
        super(errorHandler, parent, "");
        this.myProcessHandler = processHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doCompute() throws LifecycleException {
        String url22;
        VirtualMachine vm;
        String pid = null;
        try {
            Process process = ((BaseProcessHandler)this.myProcessHandler).getProcess();
            if (!(process instanceof RemoteProcess)) {
                pid = String.valueOf(OSProcessUtil.getProcessID((Process)process));
            }
        }
        catch (IllegalStateException process) {
            // empty catch block
        }
        try {
            if (pid == null) {
                throw new AttachNotSupportedException();
            }
            vm = JavaDebuggerAttachUtil.attachVirtualMachine(pid);
        }
        catch (AttachNotSupportedException | IOException e) {
            String url = this.getConnectionUrlByPort();
            if (url == null) throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.jmx.service.url", new Object[0]), new LifecycleException("", e));
            return url;
        }
        catch (Throwable e2222) {
            String url22 = this.getConnectionUrlByPort();
            if (url22 != null) {
                return url22;
            }
            Throwable cause = e2222.getCause();
            if (cause == null) throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.jmx.service.url", new Object[0]), e2222);
            if (cause instanceof Exception) throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.jmx.service.url", new Object[0]), e2222);
            LifecycleException e2222 = new LifecycleException("", e2222);
            throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.jmx.service.url", new Object[0]), e2222);
        }
        try {
            String url = vm.getAgentProperties().getProperty(JMX_CONNECTION_ADDRESS_PROPERTY);
            if (StringUtil.isEmpty((String)url)) {
                throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.jmx.agent.not.loaded", new Object[0]), null);
            }
            url22 = url;
        }
        catch (Throwable e) {
            try {
                String url3 = this.getConnectionUrlByPort();
                if (url3 == null) throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.jmx.service.url", new Object[0]), e);
                String string = url3;
                return string;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    vm.detach();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            vm.detach();
            return url22;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return url22;
    }

    @Nullable
    private String getConnectionUrlByPort() {
        Integer jmxPort = (Integer)this.myProcessHandler.getUserData(SpringBootApplicationLifecycleManager.JMX_PORT);
        if (jmxPort == null || jmxPort <= 0) {
            return null;
        }
        return String.format(LOCAL_JMX_CONNECTOR_URL, NetUtils.getLocalHostString(), jmxPort);
    }
}

