/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.AsyncApplicationLiveProperty;
import com.intellij.spring.boot.run.lifecycle.Endpoint;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootActuatorConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConfigurationException;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootModuleDescriptor;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBeansModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EndpointLiveProperty<T>
extends AsyncApplicationLiveProperty<T> {
    private static final String ENDPOINT_WILDCARD = "*";
    private final Endpoint<T> myEndpoint;
    private final LiveProperty<? extends LiveBeansModel> myLiveBeansModel;

    EndpointLiveProperty(Endpoint<T> endpoint, LiveProperty<SpringBootModuleDescriptor> moduleDescriptor, LiveProperty<String> serviceUrl, LifecycleErrorHandler errorHandler, Disposable parent, LiveProperty<? extends LiveBeansModel> liveBeansModel) {
        super(moduleDescriptor, serviceUrl, errorHandler, parent);
        this.myEndpoint = endpoint;
        this.myLiveBeansModel = liveBeansModel;
    }

    @Override
    public T doCompute() throws LifecycleException {
        Object endpointsEnabledByDefaultProperty;
        SpringBootModuleDescriptor moduleDescriptor = this.getModuleDescriptor();
        if (!moduleDescriptor.isActuatorsEnabled() || !moduleDescriptor.isEndpointAvailable(this.myEndpoint)) {
            return null;
        }
        boolean isSB2 = moduleDescriptor.isSB2();
        String endpointDomain = "org.springframework.boot";
        String endpointDisabledMessage = null;
        try (SpringBootApplicationConnector connector = this.getApplicationConnector();){
            boolean endpointsJmxEnabled = true;
            if (isSB2) {
                Set<String> exposed = EndpointLiveProperty.parseEndpointsList(connector.getProperty("management.endpoints.jmx.exposure.include"));
                if (exposed.isEmpty() || exposed.contains(ENDPOINT_WILDCARD) || exposed.contains(this.myEndpoint.getId())) {
                    Set<String> excluded = EndpointLiveProperty.parseEndpointsList(connector.getProperty("management.endpoints.jmx.exposure.exclude"));
                    if (!excluded.isEmpty() && (excluded.contains(ENDPOINT_WILDCARD) || excluded.contains(this.myEndpoint.getId()))) {
                        endpointsJmxEnabled = false;
                        endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.excluded", "management.endpoints.jmx.exposure.exclude");
                    }
                } else {
                    endpointsJmxEnabled = false;
                    endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.not.exposed", "management.endpoints.jmx.exposure.include");
                }
            } else {
                endpointsJmxEnabled = connector.getBooleanProperty("endpoints.jmx.enabled", true);
                if (!endpointsJmxEnabled) {
                    endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.property.is.set.to.false", "endpoints.jmx.enabled");
                }
            }
            if (endpointsJmxEnabled) {
                endpointsEnabledByDefaultProperty = SpringBootApplicationConnector.ENDPOINTS_ENABLED_PROPERTY.getKey(moduleDescriptor.getVersion());
                boolean endpointsEnabledByDefault = connector.getBooleanProperty((String)endpointsEnabledByDefaultProperty, true);
                String endpointEnabledProperty = String.format(SpringBootApplicationConnector.ENDPOINTS_ID_ENABLED_PROPERTY.getKey(moduleDescriptor.getVersion()), this.myEndpoint.getId());
                boolean endpointEnabled = connector.getBooleanProperty(endpointEnabledProperty, endpointsEnabledByDefault);
                if (!endpointEnabled) {
                    Object propertyName = endpointsEnabledByDefault ? endpointEnabledProperty : endpointsEnabledByDefaultProperty;
                    endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.property.is.set.to.false", propertyName);
                } else {
                    Object o = connector.getProperty(SpringBootApplicationConnector.ENDPOINTS_JMX_DOMAIN_PROPERTY);
                    if (o instanceof String) {
                        endpointDomain = (String)o;
                    } else {
                        o = connector.getProperty("spring.jmx.default-domain");
                        if (o instanceof String) {
                            endpointDomain = (String)o;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data", this.myEndpoint.getId(), e.getLocalizedMessage()), e);
        }
        if (endpointDisabledMessage == null) {
            List<LiveBean> beans;
            LiveBeansModel model;
            LiveBeansModel liveBeansModel = model = this.myLiveBeansModel != null ? (LiveBeansModel)this.myLiveBeansModel.getValue() : null;
            if (model != null && (beans = model.getBeans()).stream().noneMatch(bean -> this.myEndpoint.getBeanName().equals(bean.getId()))) {
                endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.bean.not.initialized", this.myEndpoint.getBeanName());
            }
        }
        String mbeanName = isSB2 ? StringUtil.capitalize((String)this.myEndpoint.getId()) : this.myEndpoint.getBeanName();
        SpringBootActuatorConnector connector = new SpringBootActuatorConnector(this.getServiceUrl(), endpointDomain, mbeanName);
        try {
            endpointsEnabledByDefaultProperty = this.myEndpoint.parseData(connector.getData(isSB2 ? this.myEndpoint.getOperationName() : null));
            return (T)endpointsEnabledByDefaultProperty;
        }
        catch (Exception e) {
            if (endpointDisabledMessage != null) {
                throw new LifecycleException(null, (Throwable)new SpringBootApplicationConfigurationException(endpointDisabledMessage));
            }
            throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data", this.myEndpoint.getId(), e.getLocalizedMessage()), e);
        }
        finally {
            try {
                connector.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @NotNull
    private static Set<String> parseEndpointsList(@Nullable Object value) {
        if (value == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                EndpointLiveProperty.$$$reportNull$$$0(0);
            }
            return set;
        }
        List endpoints = StringUtil.split((String)value.toString(), (String)",");
        Set<String> set = endpoints.stream().map(endpoint -> endpoint.trim()).collect(Collectors.toSet());
        if (set == null) {
            EndpointLiveProperty.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/EndpointLiveProperty", "parseEndpointsList"));
    }
}

