/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.DynamicBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.TargetAwareRunConfigurationEditor;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.editor.EnvironmentSettingsPanel;
import com.intellij.spring.boot.run.editor.SpringBootSettingsPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationRunConfigurationEditor
extends SettingsEditor<SpringBootApplicationRunConfiguration>
implements PanelWithAnchor,
TargetAwareRunConfigurationEditor {
    private static final String EXPAND_JAVA_OPTIONS_PANEL_PROPERTY_KEY = "ExpandSpringBootJavaOptionsPanel";
    private static final String EXPAND_SPRING_BOOT_SETTINGS_PANEL_PROPERTY_KEY = "ExpandSpringBootSpringBootSettingsPanel";
    private final Project myProject;
    private JPanel myWholePanel;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myMainClass;
    private JPanel myHideableEnvironmentSettingsPanel;
    private EnvironmentSettingsPanel myEnvironmentSettingsPanel;
    private JPanel myHideableSpringBootSettingPanel;
    private SpringBootSettingsPanel mySpringBootSettings;
    private JComponent myAnchor;

    public SpringBootApplicationRunConfigurationEditor(Project project) {
        this.myProject = project;
        PanelWithAnchor[] panelWithAnchorArray = new PanelWithAnchor[3];
        this.$$$setupUI$$$();
        panelWithAnchorArray[0] = this.myMainClass;
        panelWithAnchorArray[1] = this.myEnvironmentSettingsPanel;
        panelWithAnchorArray[2] = this.mySpringBootSettings;
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])panelWithAnchorArray);
    }

    private void createUIComponents() {
        this.myMainClass = new LabeledComponent();
        this.myMainClass.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.myProject, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                if (declaration instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)declaration;
                    if (SpringBootApplicationService.getInstance().isSpringApplication(aClass) && SpringBootApplicationService.getInstance().hasMainMethod(aClass)) {
                        return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                    }
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        }));
        this.myHideableEnvironmentSettingsPanel = new JPanel(new BorderLayout());
        this.myEnvironmentSettingsPanel = new EnvironmentSettingsPanel(this.myProject, this.getMainClassField());
        this.installHideableDecorator(this.myHideableEnvironmentSettingsPanel, this.myEnvironmentSettingsPanel.getComponent(), SpringBootRunBundle.message("spring.boot.application.run.configuration.environment.section", new Object[0]), EXPAND_JAVA_OPTIONS_PANEL_PROPERTY_KEY, false);
        this.myHideableSpringBootSettingPanel = new JPanel(new BorderLayout());
        this.mySpringBootSettings = new SpringBootSettingsPanel(this.myProject);
        this.installHideableDecorator(this.myHideableSpringBootSettingPanel, this.mySpringBootSettings.getComponent(), SpringBootRunBundle.message("spring.boot.application.run.configuration.framework.section", new Object[0]), EXPAND_SPRING_BOOT_SETTINGS_PANEL_PROPERTY_KEY, true);
        this.myEnvironmentSettingsPanel.addModuleChangeListener(this.mySpringBootSettings::setModule);
        new SpringBootClassBrowser(this.myProject, this.myEnvironmentSettingsPanel.getModuleSelector()).setField((ComponentWithBrowseButton)this.getMainClassField());
    }

    protected void resetEditorFrom(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            SpringBootApplicationRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.getMainClassField().setText(configuration.getSpringBootMainClass() != null ? configuration.getSpringBootMainClass().replace('$', '.') : "");
        this.myEnvironmentSettingsPanel.resetEditorFrom(configuration);
        this.mySpringBootSettings.resetEditorFrom(configuration);
    }

    protected void applyEditorTo(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            SpringBootApplicationRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        String className = this.getMainClassField().getText();
        PsiClass aClass = this.myEnvironmentSettingsPanel.getModuleSelector().findClass(className);
        configuration.setSpringBootMainClass(aClass != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass) : className);
        this.myEnvironmentSettingsPanel.applyEditorTo(configuration);
        this.mySpringBootSettings.applyEditorTo(configuration);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            SpringBootApplicationRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myMainClass.setAnchor(anchor);
        this.myEnvironmentSettingsPanel.setAnchor(anchor);
        this.mySpringBootSettings.setAnchor(anchor);
    }

    private EditorTextFieldWithBrowseButton getMainClassField() {
        return (EditorTextFieldWithBrowseButton)this.myMainClass.getComponent();
    }

    private void installHideableDecorator(JPanel panel, JComponent content, @NlsContexts.Separator String title, final String expandPropertyKey, final boolean defaultState) {
        HideableDecorator hideableDecorator = new HideableDecorator(panel, title, false){

            protected void on() {
                super.on();
                this.storeState();
            }

            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance((Project)SpringBootApplicationRunConfigurationEditor.this.myProject).setValue(expandPropertyKey, this.isExpanded(), defaultState);
            }
        };
        hideableDecorator.setOn(PropertiesComponent.getInstance((Project)this.myProject).getBoolean(expandPropertyKey, defaultState));
        hideableDecorator.setContentComponent(content);
    }

    public void targetChanged(String targetName) {
        this.myEnvironmentSettingsPanel.targetChanged(targetName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/editor/SpringBootApplicationRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/editor/SpringBootApplicationRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent = this.myMainClass;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", SpringBootApplicationRunConfigurationEditor.class).getString("spring.boot.application.run.configuration.main.class"));
        jPanel.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel2 = this.myHideableEnvironmentSettingsPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = this.myHideableSpringBootSettingPanel;
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private static class SpringBootClassBrowser
    extends ClassBrowser.MainClassBrowser<EditorTextField> {
        SpringBootClassBrowser(Project project, ConfigurationModuleSelector moduleSelector) {
            super(project, moduleSelector, SpringBootRunBundle.message("spring.boot.choose.class.dialog.title", new Object[0]));
        }

        protected ClassFilter createFilter(Module module) {
            return new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return SpringBootApplicationService.getInstance().isSpringApplication(aClass) && (Boolean)ReadAction.compute(() -> SpringBootApplicationService.getInstance().hasMainMethod(aClass)) != false;
                }
            };
        }
    }
}

