/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.application.ApplicationCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootJmxSetup;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.update.TriggerFilePolicy;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootCommandLineState
extends ApplicationCommandLineState<SpringBootApplicationRunConfiguration> {
    static final String DEBUG_PARAMETER = "-Ddebug";
    static final String TIERED_STOP_AT_LEVEL_1_PARAMETER = "-XX:TieredStopAtLevel=1";
    static final String NO_VERIFY_PARAMETER = "-noverify";
    static final String HIDE_BANNER_PARAMETER = "-Dspring.main.show_banner=false";
    static final String HIDE_BANNER_PARAMETER_1_5 = "-Dspring.main.banner-mode=OFF";
    static final String ACTIVE_PROFILES_PARAMETER = "-Dspring.profiles.active";
    static final String TRIGGER_FILE_PARAMETER = "-Dspring.devtools.restart.trigger-file";
    static final String OUTPUT_ANSI_ENABLED_PARAMETER = "-Dspring.output.ansi.enabled=always";
    static final String JMX_REMOTE_PARAMETER = "-Dcom.sun.management.jmxremote";
    static final String SPRING_JMX_PARAMETER = "-Dspring.jmx.enabled=true";
    static final String LIVE_BEAN_PARAMETER = "-Dspring.liveBeansView.mbeanDomain";
    static final String LIFECYCLE_PARAMETER = "-Dspring.application.admin.enabled=true";
    private static final int DEFAULT_SERVER_PORT = 8080;
    private static final String SERVER_PORT_PROPERTY = "server.port";
    private SpringBootJmxSetup myJmxSetup;
    private TargetEnvironment myResolvedEnvironment;

    SpringBootCommandLineState(@NotNull SpringBootApplicationRunConfiguration configuration, ExecutionEnvironment environment) {
        if (configuration == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(0);
        }
        super((ModuleBasedConfiguration)configuration, environment);
    }

    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration) throws ExecutionException {
        if (request == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(1);
        }
        JavaParameters javaParams = this.getJavaParameters();
        this.exposeServerHttpPort(javaParams, request);
        this.setupJmxParameters(javaParams, request);
        TargetedCommandLineBuilder targetedCommandLineBuilder = super.createTargetedCommandLine(request, configuration);
        if (targetedCommandLineBuilder == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(2);
        }
        return targetedCommandLineBuilder;
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters params = super.createJavaParameters();
        this.applySpringBootSettings(params);
        return params;
    }

    protected boolean isProvidedScopeIncluded() {
        return ((SpringBootApplicationRunConfiguration)this.myConfiguration).isIncludeProvidedScope();
    }

    private void applySpringBootSettings(JavaParameters params) {
        ParametersList vmParametersList = params.getVMParametersList();
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isDebugMode()) {
            vmParametersList.add(DEBUG_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isEnableLaunchOptimization()) {
            vmParametersList.add(TIERED_STOP_AT_LEVEL_1_PARAMETER);
            vmParametersList.add(NO_VERIFY_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isHideBanner()) {
            if (SpringBootLibraryUtil.isAtLeastVersion((Module)((SpringBootApplicationRunConfiguration)this.myConfiguration).getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0)) {
                vmParametersList.add(HIDE_BANNER_PARAMETER_1_5);
            } else {
                vmParametersList.add(HIDE_BANNER_PARAMETER);
            }
        }
        if (StringUtil.isNotEmpty((String)((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles())) {
            vmParametersList.add("-Dspring.profiles.active=" + ((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles());
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).getUpdateActionUpdatePolicy() instanceof TriggerFilePolicy) {
            vmParametersList.add("-Dspring.devtools.restart.trigger-file=.restartTriggerFile");
        }
        vmParametersList.add(OUTPUT_ANSI_ENABLED_PARAMETER);
        for (SpringBootAdditionalParameter parameter : ((SpringBootApplicationRunConfiguration)this.myConfiguration).getAdditionalParameters()) {
            if (!parameter.isEnabled()) continue;
            String parameterValue = parameter.getValue();
            if (StringUtil.isNotEmpty((String)parameterValue)) {
                vmParametersList.add("-D" + parameter.getName() + "=" + parameterValue);
                continue;
            }
            vmParametersList.add("-D" + parameter.getName());
        }
    }

    private void setupJmxParameters(JavaParameters params, TargetEnvironmentRequest targetRequest) throws ExecutionException {
        if (!((SpringBootApplicationRunConfiguration)this.myConfiguration).isEnableJmxAgent()) {
            return;
        }
        if (SpringBootLibraryUtil.isBelowVersion((Module)((SpringBootApplicationRunConfiguration)this.myConfiguration).getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            return;
        }
        ParametersList vmParametersList = params.getVMParametersList();
        vmParametersList.add(JMX_REMOTE_PARAMETER);
        vmParametersList.add(SPRING_JMX_PARAMETER);
        vmParametersList.add(LIVE_BEAN_PARAMETER);
        vmParametersList.add(LIFECYCLE_PARAMETER);
        this.myJmxSetup = targetRequest instanceof LocalTargetEnvironmentRequest ? new SpringBootJmxSetup.LocalSetup() : new SpringBootJmxSetup.RemoteSetup();
        this.myJmxSetup.setupJmxParameters(params, targetRequest);
    }

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator targetProgressIndicator) {
        if (environment == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(3);
        }
        if (targetProgressIndicator == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(4);
        }
        super.handleCreatedTargetEnvironment(environment, targetProgressIndicator);
        this.myResolvedEnvironment = environment;
        if (this.myJmxSetup != null) {
            this.myJmxSetup.handleCreatedEnvironment(environment);
        }
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (executor == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(5);
        }
        if (runner == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(6);
        }
        ExecutionResult result = super.execute(executor, runner);
        if (this.myJmxSetup != null) {
            this.myJmxSetup.setupProcessHandler(result.getProcessHandler());
            SpringBootApplicationLifecycleManager.getInstance((Project)((SpringBootApplicationRunConfiguration)this.getConfiguration()).getProject());
        }
        if (this.myResolvedEnvironment != null) {
            Map portsMap = this.myResolvedEnvironment.getTargetPortBindings();
            SpringBootApplicationLifecycleManager.TunnelPortMapping mapping = remotePort -> portsMap.entrySet().stream().filter(entry -> ((TargetEnvironment.TargetPortBinding)entry.getKey()).getTarget() == remotePort).findAny().map(entry -> (Integer)entry.getValue()).orElse(remotePort);
            result.getProcessHandler().putUserData(SpringBootApplicationLifecycleManager.TunnelPortMapping.KEY, (Object)mapping);
        }
        ExecutionResult executionResult = result;
        if (executionResult == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(7);
        }
        return executionResult;
    }

    protected AnAction @NotNull [] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        AnAction action;
        Object[] actions = super.createActions(console, processHandler, executor);
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).getUpdateActionUpdatePolicy() != null && (action = ActionManager.getInstance().getAction("UpdateRunningApplication")) != null) {
            AnAction[] anActionArray = (AnAction[])ArrayUtil.append((Object[])actions, (Object)action);
            if (anActionArray == null) {
                SpringBootCommandLineState.$$$reportNull$$$0(8);
            }
            return anActionArray;
        }
        if (actions == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(9);
        }
        return actions;
    }

    private void exposeServerHttpPort(@NotNull JavaParameters javaParams, @NotNull TargetEnvironmentRequest request) {
        int serverPort;
        if (javaParams == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(10);
        }
        if (request == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(11);
        }
        if (request instanceof LocalTargetEnvironmentRequest) {
            return;
        }
        try {
            String serverPortString = Optional.ofNullable(this.findServerPort(javaParams)).orElse(String.valueOf(8080));
            serverPort = Integer.parseInt(serverPortString);
        }
        catch (NumberFormatException e) {
            serverPort = 8080;
        }
        request.getTargetPortBindings().add(new TargetEnvironment.TargetPortBinding(null, serverPort));
    }

    @Nullable
    private String findServerPort(@NotNull JavaParameters javaParams) {
        SpringBootApplicationRunConfiguration runConfig;
        SpringBootAdditionalParameter additionalParameter;
        if (javaParams == null) {
            SpringBootCommandLineState.$$$reportNull$$$0(12);
        }
        if ((additionalParameter = (SpringBootAdditionalParameter)ContainerUtil.find((runConfig = (SpringBootApplicationRunConfiguration)this.getConfiguration()).getAdditionalParameters(), next -> next.isEnabled() && SERVER_PORT_PROPERTY.equals(next.getName()))) != null) {
            return additionalParameter.getValue();
        }
        String fromVmOptions = javaParams.getVMParametersList().getPropertyValue(SERVER_PORT_PROPERTY);
        if (fromVmOptions != null && !fromVmOptions.isBlank()) {
            return fromVmOptions;
        }
        return (String)ReadAction.compute(() -> this.findServerPortInConfigs());
    }

    private String findServerPortInConfigs() {
        SpringBootApplicationRunConfiguration runConfig = (SpringBootApplicationRunConfiguration)this.getConfiguration();
        Set profiles = SpringProfileUtils.profilesFromString((String)runConfig.getActiveProfiles());
        Ref result = new Ref();
        SpringBootConfigValueSearcher.productionForProfiles((Module)runConfig.getModule(), (String)SERVER_PORT_PROPERTY, (Set)profiles).process(nextResult -> {
            String value = nextResult.getValueText();
            if (value != null && !value.isEmpty() && !value.isBlank()) {
                result.set((Object)value);
            }
            return result.isNull();
        });
        return (String)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/SpringBootCommandLineState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProgressIndicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/SpringBootCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetedCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTargetedCommandLine";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleCreatedTargetEnvironment";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "exposeServerHttpPort";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findServerPort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

