/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManagerImpl;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationUrlUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebugSession;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationRunDashboardCustomizer
extends RunDashboardCustomizer {
    @NlsSafe
    private static final String DEVTOOLS_TAIL = " [devtools]";

    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        if (settings == null) {
            SpringBootApplicationRunDashboardCustomizer.$$$reportNull$$$0(0);
        }
        return settings.getConfiguration() instanceof SpringBootApplicationRunConfigurationBase;
    }

    public boolean updatePresentation(@NotNull PresentationData presentation, @NotNull RunDashboardRunConfigurationNode node) {
        ProcessHandler handler;
        RunConfiguration runConfiguration;
        if (presentation == null) {
            SpringBootApplicationRunDashboardCustomizer.$$$reportNull$$$0(1);
        }
        if (node == null) {
            SpringBootApplicationRunDashboardCustomizer.$$$reportNull$$$0(2);
        }
        if (!((runConfiguration = node.getConfigurationSettings().getConfiguration()) instanceof SpringBootApplicationRunConfigurationBase)) {
            return false;
        }
        SpringBootApplicationRunConfigurationBase springBootRunConfiguration = (SpringBootApplicationRunConfigurationBase)runConfiguration;
        if (!DumbService.getInstance((Project)node.getProject()).isDumb() && SpringBootLibraryUtil.hasDevtools((Module)springBootRunConfiguration.getModule())) {
            presentation.addText(DEVTOOLS_TAIL, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        SpringBootApplicationInfo info = null;
        RunContentDescriptor descriptor = node.getDescriptor();
        if (descriptor != null && descriptor.getProcessHandler() != null && !(handler = descriptor.getProcessHandler()).isProcessTerminated()) {
            info = SpringBootApplicationLifecycleManager.getInstance((Project)node.getProject()).getSpringBootApplicationInfo(handler);
        }
        if (info != null) {
            Integer serverPort;
            if (Boolean.FALSE.equals(info.getReadyState().getValue())) {
                XDebugSession session = SpringBootApplicationLifecycleManagerImpl.getDebugSession(node.getProject(), descriptor.getProcessHandler());
                if (session == null || !session.isPaused()) {
                    presentation.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
                } else {
                    presentation.setIcon(AllIcons.Process.Step_4);
                }
            }
            if ((serverPort = (Integer)info.getServerPort().getValue()) != null && serverPort > 0) {
                presentation.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String path = springBootRunConfiguration.getUrlPath();
                String applicationLink = ":" + serverPort + (StringUtil.isEmpty((String)path) ? "/" : path);
                presentation.addText(applicationLink, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                HashMap<CallSite, ApplicationLinkListener> links = new HashMap<CallSite, ApplicationLinkListener>();
                links.put((CallSite)((Object)applicationLink), new ApplicationLinkListener(info, springBootRunConfiguration));
                node.putUserData(NODE_LINKS, links);
            } else {
                node.putUserData(NODE_LINKS, null);
            }
        } else {
            node.putUserData(NODE_LINKS, null);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardCustomizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ApplicationLinkListener
    implements Runnable {
        final SpringBootApplicationInfo myLinkInfo;
        final SpringBootApplicationRunConfigurationBase myConfiguration;

        ApplicationLinkListener(@NotNull SpringBootApplicationInfo linkInfo, @NotNull SpringBootApplicationRunConfigurationBase configuration) {
            if (linkInfo == null) {
                ApplicationLinkListener.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                ApplicationLinkListener.$$$reportNull$$$0(1);
            }
            this.myLinkInfo = linkInfo;
            this.myConfiguration = configuration;
        }

        @Override
        public void run() {
            String applicationUrl = (String)this.myLinkInfo.getApplicationUrl().getValue();
            if (applicationUrl != null) {
                SpringBootApplicationUrlUtil urlUtil = SpringBootApplicationUrlUtil.getInstance();
                String mappingPath = this.myConfiguration.getUrlPath();
                String servletPath = urlUtil.getServletPath(this.myLinkInfo, mappingPath);
                BrowserUtil.browse((String)urlUtil.getMappingUrl(applicationUrl, servletPath, mappingPath));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myLinkInfo.equals(((ApplicationLinkListener)o).myLinkInfo);
        }

        public int hashCode() {
            return this.myLinkInfo.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linkInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardCustomizer$ApplicationLinkListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

