/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.git;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r26\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00070\u000fJ\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000b2\b\b\u0002\u0010\u001a\u001a\u00020\u001bJN\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070!H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/indexing/shared/git/ProjectGitHelper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "logGitBlobHashes", "", "project", "Lcom/intellij/openapi/project/Project;", "repo", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "consumer", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "relPath", "hash", "logGitModifiedFiles", "", "logRecentCommits", "", "root", "limit", "", "runGitCommand", "command", "Lgit4idea/commands/GitCommand;", "params", "stdoutLinesConsumer", "Lkotlin/Function1;", "intellij.indexing.shared.git"})
public final class ProjectGitHelper {
    private static final Logger LOG;
    public static final ProjectGitHelper INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runGitCommand(Project project, Path root, GitCommand command, List<String> params, ProgressIndicator indicator, Function1<? super String, Unit> stdoutLinesConsumer) {
        long startTime = System.currentTimeMillis();
        try {
            GitLineHandler handler = new GitLineHandler(project, root.toFile(), command);
            handler.setIgnoreAuthenticationMode(GitAuthenticationMode.SILENT);
            handler.setWithMediator(false);
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            handler.addParameters(Arrays.copyOf(stringArray, stringArray.length));
            handler.addLineListener(new GitLineHandlerListener(indicator, stdoutLinesConsumer){
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ Function1 $stdoutLinesConsumer;

                public void onLineAvailable(@Nullable String line, @Nullable Key<?> outputType) {
                    ProgressIndicator progressIndicator = this.$indicator;
                    if (progressIndicator != null) {
                        progressIndicator.checkCanceled();
                    }
                    if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT) ^ true || line == null) {
                        return;
                    }
                    this.$stdoutLinesConsumer.invoke((Object)line);
                }
                {
                    this.$indicator = $captured_local_variable$0;
                    this.$stdoutLinesConsumer = $captured_local_variable$1;
                }
            });
            Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
        }
        catch (Exception t) {
            if (t instanceof ControlFlowException) {
                throw (Throwable)t;
            }
            LOG.debug("Shared Indexes Git command " + command + " with " + params + " failed " + t.getMessage(), (Throwable)t);
            throw (Throwable)t;
        }
        finally {
            long duration = RangesKt.coerceAtLeast((long)(System.currentTimeMillis() - startTime), (long)1L);
            LOG.info("Shared Indexes git " + command.name() + " took " + StringUtil.formatDuration((long)duration));
        }
    }

    static /* synthetic */ void runGitCommand$default(ProjectGitHelper projectGitHelper, Project project, Path path, GitCommand gitCommand, List list, ProgressIndicator progressIndicator, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            progressIndicator = null;
        }
        projectGitHelper.runGitCommand(project, path, gitCommand, list, progressIndicator, (Function1<? super String, Unit>)function1);
    }

    @NotNull
    public final List<String> logRecentCommits(@NotNull Project project, @NotNull Path root, int limit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        LinkedHashSet result = new LinkedHashSet();
        GitCommand gitCommand = GitCommand.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"GitCommand.LOG");
        ProjectGitHelper.runGitCommand$default(this, project, root, gitCommand, CollectionsKt.listOf((Object[])new String[]{"" + '-' + limit, "--topo-order", "--format=%H"}), null, (Function1)new Function1<String, Unit>(result){
            final /* synthetic */ LinkedHashSet $result;

            public final void invoke(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                Object object = line;
                boolean bl = false;
                String text = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                object = text;
                bl = false;
                if (!StringsKt.isBlank((CharSequence)object)) {
                    object = this.$result;
                    String string = text;
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    string = string3;
                    bl2 = false;
                    object.add(string);
                }
            }
            {
                this.$result = linkedHashSet;
                super(1);
            }
        }, 16, null);
        return CollectionsKt.toList((Iterable)result);
    }

    public static /* synthetic */ List logRecentCommits$default(ProjectGitHelper projectGitHelper, Project project, Path path, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 2048;
        }
        return projectGitHelper.logRecentCommits(project, path, n);
    }

    public final void logGitBlobHashes(@NotNull Project project, @NotNull Path repo, @NotNull ProgressIndicator indicator, @NotNull Function2<? super String, ? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        GitCommand gitCommand = GitCommand.LS_TREE;
        Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"GitCommand.LS_TREE");
        this.runGitCommand(project, repo, gitCommand, CollectionsKt.listOf((Object[])new String[]{"--full-tree", "-r", "HEAD"}), indicator, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(consumer){
            final /* synthetic */ Function2 $consumer;

            public final void invoke(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                List it = StringsKt.split$default((CharSequence)line, (char[])new char[]{' ', '\t'}, (boolean)false, (int)0, (int)6, null);
                if (it.size() == 4 && Intrinsics.areEqual((Object)((String)it.get(1)), (Object)"blob")) {
                    String path = (String)it.get(3);
                    String hash2 = (String)it.get(2);
                    this.$consumer.invoke((Object)path, (Object)hash2);
                }
            }
            {
                this.$consumer = function2;
                super(1);
            }
        }));
    }

    @NotNull
    public final Set<String> logGitModifiedFiles(@NotNull Project project, @NotNull Path repo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        HashSet result = new HashSet();
        GitCommand gitCommand = GitCommand.STATUS;
        Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"GitCommand.STATUS");
        ProjectGitHelper.runGitCommand$default(this, project, repo, gitCommand, CollectionsKt.listOf((Object[])new String[]{"--no-renames", "--porcelain=1", "--ignore-submodules"}), null, (Function1)new Function1<String, Unit>(result){
            final /* synthetic */ HashSet $result;

            public final void invoke(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String path = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)line, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null));
                Object object = path;
                boolean bl = false;
                if (!StringsKt.isBlank((CharSequence)object)) {
                    object = this.$result;
                    bl = false;
                    object.add(path);
                }
            }
            {
                this.$result = hashSet;
                super(1);
            }
        }, 16, null);
        return result;
    }

    private ProjectGitHelper() {
    }

    static {
        ProjectGitHelper projectGitHelper;
        INSTANCE = projectGitHelper = new ProjectGitHelper();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectGitHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

