/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.MethodHandleType;
import org.jf.dexlib2.dexbacked.raw.FieldIdItem;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.MethodIdItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class MethodHandleItem {
    public static final int ITEM_SIZE = 8;
    public static final int METHOD_HANDLE_TYPE_OFFSET = 0;
    public static final int MEMBER_ID_OFFSET = 4;

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                return "method_handle_item";
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                int methodHandleType = this.dexFile.readUshort(out.getCursor());
                out.annotate(2, "type = %s", MethodHandleType.toString(methodHandleType));
                out.annotate(2, "unused", new Object[0]);
                int fieldOrMethodId = this.dexFile.readUshort(out.getCursor());
                String fieldOrMethodDescriptor = methodHandleType == 4 || methodHandleType == 5 ? MethodIdItem.getReferenceAnnotation(this.dexFile, fieldOrMethodId) : FieldIdItem.getReferenceAnnotation(this.dexFile, fieldOrMethodId);
                out.annotate(2, "field_or_method_id = %s", fieldOrMethodDescriptor);
                out.annotate(2, "unused", new Object[0]);
            }
        };
    }
}

