/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBeanMarker;
import com.intellij.spring.model.SpringInfrastructureBean;
import com.intellij.spring.toolWindow.SpringBeanPointerPanelBase;
import com.intellij.spring.toolWindow.SpringBeansViewSettings;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerDependenciesListener;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanPointerFinderRecursivePanel
extends SpringBeanPointerPanelBase {
    public static final ExtensionPointName<SpringBeanPointerPanelContent> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.beanPointerPanelContent");
    private final NullableFactory<CommonSpringModel> myModelFactory;
    private Set<PsiFile> modelFiles;

    public SpringBeanPointerFinderRecursivePanel(@NotNull Project project, @Nullable String groupId, @NotNull NullableFactory<CommonSpringModel> modelFactory) {
        if (project == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(0);
        }
        if (modelFactory == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(1);
        }
        super(project, groupId);
        this.modelFiles = Collections.emptySet();
        this.myModelFactory = modelFactory;
        this.installDependenciesListener();
    }

    public SpringBeanPointerFinderRecursivePanel(@NotNull FinderRecursivePanel panel2, @NotNull NullableFactory<CommonSpringModel> modelFactory) {
        if (panel2 == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(2);
        }
        if (modelFactory == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(3);
        }
        super(panel2);
        this.modelFiles = Collections.emptySet();
        this.myModelFactory = modelFactory;
        this.installDependenciesListener();
    }

    private void installDependenciesListener() {
        new SpringBeanPointerDependenciesListener(this);
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(SpringFileSetService.TOPIC, (Object)new SpringFileSetService.SpringFileSetListener(){

            @Override
            public void activeProfilesChanged() {
                SpringBeanPointerFinderRecursivePanel.this.updatePanel();
            }
        });
    }

    boolean knowsAboutConfigurationFile(PsiFile file) {
        return this.modelFiles.contains(file);
    }

    protected boolean hasChildren(@NotNull SpringBeanPointer pointer) {
        if (pointer == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(4);
        }
        return false;
    }

    @NotNull
    protected List<SpringBeanPointer> getListItems() {
        CommonSpringModel commonSpringModel = (CommonSpringModel)this.myModelFactory.create();
        if (commonSpringModel == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(5);
            }
            return list;
        }
        this.modelFiles = new HashSet<PsiFile>(SpringModelVisitorUtils.getConfigFiles(commonSpringModel));
        List<SpringBeanPointer> localBeans = this.getSortedAndFilteredItems(commonSpringModel.getAllCommonBeans());
        for (SpringBeanPointer bean : localBeans) {
            this.modelFiles.add(bean.getContainingFile());
        }
        List<SpringBeanPointer> list = localBeans;
        if (list == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(6);
        }
        return list;
    }

    private List<SpringBeanPointer> getSortedAndFilteredItems(Collection<SpringBeanPointer> beans) {
        TreeSet<SpringBeanPointer> pointers = new TreeSet<SpringBeanPointer>(Comparator.comparing(this::getItemText, NaturalComparator.INSTANCE));
        boolean showImplicitBeans = this.getSettings().isShowImplicitBeans();
        boolean showInfrastructureBeans = this.getSettings().isShowInfrastructureBeans();
        pointers.addAll(ContainerUtil.filter(beans, springBeanPointer -> {
            if (!showImplicitBeans && springBeanPointer.getSpringBean() instanceof SpringImplicitBeanMarker) {
                return false;
            }
            return showInfrastructureBeans || !(springBeanPointer.getSpringBean() instanceof SpringInfrastructureBean);
        }));
        return new ArrayList<SpringBeanPointer>(pointers);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        Object data;
        if (dataId == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(7);
        }
        if ((data = super.getData(dataId)) != null) {
            return data;
        }
        for (SpringBeanPointerPanelContent content : (SpringBeanPointerPanelContent[])EP_NAME.getExtensions()) {
            Object contentData = content.getData(this, dataId);
            if (contentData == null) continue;
            return contentData;
        }
        return null;
    }

    protected AnAction[] getCustomListActions() {
        return new AnAction[]{ActionManager.getInstance().getAction("SpringChangeActiveProfiles")};
    }

    protected JComponent createDefaultRightComponent() {
        SpringBeansViewSettings settings = this.getSettings();
        if (!(settings.isShowDoc() || settings.isShowGraph() && ((SpringBeanPointerPanelContent[])EP_NAME.getExtensions()).length != 0)) {
            return null;
        }
        return super.createDefaultRightComponent();
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull SpringBeanPointer pointer) {
        if (pointer == null) {
            SpringBeanPointerFinderRecursivePanel.$$$reportNull$$$0(8);
        }
        final SpringBeansViewSettings settings = this.getSettings();
        SpringBeanPointerPanelContent[] contentExtensions = (SpringBeanPointerPanelContent[])EP_NAME.getExtensions();
        if (!(settings.isShowDoc() || settings.isShowGraph() && contentExtensions.length != 0)) {
            return null;
        }
        FinderRecursivePanel.DisposablePanel disposablePanel = new FinderRecursivePanel.DisposablePanel((LayoutManager)new BorderLayout(), (Disposable)this);
        if (!pointer.isValid() || this.isDisposed()) {
            return disposablePanel;
        }
        float storedProportion = settings.getBeanDetailsProportion();
        float proportion = storedProportion != -1.0f ? storedProportion : (settings.isShowGraph() ? 0.3f : 1.0f);
        OnePixelSplitter splitter = new OnePixelSplitter(true, proportion, 0.1f, 0.9f){

            protected void saveProportion() {
                settings.setBeanDetailsProportion(this.getProportion());
            }
        };
        disposablePanel.add((Component)splitter, (Object)"Center");
        if (settings.isShowDoc()) {
            PsiElement element = pointer.getSpringBean().getIdentifyingPsiElement();
            DocumentationComponent documentationComponent = DocumentationComponent.createAndFetch((Project)this.getProject(), (PsiElement)element, (Disposable)this);
            splitter.setFirstComponent((JComponent)documentationComponent);
        }
        if (settings.isShowGraph()) {
            for (SpringBeanPointerPanelContent content : contentExtensions) {
                JComponent component = content.createComponent(this, (Disposable)disposablePanel, this.myModelFactory, pointer);
                splitter.setSecondComponent(component);
            }
        }
        return disposablePanel;
    }

    public void setSecondComponent(@Nullable JComponent component) {
        super.setSecondComponent(component);
        if (!this.getSettings().isShowGraph()) {
            return;
        }
        for (SpringBeanPointerPanelContent content : (SpringBeanPointerPanelContent[])EP_NAME.getExtensions()) {
            content.update(this);
        }
    }

    private SpringBeansViewSettings getSettings() {
        return SpringBeansViewSettings.getInstance(this.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/toolWindow/panels/SpringBeanPointerFinderRecursivePanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/toolWindow/panels/SpringBeanPointerFinderRecursivePanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SpringBeanPointerPanelContent {
        public JComponent createComponent(FinderRecursivePanel var1, Disposable var2, NullableFactory<CommonSpringModel> var3, SpringBeanPointer var4);

        public void update(FinderRecursivePanel var1);

        public Object getData(FinderRecursivePanel var1, @NotNull @NonNls String var2);
    }
}

