/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.spring.toolWindow.SpringBaseView;
import com.intellij.spring.toolWindow.SpringToolWindowContent;
import com.intellij.spring.toolWindow.SpringToolWindowContentProvider;
import com.intellij.spring.toolWindow.SpringToolWindowContentUpdater;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringToolWindowFactory
implements ToolWindowFactory {
    private static final ExtensionPointName<SpringToolWindowContent> CONTENT_EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.toolWindowContent");

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            SpringToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            SpringToolWindowFactory.$$$reportNull$$$0(1);
        }
        toolWindow.setAvailable(true);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setContentUiType(ToolWindowContentUiType.TABBED, null);
        final ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContentManagerListener((ContentManagerListener)new MyContentManagerListener(project));
        SpringToolWindowContentUpdater updater = new SpringToolWindowContentUpdater(){

            @Override
            public void update(@Nullable Runnable onDone) {
                SpringToolWindowFactory.asyncUpdateContents(project, contentManager, onDone);
            }
        };
        contentManager.addDataProvider(dataId -> {
            if (SpringToolWindowContent.CONTENT_UPDATER.is(dataId)) {
                return updater;
            }
            return null;
        });
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)contentManager);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                SpringToolWindowFactory.asyncUpdateContents(project, contentManager);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/toolWindow/SpringToolWindowFactory$2", "rootsChanged"));
            }
        });
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    3.$$$reportNull$$$0(0);
                }
                SpringToolWindowFactory.asyncUpdateContents(project, contentManager);
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    3.$$$reportNull$$$0(1);
                }
                SpringToolWindowFactory.asyncUpdateContents(project, contentManager);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/spring/toolWindow/SpringToolWindowFactory$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)contentManager);
        CONTENT_EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<SpringToolWindowContent>(){

            public void extensionAdded(@NotNull SpringToolWindowContent extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                SpringToolWindowFactory.asyncUpdateContents(project, contentManager);
            }

            public void extensionRemoved(@NotNull SpringToolWindowContent extension, @NotNull PluginDescriptor pluginDescriptor) {
                Content existing;
                if (extension == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(3);
                }
                if ((existing = contentManager.findContent(extension.getDisplayName())) != null) {
                    contentManager.removeContent(existing, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/toolWindow/SpringToolWindowFactory$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)contentManager);
        SpringToolWindowFactory.asyncUpdateContents(project, contentManager);
    }

    private static void asyncUpdateContents(@NotNull Project project, ContentManager contentManager) {
        if (project == null) {
            SpringToolWindowFactory.$$$reportNull$$$0(2);
        }
        SpringToolWindowFactory.asyncUpdateContents(project, contentManager, null);
    }

    private static void asyncUpdateContents(@NotNull Project project, ContentManager contentManager, @Nullable Runnable onDone) {
        if (project == null) {
            SpringToolWindowFactory.$$$reportNull$$$0(3);
        }
        ReadAction.nonBlocking(() -> SpringToolWindowFactory.getToolWindowContentsByAvailability(project)).inSmartMode(project).expireWith((Disposable)contentManager).coalesceBy(new Object[]{SpringToolWindowFactory.class, project, onDone}).finishOnUiThread(ModalityState.any(), toolWindowsPartition -> {
            SpringToolWindowFactory.updateSpringToolWindowContents(contentManager, (List)toolWindowsPartition.first, (List)toolWindowsPartition.second);
            if (onDone != null) {
                onDone.run();
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private static Pair<List<SpringToolWindowContent>, List<SpringToolWindowContent>> getToolWindowContentsByAvailability(Project project) {
        SmartList available = new SmartList();
        SmartList notAvailable = new SmartList();
        for (SpringToolWindowContent springToolWindowContent : (SpringToolWindowContent[])CONTENT_EP_NAME.getExtensions()) {
            (((SpringToolWindowContentProvider)springToolWindowContent.getInstance()).isAvailable(project) ? available : notAvailable).add(springToolWindowContent);
        }
        Pair pair = Pair.create((Object)available, (Object)notAvailable);
        if (pair == null) {
            SpringToolWindowFactory.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static void updateSpringToolWindowContents(ContentManager contentManager, List<SpringToolWindowContent> available, List<SpringToolWindowContent> notAvailable) {
        for (SpringToolWindowContent springToolWindowContent : notAvailable) {
            Content existing = contentManager.findContent(springToolWindowContent.getDisplayName());
            if (existing == null) continue;
            contentManager.removeContent(existing, true);
        }
        ContentFactory factory = contentManager.getFactory();
        for (SpringToolWindowContent springToolWindowContent : available) {
            Content existing = contentManager.findContent(springToolWindowContent.getDisplayName());
            if (existing != null) continue;
            Content content = factory.createContent((JComponent)new SpringToolWindowContentStub(springToolWindowContent), springToolWindowContent.getDisplayName(), false);
            content.setCloseable(false);
            Icon icon = null;
            try {
                icon = IconLoader.getIcon((String)springToolWindowContent.icon, ((Object)((Object)springToolWindowContent)).getClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
            content.setPopupIcon(icon);
            contentManager.addContent(content);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/toolWindow/SpringToolWindowFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/toolWindow/SpringToolWindowFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowContentsByAvailability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdateContents";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SpringToolWindowContentStub
    extends JPanel {
        private final SpringToolWindowContent mySpringToolWindowContent;

        private SpringToolWindowContentStub(SpringToolWindowContent springToolWindowContent) {
            this.mySpringToolWindowContent = springToolWindowContent;
        }

        public SpringToolWindowContent getSpringToolWindowContent() {
            return this.mySpringToolWindowContent;
        }
    }

    private static final class MyContentManagerListener
    implements ContentManagerListener {
        private final Project myProject;

        private MyContentManagerListener(Project project) {
            this.myProject = project;
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            Content content;
            if (event == null) {
                MyContentManagerListener.$$$reportNull$$$0(0);
            }
            if ((content = event.getContent()).getComponent() instanceof SpringToolWindowContentStub) {
                SpringToolWindowContentStub stub = (SpringToolWindowContentStub)content.getComponent();
                SpringToolWindowContent springToolWindowContent = stub.getSpringToolWindowContent();
                SpringBaseView view = ((SpringToolWindowContentProvider)springToolWindowContent.getInstance()).createSpringView(this.myProject);
                content.setComponent((JComponent)((Object)view));
                content.setHelpId(view.getHelpId());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/toolWindow/SpringToolWindowFactory$MyContentManagerListener", "selectionChanged"));
        }
    }
}

