/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.lang.properties.IProperty;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.spi.SpringFactoriesFileType;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastContextKt;

public class SpringSpiRegistrationAnnotator
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<IProperty, Collection<? extends PsiElement>> PROPERTY_CONVERTER = dom -> Collections.singleton(dom.getPsiElement());
    private static final NotNullFunction<IProperty, Collection<? extends GotoRelatedItem>> PROPERTY_RELATED_CONVERTER = dom -> GotoRelatedItem.createItems(Collections.singleton(dom.getPsiElement()), (String)"spring.factories");

    public String getId() {
        return "SpringSpiRegistrationAnnotator";
    }

    public String getName() {
        return SpringBundle.message("SpringSpiRegistrationAnnotator.spring.factories.registration", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return (Icon)SpringFactoriesFileType.ICON.getValue();
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringLibraryUtil.hasSpringLibrary(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (element == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(3);
        }
        if (!SpringLibraryUtil.hasSpringLibrary(element.getProject())) {
            return;
        }
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)element, UClass.class);
        if (uClass == null) {
            return;
        }
        PsiElement nameIdentifier = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (nameIdentifier == null) {
            return;
        }
        final PsiClass psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class);
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return;
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        PairProcessor findFirstProcessor2 = (property, aClass) -> !psiManager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)aClass);
        final String clazzName = uClass.getQualifiedName();
        boolean foundEntry = SpringSpiManager.getInstance(module).processClassesListValues(false, clazzName, (PairProcessor<IProperty, PsiClass>)findFirstProcessor2);
        if (!foundEntry) {
            SpringGutterIconBuilder<IProperty> builder = SpringGutterIconBuilder.createBuilder((Icon)SpringFactoriesFileType.GUTTER_ICON.getValue(), PROPERTY_CONVERTER, PROPERTY_RELATED_CONVERTER);
            builder.setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends IProperty>>(){

                @NotNull
                protected Collection<? extends IProperty> compute() {
                    SmartList mappedConfigKeys = new SmartList();
                    PairProcessor processor2 = (arg_0, arg_1) -> 1.lambda$compute$0(psiManager, psiClass, (List)mappedConfigKeys, arg_0, arg_1);
                    SpringSpiManager.getInstance(module).processClassesListValues(false, clazzName, (PairProcessor<IProperty, PsiClass>)processor2);
                    SmartList smartList = mappedConfigKeys;
                    if (smartList == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return smartList;
                }

                private static /* synthetic */ boolean lambda$compute$0(PsiManager psiManager2, PsiClass psiClass2, List mappedConfigKeys, IProperty property, PsiClass aClass) {
                    if (psiManager2.areElementsEquivalent((PsiElement)psiClass2, (PsiElement)aClass)) {
                        mappedConfigKeys.add(property);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiRegistrationAnnotator$1", "compute"));
                }
            }).setPopupTitle(SpringBundle.message("SpringSpiRegistrationAnnotator.choose.registration", new Object[0])).setTooltipText(SpringBundle.message("SpringSpiRegistrationAnnotator.tooltip", new Object[0]));
            result.add(builder.createSpringRelatedMergeableLineMarkerInfo(nameIdentifier));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/spi/SpringSpiRegistrationAnnotator";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

