/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.run;

import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.run.SpringMultipleOccurrencesFilter;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanNameFilter
extends SpringMultipleOccurrencesFilter {
    private static final String[] DETECTION_MESSAGES = new String[]{"Error creating bean with name '", "containing bean '"};
    private static final NullableFunction<SpringBeanPointer, NavigatablePsiElement> MAPPER = pointer -> {
        PsiElement element = pointer.isValid() ? pointer.getPsiElement() : null;
        return element instanceof NavigatablePsiElement ? (NavigatablePsiElement)element : null;
    };

    BeanNameFilter() {
    }

    @Override
    @Nullable
    protected Filter.Result findNextOccurrence(int startOffset, String line, int entireLength) {
        int index = -1;
        int messageLength = -1;
        for (String message : DETECTION_MESSAGES) {
            index = StringUtil.indexOf((CharSequence)line, (CharSequence)message, (int)startOffset);
            if (index == -1) continue;
            messageLength = message.length();
            break;
        }
        if (index == -1) {
            return null;
        }
        int beanNameStart = index + messageLength;
        int beanNameEnd = StringUtil.indexOf((CharSequence)line, (char)'\'', (int)beanNameStart);
        if (beanNameEnd == -1) {
            return null;
        }
        String beanName = line.substring(beanNameStart, beanNameEnd);
        int textStartOffset = entireLength - line.length() + beanNameStart;
        return new Filter.Result(textStartOffset, textStartOffset + beanName.length(), project -> BeanNameFilter.showResult((Consumer<? super Editor>)((Consumer)editor -> {
            List<SpringBeanPointer> beans = BeanNameFilter.findBeanCandidates(project, beanName);
            if (!beans.isEmpty()) {
                BeanNameFilter.showBeanTargets(editor, beans);
                return;
            }
            PsiClass byBeanName = JavaPsiFacade.getInstance((Project)project).findClass(beanName, GlobalSearchScope.allScope((Project)project));
            if (byBeanName != null) {
                PsiNavigateUtil.navigate((PsiElement)byBeanName);
                return;
            }
            HintManager.getInstance().showErrorHint(editor, SpringBundle.message("model.bean.not.found.error.message", beanName));
        })));
    }

    private static List<SpringBeanPointer> findBeanCandidates(Project project, String beanName) {
        SmartList beans = new SmartList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Set<SpringModel> models = SpringManager.getInstance(project).getAllModelsWithoutDependencies(module);
            for (SpringModel model : models) {
                SpringBeanPointer byName = SpringModelSearchers.findBean(model, beanName);
                ContainerUtil.addIfNotNull((Collection)beans, (Object)byName);
            }
        }
        return beans;
    }

    private static void showBeanTargets(@NotNull Editor editor, Collection<? extends SpringBeanPointer> beans) {
        if (editor == null) {
            BeanNameFilter.$$$reportNull$$$0(0);
        }
        Set targets = ContainerUtil.map2SetNotNull(beans, MAPPER);
        PsiElementListNavigator.openTargets((Editor)editor, (NavigatablePsiElement[])targets.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY), (String)SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0]), (String)SpringBundle.message("spring.bean.show.beans.candidates.title", new Object[0]), SpringBeansPsiElementCellRenderer.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spring/run/BeanNameFilter", "showBeanTargets"));
    }
}

