/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.references.SpringBeanReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanResourceReference
extends SpringBeanReference {
    public SpringBeanResourceReference(PsiElement element, TextRange range, @Nullable PsiClass requiredClass, boolean isFactoryBeanRef) {
        super(element, range, requiredClass, isFactoryBeanRef);
    }

    @Override
    public PsiElement resolve() {
        String beanName = this.getValue();
        CommonSpringModel springModel = this.getSpringModel();
        SpringBeanPointer pointer = SpringModelSearchers.findBean(springModel, beanName);
        return pointer == null || !pointer.isValid() ? SpringBeanResourceReference.resolveResourceByFqn(beanName, springModel, this.getElement().getProject()) : pointer.getPsiElement();
    }

    @Nullable
    public static PsiClass resolveResourceByFqn(@NotNull String beanName, @NotNull CommonSpringModel model, @NotNull Project project) {
        Module module;
        if (beanName == null) {
            SpringBeanResourceReference.$$$reportNull$$$0(0);
        }
        if (model == null) {
            SpringBeanResourceReference.$$$reportNull$$$0(1);
        }
        if (project == null) {
            SpringBeanResourceReference.$$$reportNull$$$0(2);
        }
        GlobalSearchScope scope = (module = model.getModule()) != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)project);
        return JavaPsiFacade.getInstance((Project)project).findClass(beanName.replace("$", "."), scope);
    }

    public boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "beanName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/references/SpringBeanResourceReference";
        objectArray[2] = "resolveResourceByFqn";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

