/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.refactoring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanRenameInputValidator
implements RenameInputValidatorEx {
    @Nullable
    public String getErrorMessage(@NotNull String newName, @NotNull Project project) {
        if (newName == null) {
            SpringBeanRenameInputValidator.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SpringBeanRenameInputValidator.$$$reportNull$$$0(1);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (SpringModel springModel : SpringManager.getInstance(project).getAllModelsWithoutDependencies(module)) {
                SpringBeanPointer foundValue = SpringModelSearchers.findBean(springModel, newName);
                if (foundValue == null) continue;
                return SpringBundle.message("spring.bean.already.exists", newName, foundValue.getContainingFile().getName());
            }
        }
        return null;
    }

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        PsiElementPattern.Capture capture = PlatformPatterns.pomElement((ElementPattern)StandardPatterns.instanceOf(SpringBeanPsiTarget.class));
        if (capture == null) {
            SpringBeanRenameInputValidator.$$$reportNull$$$0(2);
        }
        return capture;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (newName == null) {
            SpringBeanRenameInputValidator.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SpringBeanRenameInputValidator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SpringBeanRenameInputValidator.$$$reportNull$$$0(5);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/refactoring/SpringBeanRenameInputValidator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/refactoring/SpringBeanRenameInputValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInputValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

