/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.profiles.SpringChangeActiveProfilesAction;
import com.intellij.spring.profiles.SpringProfilesPanel;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.xml.DomChangeAdapter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringProfilesEditorNotificationsProvider
extends EditorNotifications.Provider<SpringProfilesPanel> {
    private static final Key<SpringProfilesPanel> KEY = Key.create((String)"SpringProfilesPanelKey");

    public SpringProfilesEditorNotificationsProvider(final @NotNull Project project) {
        if (project == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(0);
        }
        DomManager.getDomManager((Project)project).addDomEventListener((DomEventListener)new DomChangeAdapter(){

            protected void elementChanged(DomElement element) {
                DomFileElement domFileElement = (DomFileElement)DomUtil.getParentOfType((DomElement)element, DomFileElement.class, (boolean)false);
                if (domFileElement != null && domFileElement.isValid() && domFileElement.getRootElement() instanceof Beans) {
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                }
            }
        }, (Disposable)SpringGeneralSettings.getInstance(project));
    }

    @NotNull
    public Key<SpringProfilesPanel> getKey() {
        Key<SpringProfilesPanel> key = KEY;
        if (key == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    public SpringProfilesPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(4);
        }
        if (!SpringGeneralSettings.getInstance(project).isShowProfilesPanel()) {
            return null;
        }
        if (!SpringCommonUtils.hasSpringFacets(project)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        SpringModel springModel = SpringChangeActiveProfilesAction.getSpringModel(psiFile);
        if (springModel == null || springModel.getFileSet() == null) {
            return null;
        }
        Set<String> allProfiles = SpringModelVisitorUtils.getProfiles(springModel);
        Set<String> activeProfiles = springModel.getActiveProfiles();
        if (allProfiles.size() == 1 && "_DEFAULT_PROFILE_NAME_".equals(allProfiles.iterator().next()) && (activeProfiles == null || activeProfiles.isEmpty())) {
            return null;
        }
        if (allProfiles.isEmpty()) {
            return null;
        }
        return new SpringProfilesPanel(project, SpringProfileUtils.profilesAsString(activeProfiles), SpringProfilesEditorNotificationsProvider.isFileInActiveProfile(psiFile, springModel));
    }

    private static boolean isFileInActiveProfile(PsiFile file, SpringModel model) {
        if (file instanceof XmlFile) {
            return true;
        }
        return SpringModelVisitorUtils.hasConfigFile(model, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

