/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.profiles.SpringProfileTarget;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class SpringProfilePsiReference
extends PsiReferenceBase<PsiElement> {
    private final String myProfileName;
    private final Module myModule;
    private final boolean myIsDefinition;

    public SpringProfilePsiReference(@NotNull PsiElement element, @NotNull TextRange range, @NotNull Module module, boolean definition) {
        if (element == null) {
            SpringProfilePsiReference.$$$reportNull$$$0(0);
        }
        if (range == null) {
            SpringProfilePsiReference.$$$reportNull$$$0(1);
        }
        if (module == null) {
            SpringProfilePsiReference.$$$reportNull$$$0(2);
        }
        super(element, range);
        this.myIsDefinition = definition;
        this.myProfileName = range.substring(element.getText());
        this.myModule = module;
    }

    public PsiElement resolve() {
        if (StringUtil.isEmptyOrSpaces((String)this.myProfileName)) {
            return this.myElement;
        }
        SpringProfileTarget target = this.myIsDefinition ? new SpringProfileTarget(this.getElement(), this.myProfileName, this.getRangeInElement().getStartOffset()) : SpringProfilesFactory.getInstance().findProfileTarget(this.myModule, this.includeTestScope(), this.myProfileName);
        return target == null ? null : PomService.convertToPsi((Project)this.getElement().getProject(), (PomTarget)target);
    }

    public boolean isSoft() {
        return true;
    }

    public Object @NotNull [] getVariants() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (SpringProfileTarget target : SpringProfilesFactory.getInstance().findProfileTargets(this.myModule, this.includeTestScope())) {
            names.add(target.getName());
        }
        Object[] objectArray = ContainerUtil.map2Array(names, Object.class, name -> LookupElementBuilder.create((String)name).withIcon(SpringApiIcons.SpringProfile));
        if (objectArray == null) {
            SpringProfilePsiReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    private boolean includeTestScope() {
        PsiFile file = this.myElement.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return ModuleRootManager.getInstance((Module)this.myModule).getFileIndex().isInTestSourceContent(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/profiles/SpringProfilePsiReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/profiles/SpringProfilePsiReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

